/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkloadIdentityRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<UpdateWorkloadIdentityRequest.Builder, UpdateWorkloadIdentityRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateWorkloadIdentityRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedResourceOauth2ReturnUrls")
            .getter(getter(UpdateWorkloadIdentityRequest::allowedResourceOauth2ReturnUrls))
            .setter(setter(Builder::allowedResourceOauth2ReturnUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResourceOauth2ReturnUrls")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final List<String> allowedResourceOauth2ReturnUrls;

    private UpdateWorkloadIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.allowedResourceOauth2ReturnUrls = builder.allowedResourceOauth2ReturnUrls;
    }

    /**
     * <p>
     * The name of the workload identity to update.
     * </p>
     * 
     * @return The name of the workload identity to update.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedResourceOauth2ReturnUrls
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAllowedResourceOauth2ReturnUrls() {
        return allowedResourceOauth2ReturnUrls != null && !(allowedResourceOauth2ReturnUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new list of allowed OAuth2 return URLs for resources associated with this workload identity. This list
     * replaces the existing list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedResourceOauth2ReturnUrls}
     * method.
     * </p>
     * 
     * @return The new list of allowed OAuth2 return URLs for resources associated with this workload identity. This
     *         list replaces the existing list.
     */
    public final List<String> allowedResourceOauth2ReturnUrls() {
        return allowedResourceOauth2ReturnUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAllowedResourceOauth2ReturnUrls() ? allowedResourceOauth2ReturnUrls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadIdentityRequest)) {
            return false;
        }
        UpdateWorkloadIdentityRequest other = (UpdateWorkloadIdentityRequest) obj;
        return Objects.equals(name(), other.name())
                && hasAllowedResourceOauth2ReturnUrls() == other.hasAllowedResourceOauth2ReturnUrls()
                && Objects.equals(allowedResourceOauth2ReturnUrls(), other.allowedResourceOauth2ReturnUrls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateWorkloadIdentityRequest")
                .add("Name", name())
                .add("AllowedResourceOauth2ReturnUrls",
                        hasAllowedResourceOauth2ReturnUrls() ? allowedResourceOauth2ReturnUrls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "allowedResourceOauth2ReturnUrls":
            return Optional.ofNullable(clazz.cast(allowedResourceOauth2ReturnUrls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("allowedResourceOauth2ReturnUrls", ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadIdentityRequest, T> g) {
        return obj -> g.apply((UpdateWorkloadIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkloadIdentityRequest> {
        /**
         * <p>
         * The name of the workload identity to update.
         * </p>
         * 
         * @param name
         *        The name of the workload identity to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new list of allowed OAuth2 return URLs for resources associated with this workload identity. This list
         * replaces the existing list.
         * </p>
         * 
         * @param allowedResourceOauth2ReturnUrls
         *        The new list of allowed OAuth2 return URLs for resources associated with this workload identity. This
         *        list replaces the existing list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls);

        /**
         * <p>
         * The new list of allowed OAuth2 return URLs for resources associated with this workload identity. This list
         * replaces the existing list.
         * </p>
         * 
         * @param allowedResourceOauth2ReturnUrls
         *        The new list of allowed OAuth2 return URLs for resources associated with this workload identity. This
         *        list replaces the existing list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResourceOauth2ReturnUrls(String... allowedResourceOauth2ReturnUrls);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String name;

        private List<String> allowedResourceOauth2ReturnUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadIdentityRequest model) {
            super(model);
            name(model.name);
            allowedResourceOauth2ReturnUrls(model.allowedResourceOauth2ReturnUrls);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getAllowedResourceOauth2ReturnUrls() {
            if (allowedResourceOauth2ReturnUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedResourceOauth2ReturnUrls;
        }

        public final void setAllowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls) {
            this.allowedResourceOauth2ReturnUrls = ResourceOauth2ReturnUrlListTypeCopier.copy(allowedResourceOauth2ReturnUrls);
        }

        @Override
        public final Builder allowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls) {
            this.allowedResourceOauth2ReturnUrls = ResourceOauth2ReturnUrlListTypeCopier.copy(allowedResourceOauth2ReturnUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResourceOauth2ReturnUrls(String... allowedResourceOauth2ReturnUrls) {
            allowedResourceOauth2ReturnUrls(Arrays.asList(allowedResourceOauth2ReturnUrls));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkloadIdentityRequest build() {
            return new UpdateWorkloadIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
