/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentRuntimeResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<UpdateAgentRuntimeResponse.Builder, UpdateAgentRuntimeResponse> {
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeArn").getter(getter(UpdateAgentRuntimeResponse::agentRuntimeArn))
            .setter(setter(Builder::agentRuntimeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeId").getter(getter(UpdateAgentRuntimeResponse::agentRuntimeId))
            .setter(setter(Builder::agentRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()).build();

    private static final SdkField<WorkloadIdentityDetails> WORKLOAD_IDENTITY_DETAILS_FIELD = SdkField
            .<WorkloadIdentityDetails> builder(MarshallingType.SDK_POJO).memberName("workloadIdentityDetails")
            .getter(getter(UpdateAgentRuntimeResponse::workloadIdentityDetails)).setter(setter(Builder::workloadIdentityDetails))
            .constructor(WorkloadIdentityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityDetails").build())
            .build();

    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeVersion").getter(getter(UpdateAgentRuntimeResponse::agentRuntimeVersion))
            .setter(setter(Builder::agentRuntimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeVersion").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UpdateAgentRuntimeResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(UpdateAgentRuntimeResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateAgentRuntimeResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ARN_FIELD,
            AGENT_RUNTIME_ID_FIELD, WORKLOAD_IDENTITY_DETAILS_FIELD, AGENT_RUNTIME_VERSION_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentRuntimeArn;

    private final String agentRuntimeId;

    private final WorkloadIdentityDetails workloadIdentityDetails;

    private final String agentRuntimeVersion;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String status;

    private UpdateAgentRuntimeResponse(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.workloadIdentityDetails = builder.workloadIdentityDetails;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the updated agent runtime.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the updated agent runtime.
     */
    public final String agentRuntimeArn() {
        return agentRuntimeArn;
    }

    /**
     * <p>
     * The unique identifier of the updated agent runtime.
     * </p>
     * 
     * @return The unique identifier of the updated agent runtime.
     */
    public final String agentRuntimeId() {
        return agentRuntimeId;
    }

    /**
     * <p>
     * The workload identity details for the updated agent runtime.
     * </p>
     * 
     * @return The workload identity details for the updated agent runtime.
     */
    public final WorkloadIdentityDetails workloadIdentityDetails() {
        return workloadIdentityDetails;
    }

    /**
     * <p>
     * The version of the updated agent runtime.
     * </p>
     * 
     * @return The version of the updated agent runtime.
     */
    public final String agentRuntimeVersion() {
        return agentRuntimeVersion;
    }

    /**
     * <p>
     * The timestamp when the agent runtime was created.
     * </p>
     * 
     * @return The timestamp when the agent runtime was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the agent runtime was last updated.
     * </p>
     * 
     * @return The timestamp when the agent runtime was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The current status of the updated agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the updated agent runtime.
     * @see AgentStatus
     */
    public final AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the updated agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the updated agent runtime.
     * @see AgentStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadIdentityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentRuntimeResponse)) {
            return false;
        }
        UpdateAgentRuntimeResponse other = (UpdateAgentRuntimeResponse) obj;
        return Objects.equals(agentRuntimeArn(), other.agentRuntimeArn())
                && Objects.equals(agentRuntimeId(), other.agentRuntimeId())
                && Objects.equals(workloadIdentityDetails(), other.workloadIdentityDetails())
                && Objects.equals(agentRuntimeVersion(), other.agentRuntimeVersion())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAgentRuntimeResponse").add("AgentRuntimeArn", agentRuntimeArn())
                .add("AgentRuntimeId", agentRuntimeId()).add("WorkloadIdentityDetails", workloadIdentityDetails())
                .add("AgentRuntimeVersion", agentRuntimeVersion()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimeArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeArn()));
        case "agentRuntimeId":
            return Optional.ofNullable(clazz.cast(agentRuntimeId()));
        case "workloadIdentityDetails":
            return Optional.ofNullable(clazz.cast(workloadIdentityDetails()));
        case "agentRuntimeVersion":
            return Optional.ofNullable(clazz.cast(agentRuntimeVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("workloadIdentityDetails", WORKLOAD_IDENTITY_DETAILS_FIELD);
        map.put("agentRuntimeVersion", AGENT_RUNTIME_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentRuntimeResponse, T> g) {
        return obj -> g.apply((UpdateAgentRuntimeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAgentRuntimeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the updated agent runtime.
         * </p>
         * 
         * @param agentRuntimeArn
         *        The Amazon Resource Name (ARN) of the updated agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArn(String agentRuntimeArn);

        /**
         * <p>
         * The unique identifier of the updated agent runtime.
         * </p>
         * 
         * @param agentRuntimeId
         *        The unique identifier of the updated agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeId(String agentRuntimeId);

        /**
         * <p>
         * The workload identity details for the updated agent runtime.
         * </p>
         * 
         * @param workloadIdentityDetails
         *        The workload identity details for the updated agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails);

        /**
         * <p>
         * The workload identity details for the updated agent runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadIdentityDetails.Builder} avoiding
         * the need to create one manually via {@link WorkloadIdentityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadIdentityDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #workloadIdentityDetails(WorkloadIdentityDetails)}.
         * 
         * @param workloadIdentityDetails
         *        a consumer that will call methods on {@link WorkloadIdentityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadIdentityDetails(WorkloadIdentityDetails)
         */
        default Builder workloadIdentityDetails(Consumer<WorkloadIdentityDetails.Builder> workloadIdentityDetails) {
            return workloadIdentityDetails(WorkloadIdentityDetails.builder().applyMutation(workloadIdentityDetails).build());
        }

        /**
         * <p>
         * The version of the updated agent runtime.
         * </p>
         * 
         * @param agentRuntimeVersion
         *        The version of the updated agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeVersion(String agentRuntimeVersion);

        /**
         * <p>
         * The timestamp when the agent runtime was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the agent runtime was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the agent runtime was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the agent runtime was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The current status of the updated agent runtime.
         * </p>
         * 
         * @param status
         *        The current status of the updated agent runtime.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the updated agent runtime.
         * </p>
         * 
         * @param status
         *        The current status of the updated agent runtime.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String agentRuntimeArn;

        private String agentRuntimeId;

        private WorkloadIdentityDetails workloadIdentityDetails;

        private String agentRuntimeVersion;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentRuntimeResponse model) {
            super(model);
            agentRuntimeArn(model.agentRuntimeArn);
            agentRuntimeId(model.agentRuntimeId);
            workloadIdentityDetails(model.workloadIdentityDetails);
            agentRuntimeVersion(model.agentRuntimeVersion);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            status(model.status);
        }

        public final String getAgentRuntimeArn() {
            return agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getAgentRuntimeId() {
            return agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final WorkloadIdentityDetails.Builder getWorkloadIdentityDetails() {
            return workloadIdentityDetails != null ? workloadIdentityDetails.toBuilder() : null;
        }

        public final void setWorkloadIdentityDetails(WorkloadIdentityDetails.BuilderImpl workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails != null ? workloadIdentityDetails.build() : null;
        }

        @Override
        public final Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateAgentRuntimeResponse build() {
            return new UpdateAgentRuntimeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
