/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ToolDefinitionsCopier {
    static List<ToolDefinition> copy(Collection<? extends ToolDefinition> toolDefinitionsParam) {
        List<ToolDefinition> list;
        if (toolDefinitionsParam == null || toolDefinitionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ToolDefinition> modifiableList = new ArrayList<>(toolDefinitionsParam.size());
            toolDefinitionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ToolDefinition> copyFromBuilder(Collection<? extends ToolDefinition.Builder> toolDefinitionsParam) {
        List<ToolDefinition> list;
        if (toolDefinitionsParam == null || toolDefinitionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ToolDefinition> modifiableList = new ArrayList<>(toolDefinitionsParam.size());
            toolDefinitionsParam.forEach(entry -> {
                ToolDefinition member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ToolDefinition.Builder> copyToBuilder(Collection<? extends ToolDefinition> toolDefinitionsParam) {
        List<ToolDefinition.Builder> list;
        if (toolDefinitionsParam == null || toolDefinitionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ToolDefinition.Builder> modifiableList = new ArrayList<>(toolDefinitionsParam.size());
            toolDefinitionsParam.forEach(entry -> {
                ToolDefinition.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
