/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tool definition for a gateway target. This structure defines a tool that the target exposes through the Model
 * Context Protocol.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolDefinition implements SdkPojo, Serializable, ToCopyableBuilder<ToolDefinition.Builder, ToolDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ToolDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ToolDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SchemaDefinition> INPUT_SCHEMA_FIELD = SdkField
            .<SchemaDefinition> builder(MarshallingType.SDK_POJO).memberName("inputSchema")
            .getter(getter(ToolDefinition::inputSchema)).setter(setter(Builder::inputSchema))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSchema").build()).build();

    private static final SdkField<SchemaDefinition> OUTPUT_SCHEMA_FIELD = SdkField
            .<SchemaDefinition> builder(MarshallingType.SDK_POJO).memberName("outputSchema")
            .getter(getter(ToolDefinition::outputSchema)).setter(setter(Builder::outputSchema))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            INPUT_SCHEMA_FIELD, OUTPUT_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final SchemaDefinition inputSchema;

    private final SchemaDefinition outputSchema;

    private ToolDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.inputSchema = builder.inputSchema;
        this.outputSchema = builder.outputSchema;
    }

    /**
     * <p>
     * The name of the tool. This name identifies the tool in the Model Context Protocol.
     * </p>
     * 
     * @return The name of the tool. This name identifies the tool in the Model Context Protocol.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the tool. This description provides information about the purpose and usage of the tool.
     * </p>
     * 
     * @return The description of the tool. This description provides information about the purpose and usage of the
     *         tool.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The input schema for the tool. This schema defines the structure of the input that the tool accepts.
     * </p>
     * 
     * @return The input schema for the tool. This schema defines the structure of the input that the tool accepts.
     */
    public final SchemaDefinition inputSchema() {
        return inputSchema;
    }

    /**
     * <p>
     * The output schema for the tool. This schema defines the structure of the output that the tool produces.
     * </p>
     * 
     * @return The output schema for the tool. This schema defines the structure of the output that the tool produces.
     */
    public final SchemaDefinition outputSchema() {
        return outputSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(outputSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolDefinition)) {
            return false;
        }
        ToolDefinition other = (ToolDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(inputSchema(), other.inputSchema()) && Objects.equals(outputSchema(), other.outputSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolDefinition").add("Name", name()).add("Description", description())
                .add("InputSchema", inputSchema()).add("OutputSchema", outputSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputSchema":
            return Optional.ofNullable(clazz.cast(inputSchema()));
        case "outputSchema":
            return Optional.ofNullable(clazz.cast(outputSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputSchema", INPUT_SCHEMA_FIELD);
        map.put("outputSchema", OUTPUT_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolDefinition, T> g) {
        return obj -> g.apply((ToolDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolDefinition> {
        /**
         * <p>
         * The name of the tool. This name identifies the tool in the Model Context Protocol.
         * </p>
         * 
         * @param name
         *        The name of the tool. This name identifies the tool in the Model Context Protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the tool. This description provides information about the purpose and usage of the tool.
         * </p>
         * 
         * @param description
         *        The description of the tool. This description provides information about the purpose and usage of the
         *        tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The input schema for the tool. This schema defines the structure of the input that the tool accepts.
         * </p>
         * 
         * @param inputSchema
         *        The input schema for the tool. This schema defines the structure of the input that the tool accepts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(SchemaDefinition inputSchema);

        /**
         * <p>
         * The input schema for the tool. This schema defines the structure of the input that the tool accepts.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchema(SchemaDefinition)}.
         * 
         * @param inputSchema
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchema(SchemaDefinition)
         */
        default Builder inputSchema(Consumer<SchemaDefinition.Builder> inputSchema) {
            return inputSchema(SchemaDefinition.builder().applyMutation(inputSchema).build());
        }

        /**
         * <p>
         * The output schema for the tool. This schema defines the structure of the output that the tool produces.
         * </p>
         * 
         * @param outputSchema
         *        The output schema for the tool. This schema defines the structure of the output that the tool
         *        produces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSchema(SchemaDefinition outputSchema);

        /**
         * <p>
         * The output schema for the tool. This schema defines the structure of the output that the tool produces.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #outputSchema(SchemaDefinition)}.
         * 
         * @param outputSchema
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSchema(SchemaDefinition)
         */
        default Builder outputSchema(Consumer<SchemaDefinition.Builder> outputSchema) {
            return outputSchema(SchemaDefinition.builder().applyMutation(outputSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private SchemaDefinition inputSchema;

        private SchemaDefinition outputSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolDefinition model) {
            name(model.name);
            description(model.description);
            inputSchema(model.inputSchema);
            outputSchema(model.outputSchema);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SchemaDefinition.Builder getInputSchema() {
            return inputSchema != null ? inputSchema.toBuilder() : null;
        }

        public final void setInputSchema(SchemaDefinition.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        public final Builder inputSchema(SchemaDefinition inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final SchemaDefinition.Builder getOutputSchema() {
            return outputSchema != null ? outputSchema.toBuilder() : null;
        }

        public final void setOutputSchema(SchemaDefinition.BuilderImpl outputSchema) {
            this.outputSchema = outputSchema != null ? outputSchema.build() : null;
        }

        @Override
        public final Builder outputSchema(SchemaDefinition outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        @Override
        public ToolDefinition build() {
            return new ToolDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
