/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for semantic override configuration in a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemanticOverrideConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<SemanticOverrideConfigurationInput.Builder, SemanticOverrideConfigurationInput> {
    private static final SdkField<SemanticOverrideExtractionConfigurationInput> EXTRACTION_FIELD = SdkField
            .<SemanticOverrideExtractionConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("extraction")
            .getter(getter(SemanticOverrideConfigurationInput::extraction)).setter(setter(Builder::extraction))
            .constructor(SemanticOverrideExtractionConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()).build();

    private static final SdkField<SemanticOverrideConsolidationConfigurationInput> CONSOLIDATION_FIELD = SdkField
            .<SemanticOverrideConsolidationConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("consolidation")
            .getter(getter(SemanticOverrideConfigurationInput::consolidation)).setter(setter(Builder::consolidation))
            .constructor(SemanticOverrideConsolidationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD,
            CONSOLIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SemanticOverrideExtractionConfigurationInput extraction;

    private final SemanticOverrideConsolidationConfigurationInput consolidation;

    private SemanticOverrideConfigurationInput(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.consolidation = builder.consolidation;
    }

    /**
     * <p>
     * The extraction configuration for a semantic override.
     * </p>
     * 
     * @return The extraction configuration for a semantic override.
     */
    public final SemanticOverrideExtractionConfigurationInput extraction() {
        return extraction;
    }

    /**
     * <p>
     * The consolidation configuration for a semantic override.
     * </p>
     * 
     * @return The consolidation configuration for a semantic override.
     */
    public final SemanticOverrideConsolidationConfigurationInput consolidation() {
        return consolidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraction());
        hashCode = 31 * hashCode + Objects.hashCode(consolidation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticOverrideConfigurationInput)) {
            return false;
        }
        SemanticOverrideConfigurationInput other = (SemanticOverrideConfigurationInput) obj;
        return Objects.equals(extraction(), other.extraction()) && Objects.equals(consolidation(), other.consolidation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemanticOverrideConfigurationInput").add("Extraction", extraction())
                .add("Consolidation", consolidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraction":
            return Optional.ofNullable(clazz.cast(extraction()));
        case "consolidation":
            return Optional.ofNullable(clazz.cast(consolidation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("consolidation", CONSOLIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticOverrideConfigurationInput, T> g) {
        return obj -> g.apply((SemanticOverrideConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemanticOverrideConfigurationInput> {
        /**
         * <p>
         * The extraction configuration for a semantic override.
         * </p>
         * 
         * @param extraction
         *        The extraction configuration for a semantic override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraction(SemanticOverrideExtractionConfigurationInput extraction);

        /**
         * <p>
         * The extraction configuration for a semantic override.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SemanticOverrideExtractionConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SemanticOverrideExtractionConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticOverrideExtractionConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #extraction(SemanticOverrideExtractionConfigurationInput)}.
         * 
         * @param extraction
         *        a consumer that will call methods on {@link SemanticOverrideExtractionConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraction(SemanticOverrideExtractionConfigurationInput)
         */
        default Builder extraction(Consumer<SemanticOverrideExtractionConfigurationInput.Builder> extraction) {
            return extraction(SemanticOverrideExtractionConfigurationInput.builder().applyMutation(extraction).build());
        }

        /**
         * <p>
         * The consolidation configuration for a semantic override.
         * </p>
         * 
         * @param consolidation
         *        The consolidation configuration for a semantic override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consolidation(SemanticOverrideConsolidationConfigurationInput consolidation);

        /**
         * <p>
         * The consolidation configuration for a semantic override.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SemanticOverrideConsolidationConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SemanticOverrideConsolidationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticOverrideConsolidationConfigurationInput.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #consolidation(SemanticOverrideConsolidationConfigurationInput)}.
         * 
         * @param consolidation
         *        a consumer that will call methods on {@link SemanticOverrideConsolidationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consolidation(SemanticOverrideConsolidationConfigurationInput)
         */
        default Builder consolidation(Consumer<SemanticOverrideConsolidationConfigurationInput.Builder> consolidation) {
            return consolidation(SemanticOverrideConsolidationConfigurationInput.builder().applyMutation(consolidation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemanticOverrideExtractionConfigurationInput extraction;

        private SemanticOverrideConsolidationConfigurationInput consolidation;

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticOverrideConfigurationInput model) {
            extraction(model.extraction);
            consolidation(model.consolidation);
        }

        public final SemanticOverrideExtractionConfigurationInput.Builder getExtraction() {
            return extraction != null ? extraction.toBuilder() : null;
        }

        public final void setExtraction(SemanticOverrideExtractionConfigurationInput.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(SemanticOverrideExtractionConfigurationInput extraction) {
            this.extraction = extraction;
            return this;
        }

        public final SemanticOverrideConsolidationConfigurationInput.Builder getConsolidation() {
            return consolidation != null ? consolidation.toBuilder() : null;
        }

        public final void setConsolidation(SemanticOverrideConsolidationConfigurationInput.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(SemanticOverrideConsolidationConfigurationInput consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        @Override
        public SemanticOverrideConfigurationInput build() {
            return new SemanticOverrideConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
