/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 configuration for a gateway. This structure defines how the gateway accesses files in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Configuration implements SdkPojo, Serializable, ToCopyableBuilder<S3Configuration.Builder, S3Configuration> {
    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(S3Configuration::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final SdkField<String> BUCKET_OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketOwnerAccountId").getter(getter(S3Configuration::bucketOwnerAccountId))
            .setter(setter(Builder::bucketOwnerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwnerAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD,
            BUCKET_OWNER_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String uri;

    private final String bucketOwnerAccountId;

    private S3Configuration(BuilderImpl builder) {
        this.uri = builder.uri;
        this.bucketOwnerAccountId = builder.bucketOwnerAccountId;
    }

    /**
     * <p>
     * The URI of the Amazon S3 object. This URI specifies the location of the object in Amazon S3.
     * </p>
     * 
     * @return The URI of the Amazon S3 object. This URI specifies the location of the object in Amazon S3.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The account ID of the Amazon S3 bucket owner. This ID is used for cross-account access to the bucket.
     * </p>
     * 
     * @return The account ID of the Amazon S3 bucket owner. This ID is used for cross-account access to the bucket.
     */
    public final String bucketOwnerAccountId() {
        return bucketOwnerAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwnerAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Configuration)) {
            return false;
        }
        S3Configuration other = (S3Configuration) obj;
        return Objects.equals(uri(), other.uri()) && Objects.equals(bucketOwnerAccountId(), other.bucketOwnerAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Configuration").add("Uri", uri()).add("BucketOwnerAccountId", bucketOwnerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "bucketOwnerAccountId":
            return Optional.ofNullable(clazz.cast(bucketOwnerAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("uri", URI_FIELD);
        map.put("bucketOwnerAccountId", BUCKET_OWNER_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Configuration, T> g) {
        return obj -> g.apply((S3Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Configuration> {
        /**
         * <p>
         * The URI of the Amazon S3 object. This URI specifies the location of the object in Amazon S3.
         * </p>
         * 
         * @param uri
         *        The URI of the Amazon S3 object. This URI specifies the location of the object in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The account ID of the Amazon S3 bucket owner. This ID is used for cross-account access to the bucket.
         * </p>
         * 
         * @param bucketOwnerAccountId
         *        The account ID of the Amazon S3 bucket owner. This ID is used for cross-account access to the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketOwnerAccountId(String bucketOwnerAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String uri;

        private String bucketOwnerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Configuration model) {
            uri(model.uri);
            bucketOwnerAccountId(model.bucketOwnerAccountId);
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getBucketOwnerAccountId() {
            return bucketOwnerAccountId;
        }

        public final void setBucketOwnerAccountId(String bucketOwnerAccountId) {
            this.bucketOwnerAccountId = bucketOwnerAccountId;
        }

        @Override
        public final Builder bucketOwnerAccountId(String bucketOwnerAccountId) {
            this.bucketOwnerAccountId = bucketOwnerAccountId;
            return this;
        }

        @Override
        public S3Configuration build() {
            return new S3Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
