/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The protocol configuration for an agent runtime. This structure defines how the agent runtime communicates with
 * clients.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtocolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtocolConfiguration.Builder, ProtocolConfiguration> {
    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverProtocol").getter(getter(ProtocolConfiguration::serverProtocolAsString))
            .setter(setter(Builder::serverProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverProtocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverProtocol;

    private ProtocolConfiguration(BuilderImpl builder) {
        this.serverProtocol = builder.serverProtocol;
    }

    /**
     * <p>
     * The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses to
     * communicate with clients.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses to
     *         communicate with clients.
     * @see ServerProtocol
     */
    public final ServerProtocol serverProtocol() {
        return ServerProtocol.fromValue(serverProtocol);
    }

    /**
     * <p>
     * The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses to
     * communicate with clients.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link ServerProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses to
     *         communicate with clients.
     * @see ServerProtocol
     */
    public final String serverProtocolAsString() {
        return serverProtocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverProtocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolConfiguration)) {
            return false;
        }
        ProtocolConfiguration other = (ProtocolConfiguration) obj;
        return Objects.equals(serverProtocolAsString(), other.serverProtocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtocolConfiguration").add("ServerProtocol", serverProtocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverProtocol":
            return Optional.ofNullable(clazz.cast(serverProtocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serverProtocol", SERVER_PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtocolConfiguration, T> g) {
        return obj -> g.apply((ProtocolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtocolConfiguration> {
        /**
         * <p>
         * The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses to
         * communicate with clients.
         * </p>
         * 
         * @param serverProtocol
         *        The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses
         *        to communicate with clients.
         * @see ServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerProtocol
         */
        Builder serverProtocol(String serverProtocol);

        /**
         * <p>
         * The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses to
         * communicate with clients.
         * </p>
         * 
         * @param serverProtocol
         *        The server protocol for the agent runtime. This field specifies which protocol the agent runtime uses
         *        to communicate with clients.
         * @see ServerProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerProtocol
         */
        Builder serverProtocol(ServerProtocol serverProtocol);
    }

    static final class BuilderImpl implements Builder {
        private String serverProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolConfiguration model) {
            serverProtocol(model.serverProtocol);
        }

        public final String getServerProtocol() {
            return serverProtocol;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(ServerProtocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        @Override
        public ProtocolConfiguration build() {
            return new ProtocolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
