/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the discovery information for an OAuth2 provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Oauth2Discovery implements SdkPojo, Serializable, ToCopyableBuilder<Oauth2Discovery.Builder, Oauth2Discovery> {
    private static final SdkField<String> DISCOVERY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("discoveryUrl").getter(getter(Oauth2Discovery::discoveryUrl)).setter(setter(Builder::discoveryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryUrl").build()).build();

    private static final SdkField<Oauth2AuthorizationServerMetadata> AUTHORIZATION_SERVER_METADATA_FIELD = SdkField
            .<Oauth2AuthorizationServerMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("authorizationServerMetadata")
            .getter(getter(Oauth2Discovery::authorizationServerMetadata))
            .setter(setter(Builder::authorizationServerMetadata))
            .constructor(Oauth2AuthorizationServerMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationServerMetadata")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_URL_FIELD,
            AUTHORIZATION_SERVER_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String discoveryUrl;

    private final Oauth2AuthorizationServerMetadata authorizationServerMetadata;

    private final Type type;

    private Oauth2Discovery(BuilderImpl builder) {
        this.discoveryUrl = builder.discoveryUrl;
        this.authorizationServerMetadata = builder.authorizationServerMetadata;
        this.type = builder.type;
    }

    /**
     * <p>
     * The discovery URL for the OAuth2 provider.
     * </p>
     * 
     * @return The discovery URL for the OAuth2 provider.
     */
    public final String discoveryUrl() {
        return discoveryUrl;
    }

    /**
     * <p>
     * The authorization server metadata for the OAuth2 provider.
     * </p>
     * 
     * @return The authorization server metadata for the OAuth2 provider.
     */
    public final Oauth2AuthorizationServerMetadata authorizationServerMetadata() {
        return authorizationServerMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(discoveryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationServerMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Oauth2Discovery)) {
            return false;
        }
        Oauth2Discovery other = (Oauth2Discovery) obj;
        return Objects.equals(discoveryUrl(), other.discoveryUrl())
                && Objects.equals(authorizationServerMetadata(), other.authorizationServerMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Oauth2Discovery").add("DiscoveryUrl", discoveryUrl())
                .add("AuthorizationServerMetadata", authorizationServerMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "discoveryUrl":
            return Optional.ofNullable(clazz.cast(discoveryUrl()));
        case "authorizationServerMetadata":
            return Optional.ofNullable(clazz.cast(authorizationServerMetadata()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #discoveryUrl()} initialized to the given value.
     *
     * <p>
     * The discovery URL for the OAuth2 provider.
     * </p>
     * 
     * @param discoveryUrl
     *        The discovery URL for the OAuth2 provider.
     */
    public static Oauth2Discovery fromDiscoveryUrl(String discoveryUrl) {
        return builder().discoveryUrl(discoveryUrl).build();
    }

    /**
     * Create an instance of this class with {@link #authorizationServerMetadata()} initialized to the given value.
     *
     * <p>
     * The authorization server metadata for the OAuth2 provider.
     * </p>
     * 
     * @param authorizationServerMetadata
     *        The authorization server metadata for the OAuth2 provider.
     */
    public static Oauth2Discovery fromAuthorizationServerMetadata(Oauth2AuthorizationServerMetadata authorizationServerMetadata) {
        return builder().authorizationServerMetadata(authorizationServerMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #authorizationServerMetadata()} initialized to the given value.
     *
     * <p>
     * The authorization server metadata for the OAuth2 provider.
     * </p>
     * 
     * @param authorizationServerMetadata
     *        The authorization server metadata for the OAuth2 provider.
     */
    public static Oauth2Discovery fromAuthorizationServerMetadata(
            Consumer<Oauth2AuthorizationServerMetadata.Builder> authorizationServerMetadata) {
        Oauth2AuthorizationServerMetadata.Builder builder = Oauth2AuthorizationServerMetadata.builder();
        authorizationServerMetadata.accept(builder);
        return fromAuthorizationServerMetadata(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("discoveryUrl", DISCOVERY_URL_FIELD);
        map.put("authorizationServerMetadata", AUTHORIZATION_SERVER_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Oauth2Discovery, T> g) {
        return obj -> g.apply((Oauth2Discovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Oauth2Discovery> {
        /**
         * <p>
         * The discovery URL for the OAuth2 provider.
         * </p>
         * 
         * @param discoveryUrl
         *        The discovery URL for the OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryUrl(String discoveryUrl);

        /**
         * <p>
         * The authorization server metadata for the OAuth2 provider.
         * </p>
         * 
         * @param authorizationServerMetadata
         *        The authorization server metadata for the OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationServerMetadata(Oauth2AuthorizationServerMetadata authorizationServerMetadata);

        /**
         * <p>
         * The authorization server metadata for the OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link Oauth2AuthorizationServerMetadata.Builder} avoiding the need to create one manually via
         * {@link Oauth2AuthorizationServerMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Oauth2AuthorizationServerMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #authorizationServerMetadata(Oauth2AuthorizationServerMetadata)}.
         * 
         * @param authorizationServerMetadata
         *        a consumer that will call methods on {@link Oauth2AuthorizationServerMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationServerMetadata(Oauth2AuthorizationServerMetadata)
         */
        default Builder authorizationServerMetadata(
                Consumer<Oauth2AuthorizationServerMetadata.Builder> authorizationServerMetadata) {
            return authorizationServerMetadata(Oauth2AuthorizationServerMetadata.builder()
                    .applyMutation(authorizationServerMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String discoveryUrl;

        private Oauth2AuthorizationServerMetadata authorizationServerMetadata;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Oauth2Discovery model) {
            discoveryUrl(model.discoveryUrl);
            authorizationServerMetadata(model.authorizationServerMetadata);
        }

        public final String getDiscoveryUrl() {
            return discoveryUrl;
        }

        public final void setDiscoveryUrl(String discoveryUrl) {
            Object oldValue = this.discoveryUrl;
            this.discoveryUrl = discoveryUrl;
            handleUnionValueChange(Type.DISCOVERY_URL, oldValue, this.discoveryUrl);
        }

        @Override
        public final Builder discoveryUrl(String discoveryUrl) {
            Object oldValue = this.discoveryUrl;
            this.discoveryUrl = discoveryUrl;
            handleUnionValueChange(Type.DISCOVERY_URL, oldValue, this.discoveryUrl);
            return this;
        }

        public final Oauth2AuthorizationServerMetadata.Builder getAuthorizationServerMetadata() {
            return authorizationServerMetadata != null ? authorizationServerMetadata.toBuilder() : null;
        }

        public final void setAuthorizationServerMetadata(Oauth2AuthorizationServerMetadata.BuilderImpl authorizationServerMetadata) {
            Object oldValue = this.authorizationServerMetadata;
            this.authorizationServerMetadata = authorizationServerMetadata != null ? authorizationServerMetadata.build() : null;
            handleUnionValueChange(Type.AUTHORIZATION_SERVER_METADATA, oldValue, this.authorizationServerMetadata);
        }

        @Override
        public final Builder authorizationServerMetadata(Oauth2AuthorizationServerMetadata authorizationServerMetadata) {
            Object oldValue = this.authorizationServerMetadata;
            this.authorizationServerMetadata = authorizationServerMetadata;
            handleUnionValueChange(Type.AUTHORIZATION_SERVER_METADATA, oldValue, this.authorizationServerMetadata);
            return this;
        }

        @Override
        public Oauth2Discovery build() {
            return new Oauth2Discovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Oauth2Discovery#type()
     */
    public enum Type {
        DISCOVERY_URL,

        AUTHORIZATION_SERVER_METADATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
