/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Oauth2CredentialProvidersCopier {
    static List<Oauth2CredentialProviderItem> copy(
            Collection<? extends Oauth2CredentialProviderItem> oauth2CredentialProvidersParam) {
        List<Oauth2CredentialProviderItem> list;
        if (oauth2CredentialProvidersParam == null || oauth2CredentialProvidersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Oauth2CredentialProviderItem> modifiableList = new ArrayList<>(oauth2CredentialProvidersParam.size());
            oauth2CredentialProvidersParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Oauth2CredentialProviderItem> copyFromBuilder(
            Collection<? extends Oauth2CredentialProviderItem.Builder> oauth2CredentialProvidersParam) {
        List<Oauth2CredentialProviderItem> list;
        if (oauth2CredentialProvidersParam == null || oauth2CredentialProvidersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Oauth2CredentialProviderItem> modifiableList = new ArrayList<>(oauth2CredentialProvidersParam.size());
            oauth2CredentialProvidersParam.forEach(entry -> {
                Oauth2CredentialProviderItem member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Oauth2CredentialProviderItem.Builder> copyToBuilder(
            Collection<? extends Oauth2CredentialProviderItem> oauth2CredentialProvidersParam) {
        List<Oauth2CredentialProviderItem.Builder> list;
        if (oauth2CredentialProvidersParam == null || oauth2CredentialProvidersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Oauth2CredentialProviderItem.Builder> modifiableList = new ArrayList<>(oauth2CredentialProvidersParam.size());
            oauth2CredentialProvidersParam.forEach(entry -> {
                Oauth2CredentialProviderItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
