/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SecurityConfig for the Agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConfiguration.Builder, NetworkConfiguration> {
    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkMode").getter(getter(NetworkConfiguration::networkModeAsString))
            .setter(setter(Builder::networkMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String networkMode;

    private NetworkConfiguration(BuilderImpl builder) {
        this.networkMode = builder.networkMode;
    }

    /**
     * <p>
     * The network mode for the agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkMode} will
     * return {@link NetworkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkModeAsString}.
     * </p>
     * 
     * @return The network mode for the agent runtime.
     * @see NetworkMode
     */
    public final NetworkMode networkMode() {
        return NetworkMode.fromValue(networkMode);
    }

    /**
     * <p>
     * The network mode for the agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkMode} will
     * return {@link NetworkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkModeAsString}.
     * </p>
     * 
     * @return The network mode for the agent runtime.
     * @see NetworkMode
     */
    public final String networkModeAsString() {
        return networkMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration) obj;
        return Objects.equals(networkModeAsString(), other.networkModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConfiguration").add("NetworkMode", networkModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkMode":
            return Optional.ofNullable(clazz.cast(networkModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkMode", NETWORK_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfiguration, T> g) {
        return obj -> g.apply((NetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConfiguration> {
        /**
         * <p>
         * The network mode for the agent runtime.
         * </p>
         * 
         * @param networkMode
         *        The network mode for the agent runtime.
         * @see NetworkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkMode
         */
        Builder networkMode(String networkMode);

        /**
         * <p>
         * The network mode for the agent runtime.
         * </p>
         * 
         * @param networkMode
         *        The network mode for the agent runtime.
         * @see NetworkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkMode
         */
        Builder networkMode(NetworkMode networkMode);
    }

    static final class BuilderImpl implements Builder {
        private String networkMode;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            networkMode(model.networkMode);
        }

        public final String getNetworkMode() {
            return networkMode;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        @Override
        public final Builder networkMode(NetworkMode networkMode) {
            this.networkMode(networkMode == null ? null : networkMode.toString());
            return this;
        }

        @Override
        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
