/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information for modifying memory strategies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyMemoryStrategies implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyMemoryStrategies.Builder, ModifyMemoryStrategies> {
    private static final SdkField<List<MemoryStrategyInput>> ADD_MEMORY_STRATEGIES_FIELD = SdkField
            .<List<MemoryStrategyInput>> builder(MarshallingType.LIST)
            .memberName("addMemoryStrategies")
            .getter(getter(ModifyMemoryStrategies::addMemoryStrategies))
            .setter(setter(Builder::addMemoryStrategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addMemoryStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemoryStrategyInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemoryStrategyInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ModifyMemoryStrategyInput>> MODIFY_MEMORY_STRATEGIES_FIELD = SdkField
            .<List<ModifyMemoryStrategyInput>> builder(MarshallingType.LIST)
            .memberName("modifyMemoryStrategies")
            .getter(getter(ModifyMemoryStrategies::modifyMemoryStrategies))
            .setter(setter(Builder::modifyMemoryStrategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifyMemoryStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModifyMemoryStrategyInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModifyMemoryStrategyInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DeleteMemoryStrategyInput>> DELETE_MEMORY_STRATEGIES_FIELD = SdkField
            .<List<DeleteMemoryStrategyInput>> builder(MarshallingType.LIST)
            .memberName("deleteMemoryStrategies")
            .getter(getter(ModifyMemoryStrategies::deleteMemoryStrategies))
            .setter(setter(Builder::deleteMemoryStrategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteMemoryStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeleteMemoryStrategyInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteMemoryStrategyInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_MEMORY_STRATEGIES_FIELD,
            MODIFY_MEMORY_STRATEGIES_FIELD, DELETE_MEMORY_STRATEGIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MemoryStrategyInput> addMemoryStrategies;

    private final List<ModifyMemoryStrategyInput> modifyMemoryStrategies;

    private final List<DeleteMemoryStrategyInput> deleteMemoryStrategies;

    private ModifyMemoryStrategies(BuilderImpl builder) {
        this.addMemoryStrategies = builder.addMemoryStrategies;
        this.modifyMemoryStrategies = builder.modifyMemoryStrategies;
        this.deleteMemoryStrategies = builder.deleteMemoryStrategies;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddMemoryStrategies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddMemoryStrategies() {
        return addMemoryStrategies != null && !(addMemoryStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of memory strategies to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddMemoryStrategies} method.
     * </p>
     * 
     * @return The list of memory strategies to add.
     */
    public final List<MemoryStrategyInput> addMemoryStrategies() {
        return addMemoryStrategies;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModifyMemoryStrategies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModifyMemoryStrategies() {
        return modifyMemoryStrategies != null && !(modifyMemoryStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of memory strategies to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModifyMemoryStrategies} method.
     * </p>
     * 
     * @return The list of memory strategies to modify.
     */
    public final List<ModifyMemoryStrategyInput> modifyMemoryStrategies() {
        return modifyMemoryStrategies;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeleteMemoryStrategies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeleteMemoryStrategies() {
        return deleteMemoryStrategies != null && !(deleteMemoryStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of memory strategies to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeleteMemoryStrategies} method.
     * </p>
     * 
     * @return The list of memory strategies to delete.
     */
    public final List<DeleteMemoryStrategyInput> deleteMemoryStrategies() {
        return deleteMemoryStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAddMemoryStrategies() ? addMemoryStrategies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasModifyMemoryStrategies() ? modifyMemoryStrategies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeleteMemoryStrategies() ? deleteMemoryStrategies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMemoryStrategies)) {
            return false;
        }
        ModifyMemoryStrategies other = (ModifyMemoryStrategies) obj;
        return hasAddMemoryStrategies() == other.hasAddMemoryStrategies()
                && Objects.equals(addMemoryStrategies(), other.addMemoryStrategies())
                && hasModifyMemoryStrategies() == other.hasModifyMemoryStrategies()
                && Objects.equals(modifyMemoryStrategies(), other.modifyMemoryStrategies())
                && hasDeleteMemoryStrategies() == other.hasDeleteMemoryStrategies()
                && Objects.equals(deleteMemoryStrategies(), other.deleteMemoryStrategies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyMemoryStrategies")
                .add("AddMemoryStrategies", hasAddMemoryStrategies() ? addMemoryStrategies() : null)
                .add("ModifyMemoryStrategies", hasModifyMemoryStrategies() ? modifyMemoryStrategies() : null)
                .add("DeleteMemoryStrategies", hasDeleteMemoryStrategies() ? deleteMemoryStrategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addMemoryStrategies":
            return Optional.ofNullable(clazz.cast(addMemoryStrategies()));
        case "modifyMemoryStrategies":
            return Optional.ofNullable(clazz.cast(modifyMemoryStrategies()));
        case "deleteMemoryStrategies":
            return Optional.ofNullable(clazz.cast(deleteMemoryStrategies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addMemoryStrategies", ADD_MEMORY_STRATEGIES_FIELD);
        map.put("modifyMemoryStrategies", MODIFY_MEMORY_STRATEGIES_FIELD);
        map.put("deleteMemoryStrategies", DELETE_MEMORY_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyMemoryStrategies, T> g) {
        return obj -> g.apply((ModifyMemoryStrategies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyMemoryStrategies> {
        /**
         * <p>
         * The list of memory strategies to add.
         * </p>
         * 
         * @param addMemoryStrategies
         *        The list of memory strategies to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addMemoryStrategies(Collection<MemoryStrategyInput> addMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to add.
         * </p>
         * 
         * @param addMemoryStrategies
         *        The list of memory strategies to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addMemoryStrategies(MemoryStrategyInput... addMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to add.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput.Builder#build()} is
         * called immediately and its result is passed to {@link #addMemoryStrategies(List<MemoryStrategyInput>)}.
         * 
         * @param addMemoryStrategies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addMemoryStrategies(java.util.Collection<MemoryStrategyInput>)
         */
        Builder addMemoryStrategies(Consumer<MemoryStrategyInput.Builder>... addMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to modify.
         * </p>
         * 
         * @param modifyMemoryStrategies
         *        The list of memory strategies to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifyMemoryStrategies(Collection<ModifyMemoryStrategyInput> modifyMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to modify.
         * </p>
         * 
         * @param modifyMemoryStrategies
         *        The list of memory strategies to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifyMemoryStrategies(ModifyMemoryStrategyInput... modifyMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to modify.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyMemoryStrategyInput.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyMemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyMemoryStrategyInput.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #modifyMemoryStrategies(List<ModifyMemoryStrategyInput>)}.
         * 
         * @param modifyMemoryStrategies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyMemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modifyMemoryStrategies(java.util.Collection<ModifyMemoryStrategyInput>)
         */
        Builder modifyMemoryStrategies(Consumer<ModifyMemoryStrategyInput.Builder>... modifyMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to delete.
         * </p>
         * 
         * @param deleteMemoryStrategies
         *        The list of memory strategies to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMemoryStrategies(Collection<DeleteMemoryStrategyInput> deleteMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to delete.
         * </p>
         * 
         * @param deleteMemoryStrategies
         *        The list of memory strategies to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMemoryStrategies(DeleteMemoryStrategyInput... deleteMemoryStrategies);

        /**
         * <p>
         * The list of memory strategies to delete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryStrategyInput.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryStrategyInput.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #deleteMemoryStrategies(List<DeleteMemoryStrategyInput>)}.
         * 
         * @param deleteMemoryStrategies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteMemoryStrategies(java.util.Collection<DeleteMemoryStrategyInput>)
         */
        Builder deleteMemoryStrategies(Consumer<DeleteMemoryStrategyInput.Builder>... deleteMemoryStrategies);
    }

    static final class BuilderImpl implements Builder {
        private List<MemoryStrategyInput> addMemoryStrategies = DefaultSdkAutoConstructList.getInstance();

        private List<ModifyMemoryStrategyInput> modifyMemoryStrategies = DefaultSdkAutoConstructList.getInstance();

        private List<DeleteMemoryStrategyInput> deleteMemoryStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyMemoryStrategies model) {
            addMemoryStrategies(model.addMemoryStrategies);
            modifyMemoryStrategies(model.modifyMemoryStrategies);
            deleteMemoryStrategies(model.deleteMemoryStrategies);
        }

        public final List<MemoryStrategyInput.Builder> getAddMemoryStrategies() {
            List<MemoryStrategyInput.Builder> result = MemoryStrategyInputListCopier.copyToBuilder(this.addMemoryStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddMemoryStrategies(Collection<MemoryStrategyInput.BuilderImpl> addMemoryStrategies) {
            this.addMemoryStrategies = MemoryStrategyInputListCopier.copyFromBuilder(addMemoryStrategies);
        }

        @Override
        public final Builder addMemoryStrategies(Collection<MemoryStrategyInput> addMemoryStrategies) {
            this.addMemoryStrategies = MemoryStrategyInputListCopier.copy(addMemoryStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMemoryStrategies(MemoryStrategyInput... addMemoryStrategies) {
            addMemoryStrategies(Arrays.asList(addMemoryStrategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMemoryStrategies(Consumer<MemoryStrategyInput.Builder>... addMemoryStrategies) {
            addMemoryStrategies(Stream.of(addMemoryStrategies).map(c -> MemoryStrategyInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ModifyMemoryStrategyInput.Builder> getModifyMemoryStrategies() {
            List<ModifyMemoryStrategyInput.Builder> result = ModifyMemoryStrategiesListCopier
                    .copyToBuilder(this.modifyMemoryStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModifyMemoryStrategies(Collection<ModifyMemoryStrategyInput.BuilderImpl> modifyMemoryStrategies) {
            this.modifyMemoryStrategies = ModifyMemoryStrategiesListCopier.copyFromBuilder(modifyMemoryStrategies);
        }

        @Override
        public final Builder modifyMemoryStrategies(Collection<ModifyMemoryStrategyInput> modifyMemoryStrategies) {
            this.modifyMemoryStrategies = ModifyMemoryStrategiesListCopier.copy(modifyMemoryStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyMemoryStrategies(ModifyMemoryStrategyInput... modifyMemoryStrategies) {
            modifyMemoryStrategies(Arrays.asList(modifyMemoryStrategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyMemoryStrategies(Consumer<ModifyMemoryStrategyInput.Builder>... modifyMemoryStrategies) {
            modifyMemoryStrategies(Stream.of(modifyMemoryStrategies)
                    .map(c -> ModifyMemoryStrategyInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeleteMemoryStrategyInput.Builder> getDeleteMemoryStrategies() {
            List<DeleteMemoryStrategyInput.Builder> result = DeleteMemoryStrategiesListCopier
                    .copyToBuilder(this.deleteMemoryStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeleteMemoryStrategies(Collection<DeleteMemoryStrategyInput.BuilderImpl> deleteMemoryStrategies) {
            this.deleteMemoryStrategies = DeleteMemoryStrategiesListCopier.copyFromBuilder(deleteMemoryStrategies);
        }

        @Override
        public final Builder deleteMemoryStrategies(Collection<DeleteMemoryStrategyInput> deleteMemoryStrategies) {
            this.deleteMemoryStrategies = DeleteMemoryStrategiesListCopier.copy(deleteMemoryStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteMemoryStrategies(DeleteMemoryStrategyInput... deleteMemoryStrategies) {
            deleteMemoryStrategies(Arrays.asList(deleteMemoryStrategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteMemoryStrategies(Consumer<DeleteMemoryStrategyInput.Builder>... deleteMemoryStrategies) {
            deleteMemoryStrategies(Stream.of(deleteMemoryStrategies)
                    .map(c -> DeleteMemoryStrategyInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModifyMemoryStrategies build() {
            return new ModifyMemoryStrategies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
