/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBrowsersResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<ListBrowsersResponse.Builder, ListBrowsersResponse> {
    private static final SdkField<List<BrowserSummary>> BROWSER_SUMMARIES_FIELD = SdkField
            .<List<BrowserSummary>> builder(MarshallingType.LIST)
            .memberName("browserSummaries")
            .getter(getter(ListBrowsersResponse::browserSummaries))
            .setter(setter(Builder::browserSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrowserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrowserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBrowsersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BrowserSummary> browserSummaries;

    private final String nextToken;

    private ListBrowsersResponse(BuilderImpl builder) {
        super(builder);
        this.browserSummaries = builder.browserSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BrowserSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBrowserSummaries() {
        return browserSummaries != null && !(browserSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of browser summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBrowserSummaries} method.
     * </p>
     * 
     * @return The list of browser summaries.
     */
    public final List<BrowserSummary> browserSummaries() {
        return browserSummaries;
    }

    /**
     * <p>
     * A token to retrieve the next page of results.
     * </p>
     * 
     * @return A token to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBrowserSummaries() ? browserSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrowsersResponse)) {
            return false;
        }
        ListBrowsersResponse other = (ListBrowsersResponse) obj;
        return hasBrowserSummaries() == other.hasBrowserSummaries()
                && Objects.equals(browserSummaries(), other.browserSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBrowsersResponse")
                .add("BrowserSummaries", hasBrowserSummaries() ? browserSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserSummaries":
            return Optional.ofNullable(clazz.cast(browserSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserSummaries", BROWSER_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBrowsersResponse, T> g) {
        return obj -> g.apply((ListBrowsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBrowsersResponse> {
        /**
         * <p>
         * The list of browser summaries.
         * </p>
         * 
         * @param browserSummaries
         *        The list of browser summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSummaries(Collection<BrowserSummary> browserSummaries);

        /**
         * <p>
         * The list of browser summaries.
         * </p>
         * 
         * @param browserSummaries
         *        The list of browser summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSummaries(BrowserSummary... browserSummaries);

        /**
         * <p>
         * The list of browser summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #browserSummaries(List<BrowserSummary>)}.
         * 
         * @param browserSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #browserSummaries(java.util.Collection<BrowserSummary>)
         */
        Builder browserSummaries(Consumer<BrowserSummary.Builder>... browserSummaries);

        /**
         * <p>
         * A token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private List<BrowserSummary> browserSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrowsersResponse model) {
            super(model);
            browserSummaries(model.browserSummaries);
            nextToken(model.nextToken);
        }

        public final List<BrowserSummary.Builder> getBrowserSummaries() {
            List<BrowserSummary.Builder> result = BrowserSummariesCopier.copyToBuilder(this.browserSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrowserSummaries(Collection<BrowserSummary.BuilderImpl> browserSummaries) {
            this.browserSummaries = BrowserSummariesCopier.copyFromBuilder(browserSummaries);
        }

        @Override
        public final Builder browserSummaries(Collection<BrowserSummary> browserSummaries) {
            this.browserSummaries = BrowserSummariesCopier.copy(browserSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSummaries(BrowserSummary... browserSummaries) {
            browserSummaries(Arrays.asList(browserSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSummaries(Consumer<BrowserSummary.Builder>... browserSummaries) {
            browserSummaries(Stream.of(browserSummaries).map(c -> BrowserSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBrowsersResponse build() {
            return new ListBrowsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
