/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgentRuntimesResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<ListAgentRuntimesResponse.Builder, ListAgentRuntimesResponse> {
    private static final SdkField<List<Agent>> AGENT_RUNTIMES_FIELD = SdkField
            .<List<Agent>> builder(MarshallingType.LIST)
            .memberName("agentRuntimes")
            .getter(getter(ListAgentRuntimesResponse::agentRuntimes))
            .setter(setter(Builder::agentRuntimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Agent> builder(MarshallingType.SDK_POJO)
                                            .constructor(Agent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAgentRuntimesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIMES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Agent> agentRuntimes;

    private final String nextToken;

    private ListAgentRuntimesResponse(BuilderImpl builder) {
        super(builder);
        this.agentRuntimes = builder.agentRuntimes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentRuntimes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentRuntimes() {
        return agentRuntimes != null && !(agentRuntimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of agent runtimes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentRuntimes} method.
     * </p>
     * 
     * @return The list of agent runtimes.
     */
    public final List<Agent> agentRuntimes() {
        return agentRuntimes;
    }

    /**
     * <p>
     * A token to retrieve the next page of results.
     * </p>
     * 
     * @return A token to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentRuntimes() ? agentRuntimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentRuntimesResponse)) {
            return false;
        }
        ListAgentRuntimesResponse other = (ListAgentRuntimesResponse) obj;
        return hasAgentRuntimes() == other.hasAgentRuntimes() && Objects.equals(agentRuntimes(), other.agentRuntimes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAgentRuntimesResponse").add("AgentRuntimes", hasAgentRuntimes() ? agentRuntimes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimes":
            return Optional.ofNullable(clazz.cast(agentRuntimes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimes", AGENT_RUNTIMES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgentRuntimesResponse, T> g) {
        return obj -> g.apply((ListAgentRuntimesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAgentRuntimesResponse> {
        /**
         * <p>
         * The list of agent runtimes.
         * </p>
         * 
         * @param agentRuntimes
         *        The list of agent runtimes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimes(Collection<Agent> agentRuntimes);

        /**
         * <p>
         * The list of agent runtimes.
         * </p>
         * 
         * @param agentRuntimes
         *        The list of agent runtimes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimes(Agent... agentRuntimes);

        /**
         * <p>
         * The list of agent runtimes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent.Builder#build()} is called
         * immediately and its result is passed to {@link #agentRuntimes(List<Agent>)}.
         * 
         * @param agentRuntimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentRuntimes(java.util.Collection<Agent>)
         */
        Builder agentRuntimes(Consumer<Agent.Builder>... agentRuntimes);

        /**
         * <p>
         * A token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private List<Agent> agentRuntimes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentRuntimesResponse model) {
            super(model);
            agentRuntimes(model.agentRuntimes);
            nextToken(model.nextToken);
        }

        public final List<Agent.Builder> getAgentRuntimes() {
            List<Agent.Builder> result = AgentsCopier.copyToBuilder(this.agentRuntimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentRuntimes(Collection<Agent.BuilderImpl> agentRuntimes) {
            this.agentRuntimes = AgentsCopier.copyFromBuilder(agentRuntimes);
        }

        @Override
        public final Builder agentRuntimes(Collection<Agent> agentRuntimes) {
            this.agentRuntimes = AgentsCopier.copy(agentRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentRuntimes(Agent... agentRuntimes) {
            agentRuntimes(Arrays.asList(agentRuntimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentRuntimes(Consumer<Agent.Builder>... agentRuntimes) {
            agentRuntimes(Stream.of(agentRuntimes).map(c -> Agent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentRuntimesResponse build() {
            return new ListAgentRuntimesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
