/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTokenVaultResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetTokenVaultResponse.Builder, GetTokenVaultResponse> {
    private static final SdkField<String> TOKEN_VAULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenVaultId").getter(getter(GetTokenVaultResponse::tokenVaultId)).setter(setter(Builder::tokenVaultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenVaultId").build()).build();

    private static final SdkField<KmsConfiguration> KMS_CONFIGURATION_FIELD = SdkField
            .<KmsConfiguration> builder(MarshallingType.SDK_POJO).memberName("kmsConfiguration")
            .getter(getter(GetTokenVaultResponse::kmsConfiguration)).setter(setter(Builder::kmsConfiguration))
            .constructor(KmsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsConfiguration").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(GetTokenVaultResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_VAULT_ID_FIELD,
            KMS_CONFIGURATION_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tokenVaultId;

    private final KmsConfiguration kmsConfiguration;

    private final Instant lastModifiedDate;

    private GetTokenVaultResponse(BuilderImpl builder) {
        super(builder);
        this.tokenVaultId = builder.tokenVaultId;
        this.kmsConfiguration = builder.kmsConfiguration;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The ID of the token vault.
     * </p>
     * 
     * @return The ID of the token vault.
     */
    public final String tokenVaultId() {
        return tokenVaultId;
    }

    /**
     * <p>
     * The KMS configuration for the token vault.
     * </p>
     * 
     * @return The KMS configuration for the token vault.
     */
    public final KmsConfiguration kmsConfiguration() {
        return kmsConfiguration;
    }

    /**
     * <p>
     * The timestamp when the token vault was last modified.
     * </p>
     * 
     * @return The timestamp when the token vault was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tokenVaultId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTokenVaultResponse)) {
            return false;
        }
        GetTokenVaultResponse other = (GetTokenVaultResponse) obj;
        return Objects.equals(tokenVaultId(), other.tokenVaultId())
                && Objects.equals(kmsConfiguration(), other.kmsConfiguration())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTokenVaultResponse").add("TokenVaultId", tokenVaultId())
                .add("KmsConfiguration", kmsConfiguration()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tokenVaultId":
            return Optional.ofNullable(clazz.cast(tokenVaultId()));
        case "kmsConfiguration":
            return Optional.ofNullable(clazz.cast(kmsConfiguration()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tokenVaultId", TOKEN_VAULT_ID_FIELD);
        map.put("kmsConfiguration", KMS_CONFIGURATION_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTokenVaultResponse, T> g) {
        return obj -> g.apply((GetTokenVaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTokenVaultResponse> {
        /**
         * <p>
         * The ID of the token vault.
         * </p>
         * 
         * @param tokenVaultId
         *        The ID of the token vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenVaultId(String tokenVaultId);

        /**
         * <p>
         * The KMS configuration for the token vault.
         * </p>
         * 
         * @param kmsConfiguration
         *        The KMS configuration for the token vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsConfiguration(KmsConfiguration kmsConfiguration);

        /**
         * <p>
         * The KMS configuration for the token vault.
         * </p>
         * This is a convenience method that creates an instance of the {@link KmsConfiguration.Builder} avoiding the
         * need to create one manually via {@link KmsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KmsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #kmsConfiguration(KmsConfiguration)}.
         * 
         * @param kmsConfiguration
         *        a consumer that will call methods on {@link KmsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsConfiguration(KmsConfiguration)
         */
        default Builder kmsConfiguration(Consumer<KmsConfiguration.Builder> kmsConfiguration) {
            return kmsConfiguration(KmsConfiguration.builder().applyMutation(kmsConfiguration).build());
        }

        /**
         * <p>
         * The timestamp when the token vault was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The timestamp when the token vault was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String tokenVaultId;

        private KmsConfiguration kmsConfiguration;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTokenVaultResponse model) {
            super(model);
            tokenVaultId(model.tokenVaultId);
            kmsConfiguration(model.kmsConfiguration);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getTokenVaultId() {
            return tokenVaultId;
        }

        public final void setTokenVaultId(String tokenVaultId) {
            this.tokenVaultId = tokenVaultId;
        }

        @Override
        public final Builder tokenVaultId(String tokenVaultId) {
            this.tokenVaultId = tokenVaultId;
            return this;
        }

        public final KmsConfiguration.Builder getKmsConfiguration() {
            return kmsConfiguration != null ? kmsConfiguration.toBuilder() : null;
        }

        public final void setKmsConfiguration(KmsConfiguration.BuilderImpl kmsConfiguration) {
            this.kmsConfiguration = kmsConfiguration != null ? kmsConfiguration.build() : null;
        }

        @Override
        public final Builder kmsConfiguration(KmsConfiguration kmsConfiguration) {
            this.kmsConfiguration = kmsConfiguration;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public GetTokenVaultResponse build() {
            return new GetTokenVaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
