/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGatewayTargetResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetGatewayTargetResponse.Builder, GetGatewayTargetResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayArn").getter(getter(GetGatewayTargetResponse::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetId").getter(getter(GetGatewayTargetResponse::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetGatewayTargetResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetGatewayTargetResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetGatewayTargetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusReasons")
            .getter(getter(GetGatewayTargetResponse::statusReasons))
            .setter(setter(Builder::statusReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetGatewayTargetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetGatewayTargetResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<TargetConfiguration> builder(MarshallingType.SDK_POJO).memberName("targetConfiguration")
            .getter(getter(GetGatewayTargetResponse::targetConfiguration)).setter(setter(Builder::targetConfiguration))
            .constructor(TargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConfiguration").build())
            .build();

    private static final SdkField<List<CredentialProviderConfiguration>> CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD = SdkField
            .<List<CredentialProviderConfiguration>> builder(MarshallingType.LIST)
            .memberName("credentialProviderConfigurations")
            .getter(getter(GetGatewayTargetResponse::credentialProviderConfigurations))
            .setter(setter(Builder::credentialProviderConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CredentialProviderConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CredentialProviderConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TARGET_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, STATUS_REASONS_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TARGET_CONFIGURATION_FIELD, CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayArn;

    private final String targetId;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private final List<String> statusReasons;

    private final String name;

    private final String description;

    private final TargetConfiguration targetConfiguration;

    private final List<CredentialProviderConfiguration> credentialProviderConfigurations;

    private GetGatewayTargetResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayArn = builder.gatewayArn;
        this.targetId = builder.targetId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
        this.name = builder.name;
        this.description = builder.description;
        this.targetConfiguration = builder.targetConfiguration;
        this.credentialProviderConfigurations = builder.credentialProviderConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Gateway.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * <p>
     * The unique identifier of the Gateway Target.
     * </p>
     * 
     * @return The unique identifier of the Gateway Target.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The timestamp when the Gateway Target was created.
     * </p>
     * 
     * @return The timestamp when the Gateway Target was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the Gateway Target was last updated.
     * </p>
     * 
     * @return The timestamp when the Gateway Target was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the Gateway Target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Gateway Target.
     * @see TargetStatus
     */
    public final TargetStatus status() {
        return TargetStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Gateway Target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Gateway Target.
     * @see TargetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusReasons() {
        return statusReasons != null && !(statusReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons for the current status of the Gateway Target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusReasons} method.
     * </p>
     * 
     * @return The reasons for the current status of the Gateway Target.
     */
    public final List<String> statusReasons() {
        return statusReasons;
    }

    /**
     * <p>
     * The name of the Gateway Target.
     * </p>
     * 
     * @return The name of the Gateway Target.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Gateway Target.
     * </p>
     * 
     * @return The description of the Gateway Target.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the TargetConfiguration property for this object.
     * 
     * @return The value of the TargetConfiguration property for this object.
     */
    public final TargetConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CredentialProviderConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCredentialProviderConfigurations() {
        return credentialProviderConfigurations != null && !(credentialProviderConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The credential provider configurations for the Gateway Target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentialProviderConfigurations}
     * method.
     * </p>
     * 
     * @return The credential provider configurations for the Gateway Target.
     */
    public final List<CredentialProviderConfiguration> credentialProviderConfigurations() {
        return credentialProviderConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusReasons() ? statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCredentialProviderConfigurations() ? credentialProviderConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGatewayTargetResponse)) {
            return false;
        }
        GetGatewayTargetResponse other = (GetGatewayTargetResponse) obj;
        return Objects.equals(gatewayArn(), other.gatewayArn()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasStatusReasons() == other.hasStatusReasons()
                && Objects.equals(statusReasons(), other.statusReasons()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(targetConfiguration(), other.targetConfiguration())
                && hasCredentialProviderConfigurations() == other.hasCredentialProviderConfigurations()
                && Objects.equals(credentialProviderConfigurations(), other.credentialProviderConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetGatewayTargetResponse")
                .add("GatewayArn", gatewayArn())
                .add("TargetId", targetId())
                .add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt())
                .add("Status", statusAsString())
                .add("StatusReasons", hasStatusReasons() ? statusReasons() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TargetConfiguration", targetConfiguration())
                .add("CredentialProviderConfigurations",
                        hasCredentialProviderConfigurations() ? credentialProviderConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "targetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReasons":
            return Optional.ofNullable(clazz.cast(statusReasons()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        case "credentialProviderConfigurations":
            return Optional.ofNullable(clazz.cast(credentialProviderConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("targetId", TARGET_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("targetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("credentialProviderConfigurations", CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGatewayTargetResponse, T> g) {
        return obj -> g.apply((GetGatewayTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGatewayTargetResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Gateway.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * <p>
         * The unique identifier of the Gateway Target.
         * </p>
         * 
         * @param targetId
         *        The unique identifier of the Gateway Target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The timestamp when the Gateway Target was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the Gateway Target was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the Gateway Target was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the Gateway Target was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the Gateway Target.
         * </p>
         * 
         * @param status
         *        The current status of the Gateway Target.
         * @see TargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Gateway Target.
         * </p>
         * 
         * @param status
         *        The current status of the Gateway Target.
         * @see TargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStatus
         */
        Builder status(TargetStatus status);

        /**
         * <p>
         * The reasons for the current status of the Gateway Target.
         * </p>
         * 
         * @param statusReasons
         *        The reasons for the current status of the Gateway Target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(Collection<String> statusReasons);

        /**
         * <p>
         * The reasons for the current status of the Gateway Target.
         * </p>
         * 
         * @param statusReasons
         *        The reasons for the current status of the Gateway Target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(String... statusReasons);

        /**
         * <p>
         * The name of the Gateway Target.
         * </p>
         * 
         * @param name
         *        The name of the Gateway Target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Gateway Target.
         * </p>
         * 
         * @param description
         *        The description of the Gateway Target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the TargetConfiguration property for this object.
         *
         * @param targetConfiguration
         *        The new value for the TargetConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(TargetConfiguration targetConfiguration);

        /**
         * Sets the value of the TargetConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TargetConfiguration.Builder} avoiding the
         * need to create one manually via {@link TargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #targetConfiguration(TargetConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link TargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(TargetConfiguration)
         */
        default Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(TargetConfiguration.builder().applyMutation(targetConfiguration).build());
        }

        /**
         * <p>
         * The credential provider configurations for the Gateway Target.
         * </p>
         * 
         * @param credentialProviderConfigurations
         *        The credential provider configurations for the Gateway Target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialProviderConfigurations(Collection<CredentialProviderConfiguration> credentialProviderConfigurations);

        /**
         * <p>
         * The credential provider configurations for the Gateway Target.
         * </p>
         * 
         * @param credentialProviderConfigurations
         *        The credential provider configurations for the Gateway Target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialProviderConfigurations(CredentialProviderConfiguration... credentialProviderConfigurations);

        /**
         * <p>
         * The credential provider configurations for the Gateway Target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #credentialProviderConfigurations(List<CredentialProviderConfiguration>)}.
         * 
         * @param credentialProviderConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialProviderConfigurations(java.util.Collection<CredentialProviderConfiguration>)
         */
        Builder credentialProviderConfigurations(
                Consumer<CredentialProviderConfiguration.Builder>... credentialProviderConfigurations);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String gatewayArn;

        private String targetId;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String description;

        private TargetConfiguration targetConfiguration;

        private List<CredentialProviderConfiguration> credentialProviderConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetGatewayTargetResponse model) {
            super(model);
            gatewayArn(model.gatewayArn);
            targetId(model.targetId);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
            statusReasons(model.statusReasons);
            name(model.name);
            description(model.description);
            targetConfiguration(model.targetConfiguration);
            credentialProviderConfigurations(model.credentialProviderConfigurations);
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String... statusReasons) {
            statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final List<CredentialProviderConfiguration.Builder> getCredentialProviderConfigurations() {
            List<CredentialProviderConfiguration.Builder> result = CredentialProviderConfigurationsCopier
                    .copyToBuilder(this.credentialProviderConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialProviderConfigurations(
                Collection<CredentialProviderConfiguration.BuilderImpl> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier
                    .copyFromBuilder(credentialProviderConfigurations);
        }

        @Override
        public final Builder credentialProviderConfigurations(
                Collection<CredentialProviderConfiguration> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier.copy(credentialProviderConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(CredentialProviderConfiguration... credentialProviderConfigurations) {
            credentialProviderConfigurations(Arrays.asList(credentialProviderConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(
                Consumer<CredentialProviderConfiguration.Builder>... credentialProviderConfigurations) {
            credentialProviderConfigurations(Stream.of(credentialProviderConfigurations)
                    .map(c -> CredentialProviderConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetGatewayTargetResponse build() {
            return new GetGatewayTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
