/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewaySummary implements SdkPojo, Serializable, ToCopyableBuilder<GatewaySummary.Builder, GatewaySummary> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(GatewaySummary::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GatewaySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GatewaySummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GatewaySummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GatewaySummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GatewaySummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> AUTHORIZER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerType").getter(getter(GatewaySummary::authorizerTypeAsString))
            .setter(setter(Builder::authorizerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerType").build()).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolType").getter(getter(GatewaySummary::protocolTypeAsString))
            .setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, NAME_FIELD,
            STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, AUTHORIZER_TYPE_FIELD, PROTOCOL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gatewayId;

    private final String name;

    private final String status;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String authorizerType;

    private final String protocolType;

    private GatewaySummary(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.name = builder.name;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.authorizerType = builder.authorizerType;
        this.protocolType = builder.protocolType;
    }

    /**
     * <p>
     * The unique identifier of the gateway.
     * </p>
     * 
     * @return The unique identifier of the gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The name of the gateway.
     * </p>
     * 
     * @return The name of the gateway.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GatewayStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the gateway.
     * @see GatewayStatus
     */
    public final GatewayStatus status() {
        return GatewayStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GatewayStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the gateway.
     * @see GatewayStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the gateway.
     * </p>
     * 
     * @return The description of the gateway.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the gateway was created.
     * </p>
     * 
     * @return The timestamp when the gateway was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the gateway was last updated.
     * </p>
     * 
     * @return The timestamp when the gateway was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The type of authorizer used by the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return The type of authorizer used by the gateway.
     * @see AuthorizerType
     */
    public final AuthorizerType authorizerType() {
        return AuthorizerType.fromValue(authorizerType);
    }

    /**
     * <p>
     * The type of authorizer used by the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return The type of authorizer used by the gateway.
     * @see AuthorizerType
     */
    public final String authorizerTypeAsString() {
        return authorizerType;
    }

    /**
     * <p>
     * The protocol type used by the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link GatewayProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The protocol type used by the gateway.
     * @see GatewayProtocolType
     */
    public final GatewayProtocolType protocolType() {
        return GatewayProtocolType.fromValue(protocolType);
    }

    /**
     * <p>
     * The protocol type used by the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link GatewayProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The protocol type used by the gateway.
     * @see GatewayProtocolType
     */
    public final String protocolTypeAsString() {
        return protocolType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewaySummary)) {
            return false;
        }
        GatewaySummary other = (GatewaySummary) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(authorizerTypeAsString(), other.authorizerTypeAsString())
                && Objects.equals(protocolTypeAsString(), other.protocolTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewaySummary").add("GatewayId", gatewayId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("AuthorizerType", authorizerTypeAsString())
                .add("ProtocolType", protocolTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "authorizerType":
            return Optional.ofNullable(clazz.cast(authorizerTypeAsString()));
        case "protocolType":
            return Optional.ofNullable(clazz.cast(protocolTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("authorizerType", AUTHORIZER_TYPE_FIELD);
        map.put("protocolType", PROTOCOL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewaySummary, T> g) {
        return obj -> g.apply((GatewaySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewaySummary> {
        /**
         * <p>
         * The unique identifier of the gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The name of the gateway.
         * </p>
         * 
         * @param name
         *        The name of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the gateway.
         * </p>
         * 
         * @param status
         *        The current status of the gateway.
         * @see GatewayStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the gateway.
         * </p>
         * 
         * @param status
         *        The current status of the gateway.
         * @see GatewayStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayStatus
         */
        Builder status(GatewayStatus status);

        /**
         * <p>
         * The description of the gateway.
         * </p>
         * 
         * @param description
         *        The description of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the gateway was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the gateway was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the gateway was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the gateway was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The type of authorizer used by the gateway.
         * </p>
         * 
         * @param authorizerType
         *        The type of authorizer used by the gateway.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(String authorizerType);

        /**
         * <p>
         * The type of authorizer used by the gateway.
         * </p>
         * 
         * @param authorizerType
         *        The type of authorizer used by the gateway.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(AuthorizerType authorizerType);

        /**
         * <p>
         * The protocol type used by the gateway.
         * </p>
         * 
         * @param protocolType
         *        The protocol type used by the gateway.
         * @see GatewayProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayProtocolType
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * The protocol type used by the gateway.
         * </p>
         * 
         * @param protocolType
         *        The protocol type used by the gateway.
         * @see GatewayProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayProtocolType
         */
        Builder protocolType(GatewayProtocolType protocolType);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayId;

        private String name;

        private String status;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private String authorizerType;

        private String protocolType;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewaySummary model) {
            gatewayId(model.gatewayId);
            name(model.name);
            status(model.status);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            authorizerType(model.authorizerType);
            protocolType(model.protocolType);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GatewayStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getAuthorizerType() {
            return authorizerType;
        }

        public final void setAuthorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
        }

        @Override
        public final Builder authorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        @Override
        public final Builder authorizerType(AuthorizerType authorizerType) {
            this.authorizerType(authorizerType == null ? null : authorizerType.toString());
            return this;
        }

        public final String getProtocolType() {
            return protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(GatewayProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        @Override
        public GatewaySummary build() {
            return new GatewaySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
