/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains custom extraction configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomExtractionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomExtractionConfiguration.Builder, CustomExtractionConfiguration> {
    private static final SdkField<SemanticExtractionOverride> SEMANTIC_EXTRACTION_OVERRIDE_FIELD = SdkField
            .<SemanticExtractionOverride> builder(MarshallingType.SDK_POJO)
            .memberName("semanticExtractionOverride")
            .getter(getter(CustomExtractionConfiguration::semanticExtractionOverride))
            .setter(setter(Builder::semanticExtractionOverride))
            .constructor(SemanticExtractionOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticExtractionOverride").build())
            .build();

    private static final SdkField<UserPreferenceExtractionOverride> USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD = SdkField
            .<UserPreferenceExtractionOverride> builder(MarshallingType.SDK_POJO)
            .memberName("userPreferenceExtractionOverride")
            .getter(getter(CustomExtractionConfiguration::userPreferenceExtractionOverride))
            .setter(setter(Builder::userPreferenceExtractionOverride))
            .constructor(UserPreferenceExtractionOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceExtractionOverride")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SEMANTIC_EXTRACTION_OVERRIDE_FIELD, USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SemanticExtractionOverride semanticExtractionOverride;

    private final UserPreferenceExtractionOverride userPreferenceExtractionOverride;

    private final Type type;

    private CustomExtractionConfiguration(BuilderImpl builder) {
        this.semanticExtractionOverride = builder.semanticExtractionOverride;
        this.userPreferenceExtractionOverride = builder.userPreferenceExtractionOverride;
        this.type = builder.type;
    }

    /**
     * <p>
     * The semantic extraction override configuration.
     * </p>
     * 
     * @return The semantic extraction override configuration.
     */
    public final SemanticExtractionOverride semanticExtractionOverride() {
        return semanticExtractionOverride;
    }

    /**
     * <p>
     * The user preference extraction override configuration.
     * </p>
     * 
     * @return The user preference extraction override configuration.
     */
    public final UserPreferenceExtractionOverride userPreferenceExtractionOverride() {
        return userPreferenceExtractionOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(semanticExtractionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(userPreferenceExtractionOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomExtractionConfiguration)) {
            return false;
        }
        CustomExtractionConfiguration other = (CustomExtractionConfiguration) obj;
        return Objects.equals(semanticExtractionOverride(), other.semanticExtractionOverride())
                && Objects.equals(userPreferenceExtractionOverride(), other.userPreferenceExtractionOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomExtractionConfiguration").add("SemanticExtractionOverride", semanticExtractionOverride())
                .add("UserPreferenceExtractionOverride", userPreferenceExtractionOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "semanticExtractionOverride":
            return Optional.ofNullable(clazz.cast(semanticExtractionOverride()));
        case "userPreferenceExtractionOverride":
            return Optional.ofNullable(clazz.cast(userPreferenceExtractionOverride()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #semanticExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The semantic extraction override configuration.
     * </p>
     * 
     * @param semanticExtractionOverride
     *        The semantic extraction override configuration.
     */
    public static CustomExtractionConfiguration fromSemanticExtractionOverride(
            SemanticExtractionOverride semanticExtractionOverride) {
        return builder().semanticExtractionOverride(semanticExtractionOverride).build();
    }

    /**
     * Create an instance of this class with {@link #semanticExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The semantic extraction override configuration.
     * </p>
     * 
     * @param semanticExtractionOverride
     *        The semantic extraction override configuration.
     */
    public static CustomExtractionConfiguration fromSemanticExtractionOverride(
            Consumer<SemanticExtractionOverride.Builder> semanticExtractionOverride) {
        SemanticExtractionOverride.Builder builder = SemanticExtractionOverride.builder();
        semanticExtractionOverride.accept(builder);
        return fromSemanticExtractionOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #userPreferenceExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The user preference extraction override configuration.
     * </p>
     * 
     * @param userPreferenceExtractionOverride
     *        The user preference extraction override configuration.
     */
    public static CustomExtractionConfiguration fromUserPreferenceExtractionOverride(
            UserPreferenceExtractionOverride userPreferenceExtractionOverride) {
        return builder().userPreferenceExtractionOverride(userPreferenceExtractionOverride).build();
    }

    /**
     * Create an instance of this class with {@link #userPreferenceExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The user preference extraction override configuration.
     * </p>
     * 
     * @param userPreferenceExtractionOverride
     *        The user preference extraction override configuration.
     */
    public static CustomExtractionConfiguration fromUserPreferenceExtractionOverride(
            Consumer<UserPreferenceExtractionOverride.Builder> userPreferenceExtractionOverride) {
        UserPreferenceExtractionOverride.Builder builder = UserPreferenceExtractionOverride.builder();
        userPreferenceExtractionOverride.accept(builder);
        return fromUserPreferenceExtractionOverride(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("semanticExtractionOverride", SEMANTIC_EXTRACTION_OVERRIDE_FIELD);
        map.put("userPreferenceExtractionOverride", USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomExtractionConfiguration, T> g) {
        return obj -> g.apply((CustomExtractionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomExtractionConfiguration> {
        /**
         * <p>
         * The semantic extraction override configuration.
         * </p>
         * 
         * @param semanticExtractionOverride
         *        The semantic extraction override configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticExtractionOverride(SemanticExtractionOverride semanticExtractionOverride);

        /**
         * <p>
         * The semantic extraction override configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SemanticExtractionOverride.Builder}
         * avoiding the need to create one manually via {@link SemanticExtractionOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticExtractionOverride.Builder#build()} is called immediately
         * and its result is passed to {@link #semanticExtractionOverride(SemanticExtractionOverride)}.
         * 
         * @param semanticExtractionOverride
         *        a consumer that will call methods on {@link SemanticExtractionOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticExtractionOverride(SemanticExtractionOverride)
         */
        default Builder semanticExtractionOverride(Consumer<SemanticExtractionOverride.Builder> semanticExtractionOverride) {
            return semanticExtractionOverride(SemanticExtractionOverride.builder().applyMutation(semanticExtractionOverride)
                    .build());
        }

        /**
         * <p>
         * The user preference extraction override configuration.
         * </p>
         * 
         * @param userPreferenceExtractionOverride
         *        The user preference extraction override configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPreferenceExtractionOverride(UserPreferenceExtractionOverride userPreferenceExtractionOverride);

        /**
         * <p>
         * The user preference extraction override configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPreferenceExtractionOverride.Builder}
         * avoiding the need to create one manually via {@link UserPreferenceExtractionOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPreferenceExtractionOverride.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #userPreferenceExtractionOverride(UserPreferenceExtractionOverride)}.
         * 
         * @param userPreferenceExtractionOverride
         *        a consumer that will call methods on {@link UserPreferenceExtractionOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPreferenceExtractionOverride(UserPreferenceExtractionOverride)
         */
        default Builder userPreferenceExtractionOverride(
                Consumer<UserPreferenceExtractionOverride.Builder> userPreferenceExtractionOverride) {
            return userPreferenceExtractionOverride(UserPreferenceExtractionOverride.builder()
                    .applyMutation(userPreferenceExtractionOverride).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemanticExtractionOverride semanticExtractionOverride;

        private UserPreferenceExtractionOverride userPreferenceExtractionOverride;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomExtractionConfiguration model) {
            semanticExtractionOverride(model.semanticExtractionOverride);
            userPreferenceExtractionOverride(model.userPreferenceExtractionOverride);
        }

        public final SemanticExtractionOverride.Builder getSemanticExtractionOverride() {
            return semanticExtractionOverride != null ? semanticExtractionOverride.toBuilder() : null;
        }

        public final void setSemanticExtractionOverride(SemanticExtractionOverride.BuilderImpl semanticExtractionOverride) {
            Object oldValue = this.semanticExtractionOverride;
            this.semanticExtractionOverride = semanticExtractionOverride != null ? semanticExtractionOverride.build() : null;
            handleUnionValueChange(Type.SEMANTIC_EXTRACTION_OVERRIDE, oldValue, this.semanticExtractionOverride);
        }

        @Override
        public final Builder semanticExtractionOverride(SemanticExtractionOverride semanticExtractionOverride) {
            Object oldValue = this.semanticExtractionOverride;
            this.semanticExtractionOverride = semanticExtractionOverride;
            handleUnionValueChange(Type.SEMANTIC_EXTRACTION_OVERRIDE, oldValue, this.semanticExtractionOverride);
            return this;
        }

        public final UserPreferenceExtractionOverride.Builder getUserPreferenceExtractionOverride() {
            return userPreferenceExtractionOverride != null ? userPreferenceExtractionOverride.toBuilder() : null;
        }

        public final void setUserPreferenceExtractionOverride(
                UserPreferenceExtractionOverride.BuilderImpl userPreferenceExtractionOverride) {
            Object oldValue = this.userPreferenceExtractionOverride;
            this.userPreferenceExtractionOverride = userPreferenceExtractionOverride != null ? userPreferenceExtractionOverride
                    .build() : null;
            handleUnionValueChange(Type.USER_PREFERENCE_EXTRACTION_OVERRIDE, oldValue, this.userPreferenceExtractionOverride);
        }

        @Override
        public final Builder userPreferenceExtractionOverride(UserPreferenceExtractionOverride userPreferenceExtractionOverride) {
            Object oldValue = this.userPreferenceExtractionOverride;
            this.userPreferenceExtractionOverride = userPreferenceExtractionOverride;
            handleUnionValueChange(Type.USER_PREFERENCE_EXTRACTION_OVERRIDE, oldValue, this.userPreferenceExtractionOverride);
            return this;
        }

        @Override
        public CustomExtractionConfiguration build() {
            return new CustomExtractionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomExtractionConfiguration#type()
     */
    public enum Type {
        SEMANTIC_EXTRACTION_OVERRIDE,

        USER_PREFERENCE_EXTRACTION_OVERRIDE,

        UNKNOWN_TO_SDK_VERSION
    }
}
