/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOauth2CredentialProviderResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<CreateOauth2CredentialProviderResponse.Builder, CreateOauth2CredentialProviderResponse> {
    private static final SdkField<Secret> CLIENT_SECRET_ARN_FIELD = SdkField.<Secret> builder(MarshallingType.SDK_POJO)
            .memberName("clientSecretArn").getter(getter(CreateOauth2CredentialProviderResponse::clientSecretArn))
            .setter(setter(Builder::clientSecretArn)).constructor(Secret::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecretArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateOauth2CredentialProviderResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CREDENTIAL_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialProviderArn").getter(getter(CreateOauth2CredentialProviderResponse::credentialProviderArn))
            .setter(setter(Builder::credentialProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_SECRET_ARN_FIELD,
            NAME_FIELD, CREDENTIAL_PROVIDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Secret clientSecretArn;

    private final String name;

    private final String credentialProviderArn;

    private CreateOauth2CredentialProviderResponse(BuilderImpl builder) {
        super(builder);
        this.clientSecretArn = builder.clientSecretArn;
        this.name = builder.name;
        this.credentialProviderArn = builder.credentialProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the client secret in AWS Secrets Manager.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the client secret in AWS Secrets Manager.
     */
    public final Secret clientSecretArn() {
        return clientSecretArn;
    }

    /**
     * <p>
     * The name of the OAuth2 credential provider.
     * </p>
     * 
     * @return The name of the OAuth2 credential provider.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the OAuth2 credential provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the OAuth2 credential provider.
     */
    public final String credentialProviderArn() {
        return credentialProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(credentialProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOauth2CredentialProviderResponse)) {
            return false;
        }
        CreateOauth2CredentialProviderResponse other = (CreateOauth2CredentialProviderResponse) obj;
        return Objects.equals(clientSecretArn(), other.clientSecretArn()) && Objects.equals(name(), other.name())
                && Objects.equals(credentialProviderArn(), other.credentialProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOauth2CredentialProviderResponse").add("ClientSecretArn", clientSecretArn())
                .add("Name", name()).add("CredentialProviderArn", credentialProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientSecretArn":
            return Optional.ofNullable(clazz.cast(clientSecretArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "credentialProviderArn":
            return Optional.ofNullable(clazz.cast(credentialProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientSecretArn", CLIENT_SECRET_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("credentialProviderArn", CREDENTIAL_PROVIDER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOauth2CredentialProviderResponse, T> g) {
        return obj -> g.apply((CreateOauth2CredentialProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOauth2CredentialProviderResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the client secret in AWS Secrets Manager.
         * </p>
         * 
         * @param clientSecretArn
         *        The Amazon Resource Name (ARN) of the client secret in AWS Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecretArn(Secret clientSecretArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the client secret in AWS Secrets Manager.
         * </p>
         * This is a convenience method that creates an instance of the {@link Secret.Builder} avoiding the need to
         * create one manually via {@link Secret#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Secret.Builder#build()} is called immediately and its result is
         * passed to {@link #clientSecretArn(Secret)}.
         * 
         * @param clientSecretArn
         *        a consumer that will call methods on {@link Secret.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientSecretArn(Secret)
         */
        default Builder clientSecretArn(Consumer<Secret.Builder> clientSecretArn) {
            return clientSecretArn(Secret.builder().applyMutation(clientSecretArn).build());
        }

        /**
         * <p>
         * The name of the OAuth2 credential provider.
         * </p>
         * 
         * @param name
         *        The name of the OAuth2 credential provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the OAuth2 credential provider.
         * </p>
         * 
         * @param credentialProviderArn
         *        The Amazon Resource Name (ARN) of the OAuth2 credential provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialProviderArn(String credentialProviderArn);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private Secret clientSecretArn;

        private String name;

        private String credentialProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOauth2CredentialProviderResponse model) {
            super(model);
            clientSecretArn(model.clientSecretArn);
            name(model.name);
            credentialProviderArn(model.credentialProviderArn);
        }

        public final Secret.Builder getClientSecretArn() {
            return clientSecretArn != null ? clientSecretArn.toBuilder() : null;
        }

        public final void setClientSecretArn(Secret.BuilderImpl clientSecretArn) {
            this.clientSecretArn = clientSecretArn != null ? clientSecretArn.build() : null;
        }

        @Override
        public final Builder clientSecretArn(Secret clientSecretArn) {
            this.clientSecretArn = clientSecretArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCredentialProviderArn() {
            return credentialProviderArn;
        }

        public final void setCredentialProviderArn(String credentialProviderArn) {
            this.credentialProviderArn = credentialProviderArn;
        }

        @Override
        public final Builder credentialProviderArn(String credentialProviderArn) {
            this.credentialProviderArn = credentialProviderArn;
            return this;
        }

        @Override
        public CreateOauth2CredentialProviderResponse build() {
            return new CreateOauth2CredentialProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
