/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCodeInterpreterResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<CreateCodeInterpreterResponse.Builder, CreateCodeInterpreterResponse> {
    private static final SdkField<String> CODE_INTERPRETER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterId").getter(getter(CreateCodeInterpreterResponse::codeInterpreterId))
            .setter(setter(Builder::codeInterpreterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterId").build()).build();

    private static final SdkField<String> CODE_INTERPRETER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterArn").getter(getter(CreateCodeInterpreterResponse::codeInterpreterArn))
            .setter(setter(Builder::codeInterpreterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterArn").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateCodeInterpreterResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateCodeInterpreterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_INTERPRETER_ID_FIELD,
            CODE_INTERPRETER_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String codeInterpreterId;

    private final String codeInterpreterArn;

    private final Instant createdAt;

    private final String status;

    private CreateCodeInterpreterResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterId = builder.codeInterpreterId;
        this.codeInterpreterArn = builder.codeInterpreterArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the created code interpreter.
     * </p>
     * 
     * @return The unique identifier of the created code interpreter.
     */
    public final String codeInterpreterId() {
        return codeInterpreterId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created code interpreter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created code interpreter.
     */
    public final String codeInterpreterArn() {
        return codeInterpreterArn;
    }

    /**
     * <p>
     * The timestamp when the code interpreter was created.
     * </p>
     * 
     * @return The timestamp when the code interpreter was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The current status of the code interpreter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeInterpreterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code interpreter.
     * @see CodeInterpreterStatus
     */
    public final CodeInterpreterStatus status() {
        return CodeInterpreterStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the code interpreter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeInterpreterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code interpreter.
     * @see CodeInterpreterStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterId());
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeInterpreterResponse)) {
            return false;
        }
        CreateCodeInterpreterResponse other = (CreateCodeInterpreterResponse) obj;
        return Objects.equals(codeInterpreterId(), other.codeInterpreterId())
                && Objects.equals(codeInterpreterArn(), other.codeInterpreterArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCodeInterpreterResponse").add("CodeInterpreterId", codeInterpreterId())
                .add("CodeInterpreterArn", codeInterpreterArn()).add("CreatedAt", createdAt()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeInterpreterId":
            return Optional.ofNullable(clazz.cast(codeInterpreterId()));
        case "codeInterpreterArn":
            return Optional.ofNullable(clazz.cast(codeInterpreterArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeInterpreterId", CODE_INTERPRETER_ID_FIELD);
        map.put("codeInterpreterArn", CODE_INTERPRETER_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeInterpreterResponse, T> g) {
        return obj -> g.apply((CreateCodeInterpreterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCodeInterpreterResponse> {
        /**
         * <p>
         * The unique identifier of the created code interpreter.
         * </p>
         * 
         * @param codeInterpreterId
         *        The unique identifier of the created code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterId(String codeInterpreterId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the created code interpreter.
         * </p>
         * 
         * @param codeInterpreterArn
         *        The Amazon Resource Name (ARN) of the created code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterArn(String codeInterpreterArn);

        /**
         * <p>
         * The timestamp when the code interpreter was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the code interpreter was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The current status of the code interpreter.
         * </p>
         * 
         * @param status
         *        The current status of the code interpreter.
         * @see CodeInterpreterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeInterpreterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the code interpreter.
         * </p>
         * 
         * @param status
         *        The current status of the code interpreter.
         * @see CodeInterpreterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeInterpreterStatus
         */
        Builder status(CodeInterpreterStatus status);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String codeInterpreterId;

        private String codeInterpreterArn;

        private Instant createdAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeInterpreterResponse model) {
            super(model);
            codeInterpreterId(model.codeInterpreterId);
            codeInterpreterArn(model.codeInterpreterArn);
            createdAt(model.createdAt);
            status(model.status);
        }

        public final String getCodeInterpreterId() {
            return codeInterpreterId;
        }

        public final void setCodeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
        }

        @Override
        public final Builder codeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
            return this;
        }

        public final String getCodeInterpreterArn() {
            return codeInterpreterArn;
        }

        public final void setCodeInterpreterArn(String codeInterpreterArn) {
            this.codeInterpreterArn = codeInterpreterArn;
        }

        @Override
        public final Builder codeInterpreterArn(String codeInterpreterArn) {
            this.codeInterpreterArn = codeInterpreterArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeInterpreterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateCodeInterpreterResponse build() {
            return new CreateCodeInterpreterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
