/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBrowserResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<CreateBrowserResponse.Builder, CreateBrowserResponse> {
    private static final SdkField<String> BROWSER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserId").getter(getter(CreateBrowserResponse::browserId)).setter(setter(Builder::browserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserId").build()).build();

    private static final SdkField<String> BROWSER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserArn").getter(getter(CreateBrowserResponse::browserArn)).setter(setter(Builder::browserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateBrowserResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateBrowserResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_ID_FIELD,
            BROWSER_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String browserId;

    private final String browserArn;

    private final Instant createdAt;

    private final String status;

    private CreateBrowserResponse(BuilderImpl builder) {
        super(builder);
        this.browserId = builder.browserId;
        this.browserArn = builder.browserArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the created browser.
     * </p>
     * 
     * @return The unique identifier of the created browser.
     */
    public final String browserId() {
        return browserId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created browser.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created browser.
     */
    public final String browserArn() {
        return browserArn;
    }

    /**
     * <p>
     * The timestamp when the browser was created.
     * </p>
     * 
     * @return The timestamp when the browser was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The current status of the browser.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser.
     * @see BrowserStatus
     */
    public final BrowserStatus status() {
        return BrowserStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the browser.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BrowserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the browser.
     * @see BrowserStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserId());
        hashCode = 31 * hashCode + Objects.hashCode(browserArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrowserResponse)) {
            return false;
        }
        CreateBrowserResponse other = (CreateBrowserResponse) obj;
        return Objects.equals(browserId(), other.browserId()) && Objects.equals(browserArn(), other.browserArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBrowserResponse").add("BrowserId", browserId()).add("BrowserArn", browserArn())
                .add("CreatedAt", createdAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserId":
            return Optional.ofNullable(clazz.cast(browserId()));
        case "browserArn":
            return Optional.ofNullable(clazz.cast(browserArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserId", BROWSER_ID_FIELD);
        map.put("browserArn", BROWSER_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBrowserResponse, T> g) {
        return obj -> g.apply((CreateBrowserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBrowserResponse> {
        /**
         * <p>
         * The unique identifier of the created browser.
         * </p>
         * 
         * @param browserId
         *        The unique identifier of the created browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserId(String browserId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the created browser.
         * </p>
         * 
         * @param browserArn
         *        The Amazon Resource Name (ARN) of the created browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserArn(String browserArn);

        /**
         * <p>
         * The timestamp when the browser was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the browser was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The current status of the browser.
         * </p>
         * 
         * @param status
         *        The current status of the browser.
         * @see BrowserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the browser.
         * </p>
         * 
         * @param status
         *        The current status of the browser.
         * @see BrowserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserStatus
         */
        Builder status(BrowserStatus status);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String browserId;

        private String browserArn;

        private Instant createdAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrowserResponse model) {
            super(model);
            browserId(model.browserId);
            browserArn(model.browserArn);
            createdAt(model.createdAt);
            status(model.status);
        }

        public final String getBrowserId() {
            return browserId;
        }

        public final void setBrowserId(String browserId) {
            this.browserId = browserId;
        }

        @Override
        public final Builder browserId(String browserId) {
            this.browserId = browserId;
            return this;
        }

        public final String getBrowserArn() {
            return browserArn;
        }

        public final void setBrowserArn(String browserArn) {
            this.browserArn = browserArn;
        }

        @Override
        public final Builder browserArn(String browserArn) {
            this.browserArn = browserArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateBrowserResponse build() {
            return new CreateBrowserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
