/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Representation of a container configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerConfiguration.Builder, ContainerConfiguration> {
    private static final SdkField<String> CONTAINER_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerUri").getter(getter(ContainerConfiguration::containerUri))
            .setter(setter(Builder::containerUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String containerUri;

    private ContainerConfiguration(BuilderImpl builder) {
        this.containerUri = builder.containerUri;
    }

    /**
     * <p>
     * The ECR URI of the container.
     * </p>
     * 
     * @return The ECR URI of the container.
     */
    public final String containerUri() {
        return containerUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerConfiguration)) {
            return false;
        }
        ContainerConfiguration other = (ContainerConfiguration) obj;
        return Objects.equals(containerUri(), other.containerUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerConfiguration").add("ContainerUri", containerUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerUri":
            return Optional.ofNullable(clazz.cast(containerUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerUri", CONTAINER_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerConfiguration, T> g) {
        return obj -> g.apply((ContainerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerConfiguration> {
        /**
         * <p>
         * The ECR URI of the container.
         * </p>
         * 
         * @param containerUri
         *        The ECR URI of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerUri(String containerUri);
    }

    static final class BuilderImpl implements Builder {
        private String containerUri;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerConfiguration model) {
            containerUri(model.containerUri);
        }

        public final String getContainerUri() {
            return containerUri;
        }

        public final void setContainerUri(String containerUri) {
            this.containerUri = containerUri;
        }

        @Override
        public final Builder containerUri(String containerUri) {
            this.containerUri = containerUri;
            return this;
        }

        @Override
        public ContainerConfiguration build() {
            return new ContainerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
