/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ConcurrentModificationException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ConflictException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DecryptionFailureException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EncryptionFailureException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.InternalServerException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ServiceException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ThrottledException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UnauthorizedException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ValidationException;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesIterable;
import software.amazon.awssdk.services.bedrockagentcorecontrol.waiters.BedrockAgentCoreControlWaiter;

/**
 * Service client for accessing Amazon Bedrock Agent Core Control Plane Fronting Layer. This can be created using the
 * static {@link #builder()} method.
 *
 * <p>
 * <note>
 * <p>
 * Amazon Bedrock AgentCore is in preview release and is subject to change.
 * </p>
 * </note>
 * <p>
 * Amazon Bedrock Agent Core Control is a service that enables you to manage memory resources for your Amazon Bedrock
 * agents.
 * </p>
 * <p>
 * Use this API to create, retrieve, update, and delete memory resources and their associated memory strategies. Memory
 * resources enable your agents to store and retrieve information from conversations and interactions.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentCoreControlClient extends AwsClient {
    String SERVICE_NAME = "bedrock-agentcore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agentcore-control";

    /**
     * <p>
     * Creates an Amazon Secure Agent.
     * </p>
     *
     * @param createAgentRuntimeRequest
     * @return Result of the CreateAgentRuntime operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAgentRuntimeResponse createAgentRuntime(CreateAgentRuntimeRequest createAgentRuntimeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param createAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAgentRuntime operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAgentRuntimeResponse createAgentRuntime(Consumer<CreateAgentRuntimeRequest.Builder> createAgentRuntimeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return createAgentRuntime(CreateAgentRuntimeRequest.builder().applyMutation(createAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param createAgentRuntimeEndpointRequest
     * @return Result of the CreateAgentRuntimeEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAgentRuntimeEndpointResponse createAgentRuntimeEndpoint(
            CreateAgentRuntimeEndpointRequest createAgentRuntimeEndpointRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param createAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return Result of the CreateAgentRuntimeEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAgentRuntimeEndpointResponse createAgentRuntimeEndpoint(
            Consumer<CreateAgentRuntimeEndpointRequest.Builder> createAgentRuntimeEndpointRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return createAgentRuntimeEndpoint(CreateAgentRuntimeEndpointRequest.builder()
                .applyMutation(createAgentRuntimeEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a new API key credential provider.
     * </p>
     *
     * @param createApiKeyCredentialProviderRequest
     * @return Result of the CreateApiKeyCredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ResourceLimitExceededException
     *         Exception thrown when a resource limit is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApiKeyCredentialProviderResponse createApiKeyCredentialProvider(
            CreateApiKeyCredentialProviderRequest createApiKeyCredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ResourceLimitExceededException, ValidationException, ConflictException, AccessDeniedException,
            DecryptionFailureException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            EncryptionFailureException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link CreateApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param createApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the CreateApiKeyCredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ResourceLimitExceededException
     *         Exception thrown when a resource limit is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApiKeyCredentialProviderResponse createApiKeyCredentialProvider(
            Consumer<CreateApiKeyCredentialProviderRequest.Builder> createApiKeyCredentialProviderRequest)
            throws ServiceQuotaExceededException, UnauthorizedException, ResourceLimitExceededException, ValidationException,
            ConflictException, AccessDeniedException, DecryptionFailureException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, EncryptionFailureException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return createApiKeyCredentialProvider(CreateApiKeyCredentialProviderRequest.builder()
                .applyMutation(createApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Creates a custom browser.
     * </p>
     *
     * @param createBrowserRequest
     * @return Result of the CreateBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBrowserResponse createBrowser(CreateBrowserRequest createBrowserRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom browser.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBrowserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBrowserRequest#builder()}
     * </p>
     *
     * @param createBrowserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserRequest.Builder} to
     *        create a request.
     * @return Result of the CreateBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBrowserResponse createBrowser(Consumer<CreateBrowserRequest.Builder> createBrowserRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return createBrowser(CreateBrowserRequest.builder().applyMutation(createBrowserRequest).build());
    }

    /**
     * <p>
     * Creates a custom code interpreter.
     * </p>
     *
     * @param createCodeInterpreterRequest
     * @return Result of the CreateCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeInterpreterResponse createCodeInterpreter(CreateCodeInterpreterRequest createCodeInterpreterRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom code interpreter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeInterpreterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCodeInterpreterRequest#builder()}
     * </p>
     *
     * @param createCodeInterpreterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCodeInterpreterResponse createCodeInterpreter(
            Consumer<CreateCodeInterpreterRequest.Builder> createCodeInterpreterRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return createCodeInterpreter(CreateCodeInterpreterRequest.builder().applyMutation(createCodeInterpreterRequest).build());
    }

    /**
     * <p>
     * Creates a gateway for Amazon Bedrock Agent. A gateway serves as an integration point between your agent and
     * external services.
     * </p>
     * <p>
     * To create a gateway, you must specify a name, protocol type, and IAM role. The role grants the gateway permission
     * to access Amazon Web Services services and resources.
     * </p>
     *
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway for Amazon Bedrock Agent. A gateway serves as an integration point between your agent and
     * external services.
     * </p>
     * <p>
     * To create a gateway, you must specify a name, protocol type, and IAM role. The role grants the gateway permission
     * to access Amazon Web Services services and resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayRequest.Builder} to
     *        create a request.
     * @return Result of the CreateGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGatewayResponse createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a target for a gateway. A target defines an endpoint that the gateway can connect to.
     * </p>
     * <p>
     * To create a target, you must specify the gateway identifier and target configuration.
     * </p>
     *
     * @param createGatewayTargetRequest
     * @return Result of the CreateGatewayTarget operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGatewayTargetResponse createGatewayTarget(CreateGatewayTargetRequest createGatewayTargetRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target for a gateway. A target defines an endpoint that the gateway can connect to.
     * </p>
     * <p>
     * To create a target, you must specify the gateway identifier and target configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGatewayTargetRequest#builder()}
     * </p>
     *
     * @param createGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetRequest.Builder}
     *        to create a request.
     * @return Result of the CreateGatewayTarget operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGatewayTargetResponse createGatewayTarget(
            Consumer<CreateGatewayTargetRequest.Builder> createGatewayTargetRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return createGatewayTarget(CreateGatewayTargetRequest.builder().applyMutation(createGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Creates a new memory.
     * </p>
     *
     * @param createMemoryRequest
     * @return Result of the CreateMemory operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMemoryResponse createMemory(CreateMemoryRequest createMemoryRequest) throws ServiceQuotaExceededException,
            ServiceException, ValidationException, AccessDeniedException, ConflictException, ResourceNotFoundException,
            ThrottledException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMemoryRequest#builder()}
     * </p>
     *
     * @param createMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryRequest.Builder} to
     *        create a request.
     * @return Result of the CreateMemory operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMemoryResponse createMemory(Consumer<CreateMemoryRequest.Builder> createMemoryRequest)
            throws ServiceQuotaExceededException, ServiceException, ValidationException, AccessDeniedException,
            ConflictException, ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return createMemory(CreateMemoryRequest.builder().applyMutation(createMemoryRequest).build());
    }

    /**
     * <p>
     * Creates a new OAuth2 credential provider.
     * </p>
     *
     * @param createOauth2CredentialProviderRequest
     * @return Result of the CreateOauth2CredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ResourceLimitExceededException
     *         Exception thrown when a resource limit is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOauth2CredentialProviderResponse createOauth2CredentialProvider(
            CreateOauth2CredentialProviderRequest createOauth2CredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ResourceLimitExceededException, ValidationException, ConflictException, AccessDeniedException,
            DecryptionFailureException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            EncryptionFailureException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link CreateOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param createOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the CreateOauth2CredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ResourceLimitExceededException
     *         Exception thrown when a resource limit is exceeded.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOauth2CredentialProviderResponse createOauth2CredentialProvider(
            Consumer<CreateOauth2CredentialProviderRequest.Builder> createOauth2CredentialProviderRequest)
            throws ServiceQuotaExceededException, UnauthorizedException, ResourceLimitExceededException, ValidationException,
            ConflictException, AccessDeniedException, DecryptionFailureException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, EncryptionFailureException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return createOauth2CredentialProvider(CreateOauth2CredentialProviderRequest.builder()
                .applyMutation(createOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Creates a new workload identity.
     * </p>
     *
     * @param createWorkloadIdentityRequest
     * @return Result of the CreateWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadIdentityResponse createWorkloadIdentity(CreateWorkloadIdentityRequest createWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param createWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return Result of the CreateWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.CreateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkloadIdentityResponse createWorkloadIdentity(
            Consumer<CreateWorkloadIdentityRequest.Builder> createWorkloadIdentityRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return createWorkloadIdentity(CreateWorkloadIdentityRequest.builder().applyMutation(createWorkloadIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Amazon Secure Agent.
     * </p>
     *
     * @param deleteAgentRuntimeRequest
     * @return Result of the DeleteAgentRuntime operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAgentRuntimeResponse deleteAgentRuntime(DeleteAgentRuntimeRequest deleteAgentRuntimeRequest)
            throws AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param deleteAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAgentRuntime operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAgentRuntimeResponse deleteAgentRuntime(Consumer<DeleteAgentRuntimeRequest.Builder> deleteAgentRuntimeRequest)
            throws AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return deleteAgentRuntime(DeleteAgentRuntimeRequest.builder().applyMutation(deleteAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param deleteAgentRuntimeEndpointRequest
     * @return Result of the DeleteAgentRuntimeEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAgentRuntimeEndpointResponse deleteAgentRuntimeEndpoint(
            DeleteAgentRuntimeEndpointRequest deleteAgentRuntimeEndpointRequest) throws AccessDeniedException, ConflictException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param deleteAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteAgentRuntimeEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAgentRuntimeEndpointResponse deleteAgentRuntimeEndpoint(
            Consumer<DeleteAgentRuntimeEndpointRequest.Builder> deleteAgentRuntimeEndpointRequest) throws AccessDeniedException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return deleteAgentRuntimeEndpoint(DeleteAgentRuntimeEndpointRequest.builder()
                .applyMutation(deleteAgentRuntimeEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an API key credential provider.
     * </p>
     *
     * @param deleteApiKeyCredentialProviderRequest
     * @return Result of the DeleteApiKeyCredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApiKeyCredentialProviderResponse deleteApiKeyCredentialProvider(
            DeleteApiKeyCredentialProviderRequest deleteApiKeyCredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param deleteApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteApiKeyCredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApiKeyCredentialProviderResponse deleteApiKeyCredentialProvider(
            Consumer<DeleteApiKeyCredentialProviderRequest.Builder> deleteApiKeyCredentialProviderRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return deleteApiKeyCredentialProvider(DeleteApiKeyCredentialProviderRequest.builder()
                .applyMutation(deleteApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Deletes a custom browser.
     * </p>
     *
     * @param deleteBrowserRequest
     * @return Result of the DeleteBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBrowserResponse deleteBrowser(DeleteBrowserRequest deleteBrowserRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom browser.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBrowserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBrowserRequest#builder()}
     * </p>
     *
     * @param deleteBrowserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBrowserResponse deleteBrowser(Consumer<DeleteBrowserRequest.Builder> deleteBrowserRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return deleteBrowser(DeleteBrowserRequest.builder().applyMutation(deleteBrowserRequest).build());
    }

    /**
     * <p>
     * Deletes a custom code interpreter.
     * </p>
     *
     * @param deleteCodeInterpreterRequest
     * @return Result of the DeleteCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeInterpreterResponse deleteCodeInterpreter(DeleteCodeInterpreterRequest deleteCodeInterpreterRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom code interpreter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeInterpreterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCodeInterpreterRequest#builder()}
     * </p>
     *
     * @param deleteCodeInterpreterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCodeInterpreterResponse deleteCodeInterpreter(
            Consumer<DeleteCodeInterpreterRequest.Builder> deleteCodeInterpreterRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return deleteCodeInterpreter(DeleteCodeInterpreterRequest.builder().applyMutation(deleteCodeInterpreterRequest).build());
    }

    /**
     * <p>
     * Deletes a Gateway.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGatewayResponse deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest)
            throws ValidationException, AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a Gateway Target.
     * </p>
     *
     * @param deleteGatewayTargetRequest
     * @return Result of the DeleteGatewayTarget operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGatewayTargetResponse deleteGatewayTarget(DeleteGatewayTargetRequest deleteGatewayTargetRequest)
            throws ValidationException, AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Gateway Target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGatewayTargetRequest#builder()}
     * </p>
     *
     * @param deleteGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteGatewayTarget operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGatewayTargetResponse deleteGatewayTarget(
            Consumer<DeleteGatewayTargetRequest.Builder> deleteGatewayTargetRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return deleteGatewayTarget(DeleteGatewayTargetRequest.builder().applyMutation(deleteGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Deletes a memory.
     * </p>
     *
     * @param deleteMemoryRequest
     * @return Result of the DeleteMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMemoryResponse deleteMemory(DeleteMemoryRequest deleteMemoryRequest) throws ServiceException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMemoryRequest#builder()}
     * </p>
     *
     * @param deleteMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMemoryResponse deleteMemory(Consumer<DeleteMemoryRequest.Builder> deleteMemoryRequest) throws ServiceException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return deleteMemory(DeleteMemoryRequest.builder().applyMutation(deleteMemoryRequest).build());
    }

    /**
     * <p>
     * Deletes an OAuth2 credential provider.
     * </p>
     *
     * @param deleteOauth2CredentialProviderRequest
     * @return Result of the DeleteOauth2CredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOauth2CredentialProviderResponse deleteOauth2CredentialProvider(
            DeleteOauth2CredentialProviderRequest deleteOauth2CredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param deleteOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteOauth2CredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOauth2CredentialProviderResponse deleteOauth2CredentialProvider(
            Consumer<DeleteOauth2CredentialProviderRequest.Builder> deleteOauth2CredentialProviderRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return deleteOauth2CredentialProvider(DeleteOauth2CredentialProviderRequest.builder()
                .applyMutation(deleteOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Deletes a workload identity.
     * </p>
     *
     * @param deleteWorkloadIdentityRequest
     * @return Result of the DeleteWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadIdentityResponse deleteWorkloadIdentity(DeleteWorkloadIdentityRequest deleteWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.DeleteWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkloadIdentityResponse deleteWorkloadIdentity(
            Consumer<DeleteWorkloadIdentityRequest.Builder> deleteWorkloadIdentityRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return deleteWorkloadIdentity(DeleteWorkloadIdentityRequest.builder().applyMutation(deleteWorkloadIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Gets an Amazon Secure Agent.
     * </p>
     *
     * @param getAgentRuntimeRequest
     * @return Result of the GetAgentRuntime operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentRuntimeResponse getAgentRuntime(GetAgentRuntimeRequest getAgentRuntimeRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentRuntimeRequest.Builder} avoiding the need
     * to create one manually via {@link GetAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param getAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return Result of the GetAgentRuntime operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentRuntimeResponse getAgentRuntime(Consumer<GetAgentRuntimeRequest.Builder> getAgentRuntimeRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return getAgentRuntime(GetAgentRuntimeRequest.builder().applyMutation(getAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Gets information about an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param getAgentRuntimeEndpointRequest
     * @return Result of the GetAgentRuntimeEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentRuntimeEndpointResponse getAgentRuntimeEndpoint(GetAgentRuntimeEndpointRequest getAgentRuntimeEndpointRequest)
            throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link GetAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param getAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return Result of the GetAgentRuntimeEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentRuntimeEndpointResponse getAgentRuntimeEndpoint(
            Consumer<GetAgentRuntimeEndpointRequest.Builder> getAgentRuntimeEndpointRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return getAgentRuntimeEndpoint(GetAgentRuntimeEndpointRequest.builder().applyMutation(getAgentRuntimeEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about an API key credential provider.
     * </p>
     *
     * @param getApiKeyCredentialProviderRequest
     * @return Result of the GetApiKeyCredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApiKeyCredentialProviderResponse getApiKeyCredentialProvider(
            GetApiKeyCredentialProviderRequest getApiKeyCredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, DecryptionFailureException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link GetApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param getApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the GetApiKeyCredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApiKeyCredentialProviderResponse getApiKeyCredentialProvider(
            Consumer<GetApiKeyCredentialProviderRequest.Builder> getApiKeyCredentialProviderRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, DecryptionFailureException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return getApiKeyCredentialProvider(GetApiKeyCredentialProviderRequest.builder()
                .applyMutation(getApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Gets information about a custom browser.
     * </p>
     *
     * @param getBrowserRequest
     * @return Result of the GetBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBrowserResponse getBrowser(GetBrowserRequest getBrowserRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a custom browser.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBrowserRequest.Builder} avoiding the need to
     * create one manually via {@link GetBrowserRequest#builder()}
     * </p>
     *
     * @param getBrowserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserRequest.Builder} to create
     *        a request.
     * @return Result of the GetBrowser operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBrowserResponse getBrowser(Consumer<GetBrowserRequest.Builder> getBrowserRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return getBrowser(GetBrowserRequest.builder().applyMutation(getBrowserRequest).build());
    }

    /**
     * <p>
     * Gets information about a custom code interpreter.
     * </p>
     *
     * @param getCodeInterpreterRequest
     * @return Result of the GetCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeInterpreterResponse getCodeInterpreter(GetCodeInterpreterRequest getCodeInterpreterRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a custom code interpreter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeInterpreterRequest.Builder} avoiding the
     * need to create one manually via {@link GetCodeInterpreterRequest#builder()}
     * </p>
     *
     * @param getCodeInterpreterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterRequest.Builder} to
     *        create a request.
     * @return Result of the GetCodeInterpreter operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCodeInterpreterResponse getCodeInterpreter(Consumer<GetCodeInterpreterRequest.Builder> getCodeInterpreterRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return getCodeInterpreter(GetCodeInterpreterRequest.builder().applyMutation(getCodeInterpreterRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return Result of the GetGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGatewayResponse getGateway(GetGatewayRequest getGatewayRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link GetGatewayRequest#builder()}
     * </p>
     *
     * @param getGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayRequest.Builder} to create
     *        a request.
     * @return Result of the GetGateway operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGatewayResponse getGateway(Consumer<GetGatewayRequest.Builder> getGatewayRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return getGateway(GetGatewayRequest.builder().applyMutation(getGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway Target.
     * </p>
     *
     * @param getGatewayTargetRequest
     * @return Result of the GetGatewayTarget operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGatewayTargetResponse getGatewayTarget(GetGatewayTargetRequest getGatewayTargetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway Target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayTargetRequest.Builder} avoiding the need
     * to create one manually via {@link GetGatewayTargetRequest#builder()}
     * </p>
     *
     * @param getGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetRequest.Builder} to
     *        create a request.
     * @return Result of the GetGatewayTarget operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGatewayTargetResponse getGatewayTarget(Consumer<GetGatewayTargetRequest.Builder> getGatewayTargetRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return getGatewayTarget(GetGatewayTargetRequest.builder().applyMutation(getGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Retrieve an existing memory.
     * </p>
     *
     * @param getMemoryRequest
     * @return Result of the GetMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMemoryResponse getMemory(GetMemoryRequest getMemoryRequest) throws ServiceException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve an existing memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemoryRequest#builder()}
     * </p>
     *
     * @param getMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryRequest.Builder} to create a
     *        request.
     * @return Result of the GetMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMemoryResponse getMemory(Consumer<GetMemoryRequest.Builder> getMemoryRequest) throws ServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return getMemory(GetMemoryRequest.builder().applyMutation(getMemoryRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an OAuth2 credential provider.
     * </p>
     *
     * @param getOauth2CredentialProviderRequest
     * @return Result of the GetOauth2CredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOauth2CredentialProviderResponse getOauth2CredentialProvider(
            GetOauth2CredentialProviderRequest getOauth2CredentialProviderRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, DecryptionFailureException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link GetOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param getOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the GetOauth2CredentialProvider operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOauth2CredentialProviderResponse getOauth2CredentialProvider(
            Consumer<GetOauth2CredentialProviderRequest.Builder> getOauth2CredentialProviderRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, DecryptionFailureException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return getOauth2CredentialProvider(GetOauth2CredentialProviderRequest.builder()
                .applyMutation(getOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a token vault.
     * </p>
     *
     * @param getTokenVaultRequest
     * @return Result of the GetTokenVault operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetTokenVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetTokenVault"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTokenVaultResponse getTokenVault(GetTokenVaultRequest getTokenVaultRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a token vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTokenVaultRequest.Builder} avoiding the need to
     * create one manually via {@link GetTokenVaultRequest#builder()}
     * </p>
     *
     * @param getTokenVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultRequest.Builder} to
     *        create a request.
     * @return Result of the GetTokenVault operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetTokenVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetTokenVault"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTokenVaultResponse getTokenVault(Consumer<GetTokenVaultRequest.Builder> getTokenVaultRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return getTokenVault(GetTokenVaultRequest.builder().applyMutation(getTokenVaultRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a workload identity.
     * </p>
     *
     * @param getWorkloadIdentityRequest
     * @return Result of the GetWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetWorkloadIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadIdentityResponse getWorkloadIdentity(GetWorkloadIdentityRequest getWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param getWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return Result of the GetWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.GetWorkloadIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkloadIdentityResponse getWorkloadIdentity(
            Consumer<GetWorkloadIdentityRequest.Builder> getWorkloadIdentityRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return getWorkloadIdentity(GetWorkloadIdentityRequest.builder().applyMutation(getWorkloadIdentityRequest).build());
    }

    /**
     * <p>
     * Lists all endpoints for a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     * @return Result of the ListAgentRuntimeEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeEndpointsResponse listAgentRuntimeEndpoints(
            ListAgentRuntimeEndpointsRequest listAgentRuntimeEndpointsRequest) throws AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all endpoints for a specific Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeEndpointsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest.Builder}
     *        to create a request.
     * @return Result of the ListAgentRuntimeEndpoints operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeEndpointsResponse listAgentRuntimeEndpoints(
            Consumer<ListAgentRuntimeEndpointsRequest.Builder> listAgentRuntimeEndpointsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listAgentRuntimeEndpoints(ListAgentRuntimeEndpointsRequest.builder()
                .applyMutation(listAgentRuntimeEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsIterable responses = client.listAgentRuntimeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsIterable responses = client
     *             .listAgentRuntimeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsIterable responses = client.listAgentRuntimeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeEndpointsIterable listAgentRuntimeEndpointsPaginator(
            ListAgentRuntimeEndpointsRequest listAgentRuntimeEndpointsRequest) throws AccessDeniedException, ValidationException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return new ListAgentRuntimeEndpointsIterable(this, listAgentRuntimeEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsIterable responses = client.listAgentRuntimeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsIterable responses = client
     *             .listAgentRuntimeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsIterable responses = client.listAgentRuntimeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeEndpointsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeEndpointsIterable listAgentRuntimeEndpointsPaginator(
            Consumer<ListAgentRuntimeEndpointsRequest.Builder> listAgentRuntimeEndpointsRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listAgentRuntimeEndpointsPaginator(ListAgentRuntimeEndpointsRequest.builder()
                .applyMutation(listAgentRuntimeEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists all versions of a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     * @return Result of the ListAgentRuntimeVersions operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeVersionsResponse listAgentRuntimeVersions(
            ListAgentRuntimeVersionsRequest listAgentRuntimeVersionsRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all versions of a specific Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeVersionsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListAgentRuntimeVersions operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeVersionsResponse listAgentRuntimeVersions(
            Consumer<ListAgentRuntimeVersionsRequest.Builder> listAgentRuntimeVersionsRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listAgentRuntimeVersions(ListAgentRuntimeVersionsRequest.builder().applyMutation(listAgentRuntimeVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsIterable responses = client.listAgentRuntimeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsIterable responses = client
     *             .listAgentRuntimeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsIterable responses = client.listAgentRuntimeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeVersionsIterable listAgentRuntimeVersionsPaginator(
            ListAgentRuntimeVersionsRequest listAgentRuntimeVersionsRequest) throws AccessDeniedException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return new ListAgentRuntimeVersionsIterable(this, listAgentRuntimeVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsIterable responses = client.listAgentRuntimeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsIterable responses = client
     *             .listAgentRuntimeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsIterable responses = client.listAgentRuntimeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeVersionsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeVersionsIterable listAgentRuntimeVersionsPaginator(
            Consumer<ListAgentRuntimeVersionsRequest.Builder> listAgentRuntimeVersionsRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listAgentRuntimeVersionsPaginator(ListAgentRuntimeVersionsRequest.builder()
                .applyMutation(listAgentRuntimeVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon Secure Agents in your account.
     * </p>
     *
     * @param listAgentRuntimesRequest
     * @return Result of the ListAgentRuntimes operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimesResponse listAgentRuntimes(ListAgentRuntimesRequest listAgentRuntimesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon Secure Agents in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentRuntimesRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest.Builder} to
     *        create a request.
     * @return Result of the ListAgentRuntimes operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimesResponse listAgentRuntimes(Consumer<ListAgentRuntimesRequest.Builder> listAgentRuntimesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listAgentRuntimes(ListAgentRuntimesRequest.builder().applyMutation(listAgentRuntimesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesIterable responses = client.listAgentRuntimesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesIterable responses = client
     *             .listAgentRuntimesPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesIterable responses = client.listAgentRuntimesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentRuntimesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimesIterable listAgentRuntimesPaginator(ListAgentRuntimesRequest listAgentRuntimesRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return new ListAgentRuntimesIterable(this, listAgentRuntimesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesIterable responses = client.listAgentRuntimesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesIterable responses = client
     *             .listAgentRuntimesPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesIterable responses = client.listAgentRuntimesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentRuntimesRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimesIterable listAgentRuntimesPaginator(
            Consumer<ListAgentRuntimesRequest.Builder> listAgentRuntimesRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listAgentRuntimesPaginator(ListAgentRuntimesRequest.builder().applyMutation(listAgentRuntimesRequest).build());
    }

    /**
     * <p>
     * Lists all API key credential providers in your account.
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     * @return Result of the ListApiKeyCredentialProviders operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApiKeyCredentialProvidersResponse listApiKeyCredentialProviders(
            ListApiKeyCredentialProvidersRequest listApiKeyCredentialProvidersRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all API key credential providers in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeyCredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListApiKeyCredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest.Builder}
     *        to create a request.
     * @return Result of the ListApiKeyCredentialProviders operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApiKeyCredentialProvidersResponse listApiKeyCredentialProviders(
            Consumer<ListApiKeyCredentialProvidersRequest.Builder> listApiKeyCredentialProvidersRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listApiKeyCredentialProviders(ListApiKeyCredentialProvidersRequest.builder()
                .applyMutation(listApiKeyCredentialProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersIterable responses = client.listApiKeyCredentialProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersIterable responses = client
     *             .listApiKeyCredentialProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersIterable responses = client.listApiKeyCredentialProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApiKeyCredentialProvidersIterable listApiKeyCredentialProvidersPaginator(
            ListApiKeyCredentialProvidersRequest listApiKeyCredentialProvidersRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return new ListApiKeyCredentialProvidersIterable(this, listApiKeyCredentialProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersIterable responses = client.listApiKeyCredentialProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersIterable responses = client
     *             .listApiKeyCredentialProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersIterable responses = client.listApiKeyCredentialProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeyCredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListApiKeyCredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApiKeyCredentialProvidersIterable listApiKeyCredentialProvidersPaginator(
            Consumer<ListApiKeyCredentialProvidersRequest.Builder> listApiKeyCredentialProvidersRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listApiKeyCredentialProvidersPaginator(ListApiKeyCredentialProvidersRequest.builder()
                .applyMutation(listApiKeyCredentialProvidersRequest).build());
    }

    /**
     * <p>
     * Lists all custom browsers in your account.
     * </p>
     *
     * @param listBrowsersRequest
     * @return Result of the ListBrowsers operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowsersResponse listBrowsers(ListBrowsersRequest listBrowsersRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom browsers in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListBrowsersRequest#builder()}
     * </p>
     *
     * @param listBrowsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest.Builder} to
     *        create a request.
     * @return Result of the ListBrowsers operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowsersResponse listBrowsers(Consumer<ListBrowsersRequest.Builder> listBrowsersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listBrowsers(ListBrowsersRequest.builder().applyMutation(listBrowsersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersIterable responses = client.listBrowsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersIterable responses = client
     *             .listBrowsersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersIterable responses = client.listBrowsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBrowsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowsersIterable listBrowsersPaginator(ListBrowsersRequest listBrowsersRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return new ListBrowsersIterable(this, listBrowsersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersIterable responses = client.listBrowsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersIterable responses = client
     *             .listBrowsersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersIterable responses = client.listBrowsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListBrowsersRequest#builder()}
     * </p>
     *
     * @param listBrowsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowsersIterable listBrowsersPaginator(Consumer<ListBrowsersRequest.Builder> listBrowsersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listBrowsersPaginator(ListBrowsersRequest.builder().applyMutation(listBrowsersRequest).build());
    }

    /**
     * <p>
     * Lists all custom code interpreters in your account.
     * </p>
     *
     * @param listCodeInterpretersRequest
     * @return Result of the ListCodeInterpreters operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpretersResponse listCodeInterpreters(ListCodeInterpretersRequest listCodeInterpretersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom code interpreters in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeInterpretersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeInterpretersRequest#builder()}
     * </p>
     *
     * @param listCodeInterpretersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest.Builder}
     *        to create a request.
     * @return Result of the ListCodeInterpreters operation returned by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpretersResponse listCodeInterpreters(
            Consumer<ListCodeInterpretersRequest.Builder> listCodeInterpretersRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listCodeInterpreters(ListCodeInterpretersRequest.builder().applyMutation(listCodeInterpretersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersIterable responses = client.listCodeInterpretersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersIterable responses = client
     *             .listCodeInterpretersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersIterable responses = client.listCodeInterpretersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodeInterpretersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpretersIterable listCodeInterpretersPaginator(ListCodeInterpretersRequest listCodeInterpretersRequest)
            throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return new ListCodeInterpretersIterable(this, listCodeInterpretersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersIterable responses = client.listCodeInterpretersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersIterable responses = client
     *             .listCodeInterpretersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersIterable responses = client.listCodeInterpretersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeInterpretersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeInterpretersRequest#builder()}
     * </p>
     *
     * @param listCodeInterpretersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpretersIterable listCodeInterpretersPaginator(
            Consumer<ListCodeInterpretersRequest.Builder> listCodeInterpretersRequest) throws AccessDeniedException,
            ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listCodeInterpretersPaginator(ListCodeInterpretersRequest.builder().applyMutation(listCodeInterpretersRequest)
                .build());
    }

    /**
     * <p>
     * Lists all targets for a specific Gateway.
     * </p>
     *
     * @param listGatewayTargetsRequest
     * @return Result of the ListGatewayTargets operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayTargetsResponse listGatewayTargets(ListGatewayTargetsRequest listGatewayTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all targets for a specific Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayTargetsRequest#builder()}
     * </p>
     *
     * @param listGatewayTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest.Builder} to
     *        create a request.
     * @return Result of the ListGatewayTargets operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayTargetsResponse listGatewayTargets(Consumer<ListGatewayTargetsRequest.Builder> listGatewayTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listGatewayTargets(ListGatewayTargetsRequest.builder().applyMutation(listGatewayTargetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsIterable responses = client.listGatewayTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsIterable responses = client
     *             .listGatewayTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsIterable responses = client.listGatewayTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayTargetsIterable listGatewayTargetsPaginator(ListGatewayTargetsRequest listGatewayTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return new ListGatewayTargetsIterable(this, listGatewayTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsIterable responses = client.listGatewayTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsIterable responses = client
     *             .listGatewayTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsIterable responses = client.listGatewayTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayTargetsRequest#builder()}
     * </p>
     *
     * @param listGatewayTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayTargetsIterable listGatewayTargetsPaginator(
            Consumer<ListGatewayTargetsRequest.Builder> listGatewayTargetsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listGatewayTargetsPaginator(ListGatewayTargetsRequest.builder().applyMutation(listGatewayTargetsRequest).build());
    }

    /**
     * <p>
     * Lists all Gateways in the account.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Gateways in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest.Builder} to
     *        create a request.
     * @return Result of the ListGateways operation returned by the service.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewaysResponse listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return new ListGatewaysIterable(this, listGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewaysIterable listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists the memory present.
     * </p>
     *
     * @param listMemoriesRequest
     * @return Result of the ListMemories operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoriesResponse listMemories(ListMemoriesRequest listMemoriesRequest) throws ServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the memory present.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMemoriesRequest#builder()}
     * </p>
     *
     * @param listMemoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest.Builder} to
     *        create a request.
     * @return Result of the ListMemories operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoriesResponse listMemories(Consumer<ListMemoriesRequest.Builder> listMemoriesRequest) throws ServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return listMemories(ListMemoriesRequest.builder().applyMutation(listMemoriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesIterable responses = client.listMemoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesIterable responses = client
     *             .listMemoriesPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesIterable responses = client.listMemoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMemoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoriesIterable listMemoriesPaginator(ListMemoriesRequest listMemoriesRequest) throws ServiceException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottledException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return new ListMemoriesIterable(this, listMemoriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesIterable responses = client.listMemoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesIterable responses = client
     *             .listMemoriesPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesIterable responses = client.listMemoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMemoriesRequest#builder()}
     * </p>
     *
     * @param listMemoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoriesIterable listMemoriesPaginator(Consumer<ListMemoriesRequest.Builder> listMemoriesRequest)
            throws ServiceException, AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottledException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return listMemoriesPaginator(ListMemoriesRequest.builder().applyMutation(listMemoriesRequest).build());
    }

    /**
     * <p>
     * Lists all OAuth2 credential providers in your account.
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     * @return Result of the ListOauth2CredentialProviders operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOauth2CredentialProvidersResponse listOauth2CredentialProviders(
            ListOauth2CredentialProvidersRequest listOauth2CredentialProvidersRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all OAuth2 credential providers in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOauth2CredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListOauth2CredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest.Builder}
     *        to create a request.
     * @return Result of the ListOauth2CredentialProviders operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOauth2CredentialProvidersResponse listOauth2CredentialProviders(
            Consumer<ListOauth2CredentialProvidersRequest.Builder> listOauth2CredentialProvidersRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listOauth2CredentialProviders(ListOauth2CredentialProvidersRequest.builder()
                .applyMutation(listOauth2CredentialProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersIterable responses = client.listOauth2CredentialProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersIterable responses = client
     *             .listOauth2CredentialProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersIterable responses = client.listOauth2CredentialProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOauth2CredentialProvidersIterable listOauth2CredentialProvidersPaginator(
            ListOauth2CredentialProvidersRequest listOauth2CredentialProvidersRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return new ListOauth2CredentialProvidersIterable(this, listOauth2CredentialProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersIterable responses = client.listOauth2CredentialProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersIterable responses = client
     *             .listOauth2CredentialProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersIterable responses = client.listOauth2CredentialProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOauth2CredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListOauth2CredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOauth2CredentialProvidersIterable listOauth2CredentialProvidersPaginator(
            Consumer<ListOauth2CredentialProvidersRequest.Builder> listOauth2CredentialProvidersRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return listOauth2CredentialProvidersPaginator(ListOauth2CredentialProvidersRequest.builder()
                .applyMutation(listOauth2CredentialProvidersRequest).build());
    }

    /**
     * <p>
     * Lists all workload identities in your account.
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     * @return Result of the ListWorkloadIdentities operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadIdentitiesResponse listWorkloadIdentities(ListWorkloadIdentitiesRequest listWorkloadIdentitiesRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all workload identities in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadIdentitiesRequest#builder()}
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest.Builder}
     *        to create a request.
     * @return Result of the ListWorkloadIdentities operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadIdentitiesResponse listWorkloadIdentities(
            Consumer<ListWorkloadIdentitiesRequest.Builder> listWorkloadIdentitiesRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return listWorkloadIdentities(ListWorkloadIdentitiesRequest.builder().applyMutation(listWorkloadIdentitiesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesIterable responses = client.listWorkloadIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesIterable responses = client
     *             .listWorkloadIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesIterable responses = client.listWorkloadIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadIdentitiesIterable listWorkloadIdentitiesPaginator(
            ListWorkloadIdentitiesRequest listWorkloadIdentitiesRequest) throws UnauthorizedException, ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, BedrockAgentCoreControlException {
        return new ListWorkloadIdentitiesIterable(this, listWorkloadIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesIterable responses = client.listWorkloadIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesIterable responses = client
     *             .listWorkloadIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesIterable responses = client.listWorkloadIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadIdentitiesRequest#builder()}
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadIdentitiesIterable listWorkloadIdentitiesPaginator(
            Consumer<ListWorkloadIdentitiesRequest.Builder> listWorkloadIdentitiesRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return listWorkloadIdentitiesPaginator(ListWorkloadIdentitiesRequest.builder()
                .applyMutation(listWorkloadIdentitiesRequest).build());
    }

    /**
     * <p>
     * Sets the customer master key (CMK) for a token vault.
     * </p>
     *
     * @param setTokenVaultCmkRequest
     * @return Result of the SetTokenVaultCMK operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ConcurrentModificationException
     *         Exception thrown when a resource is modified concurrently by multiple requests.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.SetTokenVaultCMK
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/SetTokenVaultCMK"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTokenVaultCmkResponse setTokenVaultCMK(SetTokenVaultCmkRequest setTokenVaultCmkRequest)
            throws UnauthorizedException, ConcurrentModificationException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the customer master key (CMK) for a token vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTokenVaultCmkRequest.Builder} avoiding the need
     * to create one manually via {@link SetTokenVaultCmkRequest#builder()}
     * </p>
     *
     * @param setTokenVaultCmkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkRequest.Builder} to
     *        create a request.
     * @return Result of the SetTokenVaultCMK operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ConcurrentModificationException
     *         Exception thrown when a resource is modified concurrently by multiple requests.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.SetTokenVaultCMK
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/SetTokenVaultCMK"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTokenVaultCmkResponse setTokenVaultCMK(Consumer<SetTokenVaultCmkRequest.Builder> setTokenVaultCmkRequest)
            throws UnauthorizedException, ConcurrentModificationException, ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return setTokenVaultCMK(SetTokenVaultCmkRequest.builder().applyMutation(setTokenVaultCmkRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Secure Agent.
     * </p>
     *
     * @param updateAgentRuntimeRequest
     * @return Result of the UpdateAgentRuntime operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAgentRuntimeResponse updateAgentRuntime(UpdateAgentRuntimeRequest updateAgentRuntimeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param updateAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAgentRuntime operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAgentRuntimeResponse updateAgentRuntime(Consumer<UpdateAgentRuntimeRequest.Builder> updateAgentRuntimeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return updateAgentRuntime(UpdateAgentRuntimeRequest.builder().applyMutation(updateAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param updateAgentRuntimeEndpointRequest
     * @return Result of the UpdateAgentRuntimeEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAgentRuntimeEndpointResponse updateAgentRuntimeEndpoint(
            UpdateAgentRuntimeEndpointRequest updateAgentRuntimeEndpointRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param updateAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateAgentRuntimeEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAgentRuntimeEndpointResponse updateAgentRuntimeEndpoint(
            Consumer<UpdateAgentRuntimeEndpointRequest.Builder> updateAgentRuntimeEndpointRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return updateAgentRuntimeEndpoint(UpdateAgentRuntimeEndpointRequest.builder()
                .applyMutation(updateAgentRuntimeEndpointRequest).build());
    }

    /**
     * <p>
     * Updates an existing API key credential provider.
     * </p>
     *
     * @param updateApiKeyCredentialProviderRequest
     * @return Result of the UpdateApiKeyCredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApiKeyCredentialProviderResponse updateApiKeyCredentialProvider(
            UpdateApiKeyCredentialProviderRequest updateApiKeyCredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ValidationException, AccessDeniedException, ConflictException, DecryptionFailureException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, EncryptionFailureException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param updateApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateApiKeyCredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApiKeyCredentialProviderResponse updateApiKeyCredentialProvider(
            Consumer<UpdateApiKeyCredentialProviderRequest.Builder> updateApiKeyCredentialProviderRequest)
            throws ServiceQuotaExceededException, UnauthorizedException, ValidationException, AccessDeniedException,
            ConflictException, DecryptionFailureException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, EncryptionFailureException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return updateApiKeyCredentialProvider(UpdateApiKeyCredentialProviderRequest.builder()
                .applyMutation(updateApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Updates an existing Gateway.
     * </p>
     *
     * @param updateGatewayRequest
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayResponse updateGateway(UpdateGatewayRequest updateGatewayRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGatewayRequest#builder()}
     * </p>
     *
     * @param updateGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayResponse updateGateway(Consumer<UpdateGatewayRequest.Builder> updateGatewayRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return updateGateway(UpdateGatewayRequest.builder().applyMutation(updateGatewayRequest).build());
    }

    /**
     * <p>
     * Updates an existing Gateway Target.
     * </p>
     *
     * @param updateGatewayTargetRequest
     * @return Result of the UpdateGatewayTarget operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayTargetResponse updateGatewayTarget(UpdateGatewayTargetRequest updateGatewayTargetRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Gateway Target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayTargetRequest#builder()}
     * </p>
     *
     * @param updateGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateGatewayTarget operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGatewayTargetResponse updateGatewayTarget(
            Consumer<UpdateGatewayTargetRequest.Builder> updateGatewayTargetRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return updateGatewayTarget(UpdateGatewayTargetRequest.builder().applyMutation(updateGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Update memory.
     * </p>
     *
     * @param updateMemoryRequest
     * @return Result of the UpdateMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMemoryResponse updateMemory(UpdateMemoryRequest updateMemoryRequest) throws ServiceException,
            ServiceQuotaExceededException, ValidationException, AccessDeniedException, ConflictException,
            ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMemoryRequest#builder()}
     * </p>
     *
     * @param updateMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateMemory operation returned by the service.
     * @throws ServiceException
     *         An internal error occurred.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottledException
     *         API rate limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMemoryResponse updateMemory(Consumer<UpdateMemoryRequest.Builder> updateMemoryRequest) throws ServiceException,
            ServiceQuotaExceededException, ValidationException, AccessDeniedException, ConflictException,
            ResourceNotFoundException, ThrottledException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return updateMemory(UpdateMemoryRequest.builder().applyMutation(updateMemoryRequest).build());
    }

    /**
     * <p>
     * Updates an existing OAuth2 credential provider.
     * </p>
     *
     * @param updateOauth2CredentialProviderRequest
     * @return Result of the UpdateOauth2CredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOauth2CredentialProviderResponse updateOauth2CredentialProvider(
            UpdateOauth2CredentialProviderRequest updateOauth2CredentialProviderRequest) throws ServiceQuotaExceededException,
            UnauthorizedException, ValidationException, AccessDeniedException, ConflictException, DecryptionFailureException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, EncryptionFailureException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param updateOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateOauth2CredentialProvider operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when a request is made beyond the service quota
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ConflictException
     *         This exception is thrown when there is a conflict performing an operation
     * @throws DecryptionFailureException
     *         Exception thrown when decryption of a secret fails.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws EncryptionFailureException
     *         Exception thrown when encryption of a secret fails.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOauth2CredentialProviderResponse updateOauth2CredentialProvider(
            Consumer<UpdateOauth2CredentialProviderRequest.Builder> updateOauth2CredentialProviderRequest)
            throws ServiceQuotaExceededException, UnauthorizedException, ValidationException, AccessDeniedException,
            ConflictException, DecryptionFailureException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, EncryptionFailureException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        return updateOauth2CredentialProvider(UpdateOauth2CredentialProviderRequest.builder()
                .applyMutation(updateOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Updates an existing workload identity.
     * </p>
     *
     * @param updateWorkloadIdentityRequest
     * @return Result of the UpdateWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadIdentityResponse updateWorkloadIdentity(UpdateWorkloadIdentityRequest updateWorkloadIdentityRequest)
            throws UnauthorizedException, ValidationException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            BedrockAgentCoreControlException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param updateWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateWorkloadIdentity operation returned by the service.
     * @throws UnauthorizedException
     *         This exception is thrown when the JWT bearer token is invalid or not found for OAuth bearer token based
     *         access
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service.
     * @throws AccessDeniedException
     *         This exception is thrown when a request is denied per access permissions
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource referenced by the operation does not exist
     * @throws ThrottlingException
     *         This exception is thrown when the number of requests exceeds the limit
     * @throws InternalServerException
     *         This exception is thrown if there was an unexpected error during processing of request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BedrockAgentCoreControlException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BedrockAgentCoreControlClient.UpdateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateWorkloadIdentityResponse updateWorkloadIdentity(
            Consumer<UpdateWorkloadIdentityRequest.Builder> updateWorkloadIdentityRequest) throws UnauthorizedException,
            ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, BedrockAgentCoreControlException {
        return updateWorkloadIdentity(UpdateWorkloadIdentityRequest.builder().applyMutation(updateWorkloadIdentityRequest)
                .build());
    }

    /**
     * Create an instance of {@link BedrockAgentCoreControlWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link BedrockAgentCoreControlWaiter}
     */
    default BedrockAgentCoreControlWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentCoreControlClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentCoreControlClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentCoreControlClient}.
     */
    static BedrockAgentCoreControlClientBuilder builder() {
        return new DefaultBedrockAgentCoreControlClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BedrockAgentCoreControlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
