/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesPublisher;
import software.amazon.awssdk.services.bedrockagentcorecontrol.waiters.BedrockAgentCoreControlAsyncWaiter;

/**
 * Service client for accessing Amazon Bedrock Agent Core Control Plane Fronting Layer asynchronously. This can be
 * created using the static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured
 * with any {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async
 * client may perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the
 * async API call.
 *
 * <p>
 * <note>
 * <p>
 * Amazon Bedrock AgentCore is in preview release and is subject to change.
 * </p>
 * </note>
 * <p>
 * Amazon Bedrock Agent Core Control is a service that enables you to manage memory resources for your Amazon Bedrock
 * agents.
 * </p>
 * <p>
 * Use this API to create, retrieve, update, and delete memory resources and their associated memory strategies. Memory
 * resources enable your agents to store and retrieve information from conversations and interactions.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentCoreControlAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock-agentcore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agentcore-control";

    /**
     * <p>
     * Creates an Amazon Secure Agent.
     * </p>
     *
     * @param createAgentRuntimeRequest
     * @return A Java Future containing the result of the CreateAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentRuntimeResponse> createAgentRuntime(CreateAgentRuntimeRequest createAgentRuntimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param createAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentRuntimeResponse> createAgentRuntime(
            Consumer<CreateAgentRuntimeRequest.Builder> createAgentRuntimeRequest) {
        return createAgentRuntime(CreateAgentRuntimeRequest.builder().applyMutation(createAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param createAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the CreateAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentRuntimeEndpointResponse> createAgentRuntimeEndpoint(
            CreateAgentRuntimeEndpointRequest createAgentRuntimeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param createAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAgentRuntimeEndpointResponse> createAgentRuntimeEndpoint(
            Consumer<CreateAgentRuntimeEndpointRequest.Builder> createAgentRuntimeEndpointRequest) {
        return createAgentRuntimeEndpoint(CreateAgentRuntimeEndpointRequest.builder()
                .applyMutation(createAgentRuntimeEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a new API key credential provider.
     * </p>
     *
     * @param createApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the CreateApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ResourceLimitExceededException Exception thrown when a resource limit is exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApiKeyCredentialProviderResponse> createApiKeyCredentialProvider(
            CreateApiKeyCredentialProviderRequest createApiKeyCredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link CreateApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param createApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ResourceLimitExceededException Exception thrown when a resource limit is exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApiKeyCredentialProviderResponse> createApiKeyCredentialProvider(
            Consumer<CreateApiKeyCredentialProviderRequest.Builder> createApiKeyCredentialProviderRequest) {
        return createApiKeyCredentialProvider(CreateApiKeyCredentialProviderRequest.builder()
                .applyMutation(createApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Creates a custom browser.
     * </p>
     *
     * @param createBrowserRequest
     * @return A Java Future containing the result of the CreateBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBrowserResponse> createBrowser(CreateBrowserRequest createBrowserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom browser.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBrowserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBrowserRequest#builder()}
     * </p>
     *
     * @param createBrowserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateBrowserRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBrowserResponse> createBrowser(Consumer<CreateBrowserRequest.Builder> createBrowserRequest) {
        return createBrowser(CreateBrowserRequest.builder().applyMutation(createBrowserRequest).build());
    }

    /**
     * <p>
     * Creates a custom code interpreter.
     * </p>
     *
     * @param createCodeInterpreterRequest
     * @return A Java Future containing the result of the CreateCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCodeInterpreterResponse> createCodeInterpreter(
            CreateCodeInterpreterRequest createCodeInterpreterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom code interpreter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeInterpreterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCodeInterpreterRequest#builder()}
     * </p>
     *
     * @param createCodeInterpreterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateCodeInterpreterRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCodeInterpreterResponse> createCodeInterpreter(
            Consumer<CreateCodeInterpreterRequest.Builder> createCodeInterpreterRequest) {
        return createCodeInterpreter(CreateCodeInterpreterRequest.builder().applyMutation(createCodeInterpreterRequest).build());
    }

    /**
     * <p>
     * Creates a gateway for Amazon Bedrock Agent. A gateway serves as an integration point between your agent and
     * external services.
     * </p>
     * <p>
     * To create a gateway, you must specify a name, protocol type, and IAM role. The role grants the gateway permission
     * to access Amazon Web Services services and resources.
     * </p>
     *
     * @param createGatewayRequest
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway for Amazon Bedrock Agent. A gateway serves as an integration point between your agent and
     * external services.
     * </p>
     * <p>
     * To create a gateway, you must specify a name, protocol type, and IAM role. The role grants the gateway permission
     * to access Amazon Web Services services and resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest) {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a target for a gateway. A target defines an endpoint that the gateway can connect to.
     * </p>
     * <p>
     * To create a target, you must specify the gateway identifier and target configuration.
     * </p>
     *
     * @param createGatewayTargetRequest
     * @return A Java Future containing the result of the CreateGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGatewayTargetResponse> createGatewayTarget(
            CreateGatewayTargetRequest createGatewayTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target for a gateway. A target defines an endpoint that the gateway can connect to.
     * </p>
     * <p>
     * To create a target, you must specify the gateway identifier and target configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGatewayTargetRequest#builder()}
     * </p>
     *
     * @param createGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateGatewayTargetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGatewayTargetResponse> createGatewayTarget(
            Consumer<CreateGatewayTargetRequest.Builder> createGatewayTargetRequest) {
        return createGatewayTarget(CreateGatewayTargetRequest.builder().applyMutation(createGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Creates a new memory.
     * </p>
     *
     * @param createMemoryRequest
     * @return A Java Future containing the result of the CreateMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMemoryResponse> createMemory(CreateMemoryRequest createMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMemoryRequest#builder()}
     * </p>
     *
     * @param createMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateMemoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMemoryResponse> createMemory(Consumer<CreateMemoryRequest.Builder> createMemoryRequest) {
        return createMemory(CreateMemoryRequest.builder().applyMutation(createMemoryRequest).build());
    }

    /**
     * <p>
     * Creates a new OAuth2 credential provider.
     * </p>
     *
     * @param createOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the CreateOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ResourceLimitExceededException Exception thrown when a resource limit is exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOauth2CredentialProviderResponse> createOauth2CredentialProvider(
            CreateOauth2CredentialProviderRequest createOauth2CredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link CreateOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param createOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ResourceLimitExceededException Exception thrown when a resource limit is exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOauth2CredentialProviderResponse> createOauth2CredentialProvider(
            Consumer<CreateOauth2CredentialProviderRequest.Builder> createOauth2CredentialProviderRequest) {
        return createOauth2CredentialProvider(CreateOauth2CredentialProviderRequest.builder()
                .applyMutation(createOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Creates a new workload identity.
     * </p>
     *
     * @param createWorkloadIdentityRequest
     * @return A Java Future containing the result of the CreateWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadIdentityResponse> createWorkloadIdentity(
            CreateWorkloadIdentityRequest createWorkloadIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param createWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CreateWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.CreateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/CreateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkloadIdentityResponse> createWorkloadIdentity(
            Consumer<CreateWorkloadIdentityRequest.Builder> createWorkloadIdentityRequest) {
        return createWorkloadIdentity(CreateWorkloadIdentityRequest.builder().applyMutation(createWorkloadIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Amazon Secure Agent.
     * </p>
     *
     * @param deleteAgentRuntimeRequest
     * @return A Java Future containing the result of the DeleteAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentRuntimeResponse> deleteAgentRuntime(DeleteAgentRuntimeRequest deleteAgentRuntimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param deleteAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentRuntimeResponse> deleteAgentRuntime(
            Consumer<DeleteAgentRuntimeRequest.Builder> deleteAgentRuntimeRequest) {
        return deleteAgentRuntime(DeleteAgentRuntimeRequest.builder().applyMutation(deleteAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param deleteAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the DeleteAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentRuntimeEndpointResponse> deleteAgentRuntimeEndpoint(
            DeleteAgentRuntimeEndpointRequest deleteAgentRuntimeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param deleteAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentRuntimeEndpointResponse> deleteAgentRuntimeEndpoint(
            Consumer<DeleteAgentRuntimeEndpointRequest.Builder> deleteAgentRuntimeEndpointRequest) {
        return deleteAgentRuntimeEndpoint(DeleteAgentRuntimeEndpointRequest.builder()
                .applyMutation(deleteAgentRuntimeEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an API key credential provider.
     * </p>
     *
     * @param deleteApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the DeleteApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApiKeyCredentialProviderResponse> deleteApiKeyCredentialProvider(
            DeleteApiKeyCredentialProviderRequest deleteApiKeyCredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param deleteApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApiKeyCredentialProviderResponse> deleteApiKeyCredentialProvider(
            Consumer<DeleteApiKeyCredentialProviderRequest.Builder> deleteApiKeyCredentialProviderRequest) {
        return deleteApiKeyCredentialProvider(DeleteApiKeyCredentialProviderRequest.builder()
                .applyMutation(deleteApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Deletes a custom browser.
     * </p>
     *
     * @param deleteBrowserRequest
     * @return A Java Future containing the result of the DeleteBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBrowserResponse> deleteBrowser(DeleteBrowserRequest deleteBrowserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom browser.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBrowserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBrowserRequest#builder()}
     * </p>
     *
     * @param deleteBrowserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteBrowserRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBrowserResponse> deleteBrowser(Consumer<DeleteBrowserRequest.Builder> deleteBrowserRequest) {
        return deleteBrowser(DeleteBrowserRequest.builder().applyMutation(deleteBrowserRequest).build());
    }

    /**
     * <p>
     * Deletes a custom code interpreter.
     * </p>
     *
     * @param deleteCodeInterpreterRequest
     * @return A Java Future containing the result of the DeleteCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCodeInterpreterResponse> deleteCodeInterpreter(
            DeleteCodeInterpreterRequest deleteCodeInterpreterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom code interpreter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeInterpreterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCodeInterpreterRequest#builder()}
     * </p>
     *
     * @param deleteCodeInterpreterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteCodeInterpreterRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCodeInterpreterResponse> deleteCodeInterpreter(
            Consumer<DeleteCodeInterpreterRequest.Builder> deleteCodeInterpreterRequest) {
        return deleteCodeInterpreter(DeleteCodeInterpreterRequest.builder().applyMutation(deleteCodeInterpreterRequest).build());
    }

    /**
     * <p>
     * Deletes a Gateway.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest) {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a Gateway Target.
     * </p>
     *
     * @param deleteGatewayTargetRequest
     * @return A Java Future containing the result of the DeleteGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayTargetResponse> deleteGatewayTarget(
            DeleteGatewayTargetRequest deleteGatewayTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Gateway Target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGatewayTargetRequest#builder()}
     * </p>
     *
     * @param deleteGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteGatewayTargetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayTargetResponse> deleteGatewayTarget(
            Consumer<DeleteGatewayTargetRequest.Builder> deleteGatewayTargetRequest) {
        return deleteGatewayTarget(DeleteGatewayTargetRequest.builder().applyMutation(deleteGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Deletes a memory.
     * </p>
     *
     * @param deleteMemoryRequest
     * @return A Java Future containing the result of the DeleteMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMemoryResponse> deleteMemory(DeleteMemoryRequest deleteMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMemoryRequest#builder()}
     * </p>
     *
     * @param deleteMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteMemoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMemoryResponse> deleteMemory(Consumer<DeleteMemoryRequest.Builder> deleteMemoryRequest) {
        return deleteMemory(DeleteMemoryRequest.builder().applyMutation(deleteMemoryRequest).build());
    }

    /**
     * <p>
     * Deletes an OAuth2 credential provider.
     * </p>
     *
     * @param deleteOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the DeleteOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOauth2CredentialProviderResponse> deleteOauth2CredentialProvider(
            DeleteOauth2CredentialProviderRequest deleteOauth2CredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param deleteOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOauth2CredentialProviderResponse> deleteOauth2CredentialProvider(
            Consumer<DeleteOauth2CredentialProviderRequest.Builder> deleteOauth2CredentialProviderRequest) {
        return deleteOauth2CredentialProvider(DeleteOauth2CredentialProviderRequest.builder()
                .applyMutation(deleteOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Deletes a workload identity.
     * </p>
     *
     * @param deleteWorkloadIdentityRequest
     * @return A Java Future containing the result of the DeleteWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadIdentityResponse> deleteWorkloadIdentity(
            DeleteWorkloadIdentityRequest deleteWorkloadIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param deleteWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.DeleteWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.DeleteWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/DeleteWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkloadIdentityResponse> deleteWorkloadIdentity(
            Consumer<DeleteWorkloadIdentityRequest.Builder> deleteWorkloadIdentityRequest) {
        return deleteWorkloadIdentity(DeleteWorkloadIdentityRequest.builder().applyMutation(deleteWorkloadIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Gets an Amazon Secure Agent.
     * </p>
     *
     * @param getAgentRuntimeRequest
     * @return A Java Future containing the result of the GetAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentRuntimeResponse> getAgentRuntime(GetAgentRuntimeRequest getAgentRuntimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentRuntimeRequest.Builder} avoiding the need
     * to create one manually via {@link GetAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param getAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentRuntimeResponse> getAgentRuntime(
            Consumer<GetAgentRuntimeRequest.Builder> getAgentRuntimeRequest) {
        return getAgentRuntime(GetAgentRuntimeRequest.builder().applyMutation(getAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Gets information about an Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param getAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the GetAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentRuntimeEndpointResponse> getAgentRuntimeEndpoint(
            GetAgentRuntimeEndpointRequest getAgentRuntimeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link GetAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param getAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentRuntimeEndpointResponse> getAgentRuntimeEndpoint(
            Consumer<GetAgentRuntimeEndpointRequest.Builder> getAgentRuntimeEndpointRequest) {
        return getAgentRuntimeEndpoint(GetAgentRuntimeEndpointRequest.builder().applyMutation(getAgentRuntimeEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about an API key credential provider.
     * </p>
     *
     * @param getApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the GetApiKeyCredentialProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApiKeyCredentialProviderResponse> getApiKeyCredentialProvider(
            GetApiKeyCredentialProviderRequest getApiKeyCredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link GetApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param getApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetApiKeyCredentialProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApiKeyCredentialProviderResponse> getApiKeyCredentialProvider(
            Consumer<GetApiKeyCredentialProviderRequest.Builder> getApiKeyCredentialProviderRequest) {
        return getApiKeyCredentialProvider(GetApiKeyCredentialProviderRequest.builder()
                .applyMutation(getApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Gets information about a custom browser.
     * </p>
     *
     * @param getBrowserRequest
     * @return A Java Future containing the result of the GetBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBrowserResponse> getBrowser(GetBrowserRequest getBrowserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a custom browser.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBrowserRequest.Builder} avoiding the need to
     * create one manually via {@link GetBrowserRequest#builder()}
     * </p>
     *
     * @param getBrowserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetBrowserRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetBrowser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetBrowser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetBrowser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBrowserResponse> getBrowser(Consumer<GetBrowserRequest.Builder> getBrowserRequest) {
        return getBrowser(GetBrowserRequest.builder().applyMutation(getBrowserRequest).build());
    }

    /**
     * <p>
     * Gets information about a custom code interpreter.
     * </p>
     *
     * @param getCodeInterpreterRequest
     * @return A Java Future containing the result of the GetCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCodeInterpreterResponse> getCodeInterpreter(GetCodeInterpreterRequest getCodeInterpreterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a custom code interpreter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeInterpreterRequest.Builder} avoiding the
     * need to create one manually via {@link GetCodeInterpreterRequest#builder()}
     * </p>
     *
     * @param getCodeInterpreterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetCodeInterpreterRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetCodeInterpreter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetCodeInterpreter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetCodeInterpreter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCodeInterpreterResponse> getCodeInterpreter(
            Consumer<GetCodeInterpreterRequest.Builder> getCodeInterpreterRequest) {
        return getCodeInterpreter(GetCodeInterpreterRequest.builder().applyMutation(getCodeInterpreterRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGatewayResponse> getGateway(GetGatewayRequest getGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link GetGatewayRequest#builder()}
     * </p>
     *
     * @param getGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGatewayResponse> getGateway(Consumer<GetGatewayRequest.Builder> getGatewayRequest) {
        return getGateway(GetGatewayRequest.builder().applyMutation(getGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway Target.
     * </p>
     *
     * @param getGatewayTargetRequest
     * @return A Java Future containing the result of the GetGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGatewayTargetResponse> getGatewayTarget(GetGatewayTargetRequest getGatewayTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific Gateway Target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayTargetRequest.Builder} avoiding the need
     * to create one manually via {@link GetGatewayTargetRequest#builder()}
     * </p>
     *
     * @param getGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetGatewayTargetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGatewayTargetResponse> getGatewayTarget(
            Consumer<GetGatewayTargetRequest.Builder> getGatewayTargetRequest) {
        return getGatewayTarget(GetGatewayTargetRequest.builder().applyMutation(getGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Retrieve an existing memory.
     * </p>
     *
     * @param getMemoryRequest
     * @return A Java Future containing the result of the GetMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMemoryResponse> getMemory(GetMemoryRequest getMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve an existing memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemoryRequest#builder()}
     * </p>
     *
     * @param getMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetMemoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMemoryResponse> getMemory(Consumer<GetMemoryRequest.Builder> getMemoryRequest) {
        return getMemory(GetMemoryRequest.builder().applyMutation(getMemoryRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an OAuth2 credential provider.
     * </p>
     *
     * @param getOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the GetOauth2CredentialProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOauth2CredentialProviderResponse> getOauth2CredentialProvider(
            GetOauth2CredentialProviderRequest getOauth2CredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link GetOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param getOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetOauth2CredentialProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOauth2CredentialProviderResponse> getOauth2CredentialProvider(
            Consumer<GetOauth2CredentialProviderRequest.Builder> getOauth2CredentialProviderRequest) {
        return getOauth2CredentialProvider(GetOauth2CredentialProviderRequest.builder()
                .applyMutation(getOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a token vault.
     * </p>
     *
     * @param getTokenVaultRequest
     * @return A Java Future containing the result of the GetTokenVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetTokenVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetTokenVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTokenVaultResponse> getTokenVault(GetTokenVaultRequest getTokenVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a token vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTokenVaultRequest.Builder} avoiding the need to
     * create one manually via {@link GetTokenVaultRequest#builder()}
     * </p>
     *
     * @param getTokenVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetTokenVaultRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTokenVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetTokenVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetTokenVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTokenVaultResponse> getTokenVault(Consumer<GetTokenVaultRequest.Builder> getTokenVaultRequest) {
        return getTokenVault(GetTokenVaultRequest.builder().applyMutation(getTokenVaultRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a workload identity.
     * </p>
     *
     * @param getWorkloadIdentityRequest
     * @return A Java Future containing the result of the GetWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetWorkloadIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadIdentityResponse> getWorkloadIdentity(
            GetWorkloadIdentityRequest getWorkloadIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param getWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.GetWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.GetWorkloadIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/GetWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkloadIdentityResponse> getWorkloadIdentity(
            Consumer<GetWorkloadIdentityRequest.Builder> getWorkloadIdentityRequest) {
        return getWorkloadIdentity(GetWorkloadIdentityRequest.builder().applyMutation(getWorkloadIdentityRequest).build());
    }

    /**
     * <p>
     * Lists all endpoints for a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     * @return A Java Future containing the result of the ListAgentRuntimeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentRuntimeEndpointsResponse> listAgentRuntimeEndpoints(
            ListAgentRuntimeEndpointsRequest listAgentRuntimeEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all endpoints for a specific Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeEndpointsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAgentRuntimeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentRuntimeEndpointsResponse> listAgentRuntimeEndpoints(
            Consumer<ListAgentRuntimeEndpointsRequest.Builder> listAgentRuntimeEndpointsRequest) {
        return listAgentRuntimeEndpoints(ListAgentRuntimeEndpointsRequest.builder()
                .applyMutation(listAgentRuntimeEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsPublisher publisher = client.listAgentRuntimeEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsPublisher publisher = client.listAgentRuntimeEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeEndpointsPublisher listAgentRuntimeEndpointsPaginator(
            ListAgentRuntimeEndpointsRequest listAgentRuntimeEndpointsRequest) {
        return new ListAgentRuntimeEndpointsPublisher(this, listAgentRuntimeEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsPublisher publisher = client.listAgentRuntimeEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeEndpointsPublisher publisher = client.listAgentRuntimeEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeEndpoints(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeEndpointsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeEndpoints
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeEndpointsPublisher listAgentRuntimeEndpointsPaginator(
            Consumer<ListAgentRuntimeEndpointsRequest.Builder> listAgentRuntimeEndpointsRequest) {
        return listAgentRuntimeEndpointsPaginator(ListAgentRuntimeEndpointsRequest.builder()
                .applyMutation(listAgentRuntimeEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists all versions of a specific Amazon Secure Agent.
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     * @return A Java Future containing the result of the ListAgentRuntimeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentRuntimeVersionsResponse> listAgentRuntimeVersions(
            ListAgentRuntimeVersionsRequest listAgentRuntimeVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all versions of a specific Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeVersionsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAgentRuntimeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentRuntimeVersionsResponse> listAgentRuntimeVersions(
            Consumer<ListAgentRuntimeVersionsRequest.Builder> listAgentRuntimeVersionsRequest) {
        return listAgentRuntimeVersions(ListAgentRuntimeVersionsRequest.builder().applyMutation(listAgentRuntimeVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsPublisher publisher = client.listAgentRuntimeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsPublisher publisher = client.listAgentRuntimeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeVersionsPublisher listAgentRuntimeVersionsPaginator(
            ListAgentRuntimeVersionsRequest listAgentRuntimeVersionsRequest) {
        return new ListAgentRuntimeVersionsPublisher(this, listAgentRuntimeVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsPublisher publisher = client.listAgentRuntimeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimeVersionsPublisher publisher = client.listAgentRuntimeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimeVersions(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimeVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAgentRuntimeVersionsRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimeVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeVersionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimeVersions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimeVersionsPublisher listAgentRuntimeVersionsPaginator(
            Consumer<ListAgentRuntimeVersionsRequest.Builder> listAgentRuntimeVersionsRequest) {
        return listAgentRuntimeVersionsPaginator(ListAgentRuntimeVersionsRequest.builder()
                .applyMutation(listAgentRuntimeVersionsRequest).build());
    }

    /**
     * <p>
     * Lists all Amazon Secure Agents in your account.
     * </p>
     *
     * @param listAgentRuntimesRequest
     * @return A Java Future containing the result of the ListAgentRuntimes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentRuntimesResponse> listAgentRuntimes(ListAgentRuntimesRequest listAgentRuntimesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Amazon Secure Agents in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentRuntimesRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAgentRuntimes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAgentRuntimesResponse> listAgentRuntimes(
            Consumer<ListAgentRuntimesRequest.Builder> listAgentRuntimesRequest) {
        return listAgentRuntimes(ListAgentRuntimesRequest.builder().applyMutation(listAgentRuntimesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesPublisher publisher = client.listAgentRuntimesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesPublisher publisher = client.listAgentRuntimesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAgentRuntimesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimesPublisher listAgentRuntimesPaginator(ListAgentRuntimesRequest listAgentRuntimesRequest) {
        return new ListAgentRuntimesPublisher(this, listAgentRuntimesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesPublisher publisher = client.listAgentRuntimesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListAgentRuntimesPublisher publisher = client.listAgentRuntimesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentRuntimes(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentRuntimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentRuntimesRequest#builder()}
     * </p>
     *
     * @param listAgentRuntimesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListAgentRuntimes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListAgentRuntimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAgentRuntimesPublisher listAgentRuntimesPaginator(
            Consumer<ListAgentRuntimesRequest.Builder> listAgentRuntimesRequest) {
        return listAgentRuntimesPaginator(ListAgentRuntimesRequest.builder().applyMutation(listAgentRuntimesRequest).build());
    }

    /**
     * <p>
     * Lists all API key credential providers in your account.
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     * @return A Java Future containing the result of the ListApiKeyCredentialProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApiKeyCredentialProvidersResponse> listApiKeyCredentialProviders(
            ListApiKeyCredentialProvidersRequest listApiKeyCredentialProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all API key credential providers in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeyCredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListApiKeyCredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListApiKeyCredentialProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApiKeyCredentialProvidersResponse> listApiKeyCredentialProviders(
            Consumer<ListApiKeyCredentialProvidersRequest.Builder> listApiKeyCredentialProvidersRequest) {
        return listApiKeyCredentialProviders(ListApiKeyCredentialProvidersRequest.builder()
                .applyMutation(listApiKeyCredentialProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersPublisher publisher = client.listApiKeyCredentialProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersPublisher publisher = client.listApiKeyCredentialProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApiKeyCredentialProvidersPublisher listApiKeyCredentialProvidersPaginator(
            ListApiKeyCredentialProvidersRequest listApiKeyCredentialProvidersRequest) {
        return new ListApiKeyCredentialProvidersPublisher(this, listApiKeyCredentialProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersPublisher publisher = client.listApiKeyCredentialProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListApiKeyCredentialProvidersPublisher publisher = client.listApiKeyCredentialProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApiKeyCredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeyCredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListApiKeyCredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listApiKeyCredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListApiKeyCredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListApiKeyCredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApiKeyCredentialProvidersPublisher listApiKeyCredentialProvidersPaginator(
            Consumer<ListApiKeyCredentialProvidersRequest.Builder> listApiKeyCredentialProvidersRequest) {
        return listApiKeyCredentialProvidersPaginator(ListApiKeyCredentialProvidersRequest.builder()
                .applyMutation(listApiKeyCredentialProvidersRequest).build());
    }

    /**
     * <p>
     * Lists all custom browsers in your account.
     * </p>
     *
     * @param listBrowsersRequest
     * @return A Java Future containing the result of the ListBrowsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBrowsersResponse> listBrowsers(ListBrowsersRequest listBrowsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom browsers in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListBrowsersRequest#builder()}
     * </p>
     *
     * @param listBrowsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListBrowsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBrowsersResponse> listBrowsers(Consumer<ListBrowsersRequest.Builder> listBrowsersRequest) {
        return listBrowsers(ListBrowsersRequest.builder().applyMutation(listBrowsersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersPublisher publisher = client.listBrowsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersPublisher publisher = client.listBrowsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBrowsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowsersPublisher listBrowsersPaginator(ListBrowsersRequest listBrowsersRequest) {
        return new ListBrowsersPublisher(this, listBrowsersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersPublisher publisher = client.listBrowsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListBrowsersPublisher publisher = client.listBrowsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowsers(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListBrowsersRequest#builder()}
     * </p>
     *
     * @param listBrowsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListBrowsersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListBrowsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListBrowsers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowsersPublisher listBrowsersPaginator(Consumer<ListBrowsersRequest.Builder> listBrowsersRequest) {
        return listBrowsersPaginator(ListBrowsersRequest.builder().applyMutation(listBrowsersRequest).build());
    }

    /**
     * <p>
     * Lists all custom code interpreters in your account.
     * </p>
     *
     * @param listCodeInterpretersRequest
     * @return A Java Future containing the result of the ListCodeInterpreters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCodeInterpretersResponse> listCodeInterpreters(
            ListCodeInterpretersRequest listCodeInterpretersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom code interpreters in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeInterpretersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeInterpretersRequest#builder()}
     * </p>
     *
     * @param listCodeInterpretersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListCodeInterpreters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCodeInterpretersResponse> listCodeInterpreters(
            Consumer<ListCodeInterpretersRequest.Builder> listCodeInterpretersRequest) {
        return listCodeInterpreters(ListCodeInterpretersRequest.builder().applyMutation(listCodeInterpretersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersPublisher publisher = client.listCodeInterpretersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersPublisher publisher = client.listCodeInterpretersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodeInterpretersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpretersPublisher listCodeInterpretersPaginator(ListCodeInterpretersRequest listCodeInterpretersRequest) {
        return new ListCodeInterpretersPublisher(this, listCodeInterpretersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersPublisher publisher = client.listCodeInterpretersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListCodeInterpretersPublisher publisher = client.listCodeInterpretersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeInterpreters(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeInterpretersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeInterpretersRequest#builder()}
     * </p>
     *
     * @param listCodeInterpretersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListCodeInterpreters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListCodeInterpreters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCodeInterpretersPublisher listCodeInterpretersPaginator(
            Consumer<ListCodeInterpretersRequest.Builder> listCodeInterpretersRequest) {
        return listCodeInterpretersPaginator(ListCodeInterpretersRequest.builder().applyMutation(listCodeInterpretersRequest)
                .build());
    }

    /**
     * <p>
     * Lists all targets for a specific Gateway.
     * </p>
     *
     * @param listGatewayTargetsRequest
     * @return A Java Future containing the result of the ListGatewayTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewayTargetsResponse> listGatewayTargets(ListGatewayTargetsRequest listGatewayTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all targets for a specific Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayTargetsRequest#builder()}
     * </p>
     *
     * @param listGatewayTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGatewayTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewayTargetsResponse> listGatewayTargets(
            Consumer<ListGatewayTargetsRequest.Builder> listGatewayTargetsRequest) {
        return listGatewayTargets(ListGatewayTargetsRequest.builder().applyMutation(listGatewayTargetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsPublisher publisher = client.listGatewayTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsPublisher publisher = client.listGatewayTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayTargetsPublisher listGatewayTargetsPaginator(ListGatewayTargetsRequest listGatewayTargetsRequest) {
        return new ListGatewayTargetsPublisher(this, listGatewayTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsPublisher publisher = client.listGatewayTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewayTargetsPublisher publisher = client.listGatewayTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayTargets(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGatewayTargetsRequest#builder()}
     * </p>
     *
     * @param listGatewayTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewayTargetsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGatewayTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGatewayTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayTargetsPublisher listGatewayTargetsPaginator(
            Consumer<ListGatewayTargetsRequest.Builder> listGatewayTargetsRequest) {
        return listGatewayTargetsPaginator(ListGatewayTargetsRequest.builder().applyMutation(listGatewayTargetsRequest).build());
    }

    /**
     * <p>
     * Lists all Gateways in the account.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Gateways in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) {
        return new ListGatewaysPublisher(this, listGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListGatewaysRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists the memory present.
     * </p>
     *
     * @param listMemoriesRequest
     * @return A Java Future containing the result of the ListMemories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMemoriesResponse> listMemories(ListMemoriesRequest listMemoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the memory present.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMemoriesRequest#builder()}
     * </p>
     *
     * @param listMemoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMemories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMemoriesResponse> listMemories(Consumer<ListMemoriesRequest.Builder> listMemoriesRequest) {
        return listMemories(ListMemoriesRequest.builder().applyMutation(listMemoriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesPublisher publisher = client.listMemoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesPublisher publisher = client.listMemoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMemoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoriesPublisher listMemoriesPaginator(ListMemoriesRequest listMemoriesRequest) {
        return new ListMemoriesPublisher(this, listMemoriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesPublisher publisher = client.listMemoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListMemoriesPublisher publisher = client.listMemoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemories(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemoriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMemoriesRequest#builder()}
     * </p>
     *
     * @param listMemoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListMemories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListMemories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMemoriesPublisher listMemoriesPaginator(Consumer<ListMemoriesRequest.Builder> listMemoriesRequest) {
        return listMemoriesPaginator(ListMemoriesRequest.builder().applyMutation(listMemoriesRequest).build());
    }

    /**
     * <p>
     * Lists all OAuth2 credential providers in your account.
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     * @return A Java Future containing the result of the ListOauth2CredentialProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOauth2CredentialProvidersResponse> listOauth2CredentialProviders(
            ListOauth2CredentialProvidersRequest listOauth2CredentialProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all OAuth2 credential providers in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOauth2CredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListOauth2CredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListOauth2CredentialProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOauth2CredentialProvidersResponse> listOauth2CredentialProviders(
            Consumer<ListOauth2CredentialProvidersRequest.Builder> listOauth2CredentialProvidersRequest) {
        return listOauth2CredentialProviders(ListOauth2CredentialProvidersRequest.builder()
                .applyMutation(listOauth2CredentialProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersPublisher publisher = client.listOauth2CredentialProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersPublisher publisher = client.listOauth2CredentialProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOauth2CredentialProvidersPublisher listOauth2CredentialProvidersPaginator(
            ListOauth2CredentialProvidersRequest listOauth2CredentialProvidersRequest) {
        return new ListOauth2CredentialProvidersPublisher(this, listOauth2CredentialProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersPublisher publisher = client.listOauth2CredentialProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListOauth2CredentialProvidersPublisher publisher = client.listOauth2CredentialProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOauth2CredentialProviders(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOauth2CredentialProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListOauth2CredentialProvidersRequest#builder()}
     * </p>
     *
     * @param listOauth2CredentialProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListOauth2CredentialProviders
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListOauth2CredentialProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOauth2CredentialProvidersPublisher listOauth2CredentialProvidersPaginator(
            Consumer<ListOauth2CredentialProvidersRequest.Builder> listOauth2CredentialProvidersRequest) {
        return listOauth2CredentialProvidersPaginator(ListOauth2CredentialProvidersRequest.builder()
                .applyMutation(listOauth2CredentialProvidersRequest).build());
    }

    /**
     * <p>
     * Lists all workload identities in your account.
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     * @return A Java Future containing the result of the ListWorkloadIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadIdentitiesResponse> listWorkloadIdentities(
            ListWorkloadIdentitiesRequest listWorkloadIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all workload identities in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadIdentitiesRequest#builder()}
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListWorkloadIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkloadIdentitiesResponse> listWorkloadIdentities(
            Consumer<ListWorkloadIdentitiesRequest.Builder> listWorkloadIdentitiesRequest) {
        return listWorkloadIdentities(ListWorkloadIdentitiesRequest.builder().applyMutation(listWorkloadIdentitiesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesPublisher publisher = client.listWorkloadIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesPublisher publisher = client.listWorkloadIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadIdentitiesPublisher listWorkloadIdentitiesPaginator(
            ListWorkloadIdentitiesRequest listWorkloadIdentitiesRequest) {
        return new ListWorkloadIdentitiesPublisher(this, listWorkloadIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesPublisher publisher = client.listWorkloadIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentcorecontrol.paginators.ListWorkloadIdentitiesPublisher publisher = client.listWorkloadIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadIdentities(software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkloadIdentitiesRequest#builder()}
     * </p>
     *
     * @param listWorkloadIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.ListWorkloadIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/ListWorkloadIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadIdentitiesPublisher listWorkloadIdentitiesPaginator(
            Consumer<ListWorkloadIdentitiesRequest.Builder> listWorkloadIdentitiesRequest) {
        return listWorkloadIdentitiesPaginator(ListWorkloadIdentitiesRequest.builder()
                .applyMutation(listWorkloadIdentitiesRequest).build());
    }

    /**
     * <p>
     * Sets the customer master key (CMK) for a token vault.
     * </p>
     *
     * @param setTokenVaultCmkRequest
     * @return A Java Future containing the result of the SetTokenVaultCMK operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ConcurrentModificationException Exception thrown when a resource is modified concurrently by multiple
     *         requests.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.SetTokenVaultCMK
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/SetTokenVaultCMK"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTokenVaultCmkResponse> setTokenVaultCMK(SetTokenVaultCmkRequest setTokenVaultCmkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the customer master key (CMK) for a token vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTokenVaultCmkRequest.Builder} avoiding the need
     * to create one manually via {@link SetTokenVaultCmkRequest#builder()}
     * </p>
     *
     * @param setTokenVaultCmkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.SetTokenVaultCmkRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SetTokenVaultCMK operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ConcurrentModificationException Exception thrown when a resource is modified concurrently by multiple
     *         requests.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.SetTokenVaultCMK
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/SetTokenVaultCMK"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTokenVaultCmkResponse> setTokenVaultCMK(
            Consumer<SetTokenVaultCmkRequest.Builder> setTokenVaultCmkRequest) {
        return setTokenVaultCMK(SetTokenVaultCmkRequest.builder().applyMutation(setTokenVaultCmkRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Secure Agent.
     * </p>
     *
     * @param updateAgentRuntimeRequest
     * @return A Java Future containing the result of the UpdateAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentRuntimeResponse> updateAgentRuntime(UpdateAgentRuntimeRequest updateAgentRuntimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Secure Agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentRuntimeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAgentRuntimeRequest#builder()}
     * </p>
     *
     * @param updateAgentRuntimeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAgentRuntime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateAgentRuntime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentRuntimeResponse> updateAgentRuntime(
            Consumer<UpdateAgentRuntimeRequest.Builder> updateAgentRuntimeRequest) {
        return updateAgentRuntime(UpdateAgentRuntimeRequest.builder().applyMutation(updateAgentRuntimeRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Secure AgentEndpoint.
     * </p>
     *
     * @param updateAgentRuntimeEndpointRequest
     * @return A Java Future containing the result of the UpdateAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentRuntimeEndpointResponse> updateAgentRuntimeEndpoint(
            UpdateAgentRuntimeEndpointRequest updateAgentRuntimeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Secure AgentEndpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgentRuntimeEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAgentRuntimeEndpointRequest#builder()}
     * </p>
     *
     * @param updateAgentRuntimeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateAgentRuntimeEndpointRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAgentRuntimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateAgentRuntimeEndpoint
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateAgentRuntimeEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAgentRuntimeEndpointResponse> updateAgentRuntimeEndpoint(
            Consumer<UpdateAgentRuntimeEndpointRequest.Builder> updateAgentRuntimeEndpointRequest) {
        return updateAgentRuntimeEndpoint(UpdateAgentRuntimeEndpointRequest.builder()
                .applyMutation(updateAgentRuntimeEndpointRequest).build());
    }

    /**
     * <p>
     * Updates an existing API key credential provider.
     * </p>
     *
     * @param updateApiKeyCredentialProviderRequest
     * @return A Java Future containing the result of the UpdateApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApiKeyCredentialProviderResponse> updateApiKeyCredentialProvider(
            UpdateApiKeyCredentialProviderRequest updateApiKeyCredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing API key credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiKeyCredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApiKeyCredentialProviderRequest#builder()}
     * </p>
     *
     * @param updateApiKeyCredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateApiKeyCredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateApiKeyCredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateApiKeyCredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateApiKeyCredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApiKeyCredentialProviderResponse> updateApiKeyCredentialProvider(
            Consumer<UpdateApiKeyCredentialProviderRequest.Builder> updateApiKeyCredentialProviderRequest) {
        return updateApiKeyCredentialProvider(UpdateApiKeyCredentialProviderRequest.builder()
                .applyMutation(updateApiKeyCredentialProviderRequest).build());
    }

    /**
     * <p>
     * Updates an existing Gateway.
     * </p>
     *
     * @param updateGatewayRequest
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest updateGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGatewayRequest#builder()}
     * </p>
     *
     * @param updateGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayResponse> updateGateway(Consumer<UpdateGatewayRequest.Builder> updateGatewayRequest) {
        return updateGateway(UpdateGatewayRequest.builder().applyMutation(updateGatewayRequest).build());
    }

    /**
     * <p>
     * Updates an existing Gateway Target.
     * </p>
     *
     * @param updateGatewayTargetRequest
     * @return A Java Future containing the result of the UpdateGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayTargetResponse> updateGatewayTarget(
            UpdateGatewayTargetRequest updateGatewayTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Gateway Target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayTargetRequest#builder()}
     * </p>
     *
     * @param updateGatewayTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateGatewayTargetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateGatewayTarget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateGatewayTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateGatewayTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayTargetResponse> updateGatewayTarget(
            Consumer<UpdateGatewayTargetRequest.Builder> updateGatewayTargetRequest) {
        return updateGatewayTarget(UpdateGatewayTargetRequest.builder().applyMutation(updateGatewayTargetRequest).build());
    }

    /**
     * <p>
     * Update memory.
     * </p>
     *
     * @param updateMemoryRequest
     * @return A Java Future containing the result of the UpdateMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMemoryResponse> updateMemory(UpdateMemoryRequest updateMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update memory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMemoryRequest#builder()}
     * </p>
     *
     * @param updateMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateMemoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException An internal error occurred.</li>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottledException API rate limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMemoryResponse> updateMemory(Consumer<UpdateMemoryRequest.Builder> updateMemoryRequest) {
        return updateMemory(UpdateMemoryRequest.builder().applyMutation(updateMemoryRequest).build());
    }

    /**
     * <p>
     * Updates an existing OAuth2 credential provider.
     * </p>
     *
     * @param updateOauth2CredentialProviderRequest
     * @return A Java Future containing the result of the UpdateOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOauth2CredentialProviderResponse> updateOauth2CredentialProvider(
            UpdateOauth2CredentialProviderRequest updateOauth2CredentialProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing OAuth2 credential provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOauth2CredentialProviderRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOauth2CredentialProviderRequest#builder()}
     * </p>
     *
     * @param updateOauth2CredentialProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateOauth2CredentialProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateOauth2CredentialProvider operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException This exception is thrown when a request is made beyond the service
     *         quota</li>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ConflictException This exception is thrown when there is a conflict performing an operation</li>
     *         <li>DecryptionFailureException Exception thrown when decryption of a secret fails.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>EncryptionFailureException Exception thrown when encryption of a secret fails.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateOauth2CredentialProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateOauth2CredentialProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOauth2CredentialProviderResponse> updateOauth2CredentialProvider(
            Consumer<UpdateOauth2CredentialProviderRequest.Builder> updateOauth2CredentialProviderRequest) {
        return updateOauth2CredentialProvider(UpdateOauth2CredentialProviderRequest.builder()
                .applyMutation(updateOauth2CredentialProviderRequest).build());
    }

    /**
     * <p>
     * Updates an existing workload identity.
     * </p>
     *
     * @param updateWorkloadIdentityRequest
     * @return A Java Future containing the result of the UpdateWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadIdentityResponse> updateWorkloadIdentity(
            UpdateWorkloadIdentityRequest updateWorkloadIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing workload identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkloadIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkloadIdentityRequest#builder()}
     * </p>
     *
     * @param updateWorkloadIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.UpdateWorkloadIdentityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateWorkloadIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException This exception is thrown when the JWT bearer token is invalid or not found for
     *         OAuth bearer token based access</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by the service.</li>
     *         <li>AccessDeniedException This exception is thrown when a request is denied per access permissions</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource referenced by the operation does
     *         not exist</li>
     *         <li>ThrottlingException This exception is thrown when the number of requests exceeds the limit</li>
     *         <li>InternalServerException This exception is thrown if there was an unexpected error during processing
     *         of request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentCoreControlException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentCoreControlAsyncClient.UpdateWorkloadIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-control-2023-06-05/UpdateWorkloadIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkloadIdentityResponse> updateWorkloadIdentity(
            Consumer<UpdateWorkloadIdentityRequest.Builder> updateWorkloadIdentityRequest) {
        return updateWorkloadIdentity(UpdateWorkloadIdentityRequest.builder().applyMutation(updateWorkloadIdentityRequest)
                .build());
    }

    /**
     * Create an instance of {@link BedrockAgentCoreControlAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link BedrockAgentCoreControlAsyncWaiter}
     */
    default BedrockAgentCoreControlAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default BedrockAgentCoreControlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentCoreControlAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentCoreControlAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentCoreControlAsyncClient}.
     */
    static BedrockAgentCoreControlAsyncClientBuilder builder() {
        return new DefaultBedrockAgentCoreControlAsyncClientBuilder();
    }
}
