/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMemoryRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<UpdateMemoryRequest.Builder, UpdateMemoryRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateMemoryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryId").getter(getter(UpdateMemoryRequest::memoryId)).setter(setter(Builder::memoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateMemoryRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> EVENT_EXPIRY_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("eventExpiryDuration").getter(getter(UpdateMemoryRequest::eventExpiryDuration))
            .setter(setter(Builder::eventExpiryDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventExpiryDuration").build())
            .build();

    private static final SdkField<String> MEMORY_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryExecutionRoleArn").getter(getter(UpdateMemoryRequest::memoryExecutionRoleArn))
            .setter(setter(Builder::memoryExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryExecutionRoleArn").build())
            .build();

    private static final SdkField<ModifyMemoryStrategies> MEMORY_STRATEGIES_FIELD = SdkField
            .<ModifyMemoryStrategies> builder(MarshallingType.SDK_POJO).memberName("memoryStrategies")
            .getter(getter(UpdateMemoryRequest::memoryStrategies)).setter(setter(Builder::memoryStrategies))
            .constructor(ModifyMemoryStrategies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategies").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            MEMORY_ID_FIELD, DESCRIPTION_FIELD, EVENT_EXPIRY_DURATION_FIELD, MEMORY_EXECUTION_ROLE_ARN_FIELD,
            MEMORY_STRATEGIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String memoryId;

    private final String description;

    private final Integer eventExpiryDuration;

    private final String memoryExecutionRoleArn;

    private final ModifyMemoryStrategies memoryStrategies;

    private UpdateMemoryRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.memoryId = builder.memoryId;
        this.description = builder.description;
        this.eventExpiryDuration = builder.eventExpiryDuration;
        this.memoryExecutionRoleArn = builder.memoryExecutionRoleArn;
        this.memoryStrategies = builder.memoryStrategies;
    }

    /**
     * <p>
     * A client token is used for keeping track of idempotent requests. It can contain a session id which can be around
     * 250 chars, combined with a unique AWS identifier.
     * </p>
     * 
     * @return A client token is used for keeping track of idempotent requests. It can contain a session id which can be
     *         around 250 chars, combined with a unique AWS identifier.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the memory to update.
     * </p>
     * 
     * @return The unique identifier of the memory to update.
     */
    public final String memoryId() {
        return memoryId;
    }

    /**
     * <p>
     * The updated description of the memory.
     * </p>
     * 
     * @return The updated description of the memory.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of days after which memory events will expire, between 7 and 365 days.
     * </p>
     * 
     * @return The number of days after which memory events will expire, between 7 and 365 days.
     */
    public final Integer eventExpiryDuration() {
        return eventExpiryDuration;
    }

    /**
     * <p>
     * The ARN of the IAM role that provides permissions for the memory.
     * </p>
     * 
     * @return The ARN of the IAM role that provides permissions for the memory.
     */
    public final String memoryExecutionRoleArn() {
        return memoryExecutionRoleArn;
    }

    /**
     * <p>
     * The memory strategies to add, modify, or delete.
     * </p>
     * 
     * @return The memory strategies to add, modify, or delete.
     */
    public final ModifyMemoryStrategies memoryStrategies() {
        return memoryStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventExpiryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(memoryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(memoryStrategies());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMemoryRequest)) {
            return false;
        }
        UpdateMemoryRequest other = (UpdateMemoryRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(memoryId(), other.memoryId())
                && Objects.equals(description(), other.description())
                && Objects.equals(eventExpiryDuration(), other.eventExpiryDuration())
                && Objects.equals(memoryExecutionRoleArn(), other.memoryExecutionRoleArn())
                && Objects.equals(memoryStrategies(), other.memoryStrategies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMemoryRequest").add("ClientToken", clientToken()).add("MemoryId", memoryId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EventExpiryDuration", eventExpiryDuration()).add("MemoryExecutionRoleArn", memoryExecutionRoleArn())
                .add("MemoryStrategies", memoryStrategies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "memoryId":
            return Optional.ofNullable(clazz.cast(memoryId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "eventExpiryDuration":
            return Optional.ofNullable(clazz.cast(eventExpiryDuration()));
        case "memoryExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(memoryExecutionRoleArn()));
        case "memoryStrategies":
            return Optional.ofNullable(clazz.cast(memoryStrategies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("eventExpiryDuration", EVENT_EXPIRY_DURATION_FIELD);
        map.put("memoryExecutionRoleArn", MEMORY_EXECUTION_ROLE_ARN_FIELD);
        map.put("memoryStrategies", MEMORY_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMemoryRequest, T> g) {
        return obj -> g.apply((UpdateMemoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMemoryRequest> {
        /**
         * <p>
         * A client token is used for keeping track of idempotent requests. It can contain a session id which can be
         * around 250 chars, combined with a unique AWS identifier.
         * </p>
         * 
         * @param clientToken
         *        A client token is used for keeping track of idempotent requests. It can contain a session id which can
         *        be around 250 chars, combined with a unique AWS identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the memory to update.
         * </p>
         * 
         * @param memoryId
         *        The unique identifier of the memory to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryId(String memoryId);

        /**
         * <p>
         * The updated description of the memory.
         * </p>
         * 
         * @param description
         *        The updated description of the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of days after which memory events will expire, between 7 and 365 days.
         * </p>
         * 
         * @param eventExpiryDuration
         *        The number of days after which memory events will expire, between 7 and 365 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventExpiryDuration(Integer eventExpiryDuration);

        /**
         * <p>
         * The ARN of the IAM role that provides permissions for the memory.
         * </p>
         * 
         * @param memoryExecutionRoleArn
         *        The ARN of the IAM role that provides permissions for the memory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryExecutionRoleArn(String memoryExecutionRoleArn);

        /**
         * <p>
         * The memory strategies to add, modify, or delete.
         * </p>
         * 
         * @param memoryStrategies
         *        The memory strategies to add, modify, or delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStrategies(ModifyMemoryStrategies memoryStrategies);

        /**
         * <p>
         * The memory strategies to add, modify, or delete.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModifyMemoryStrategies.Builder} avoiding
         * the need to create one manually via {@link ModifyMemoryStrategies#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModifyMemoryStrategies.Builder#build()} is called immediately and
         * its result is passed to {@link #memoryStrategies(ModifyMemoryStrategies)}.
         * 
         * @param memoryStrategies
         *        a consumer that will call methods on {@link ModifyMemoryStrategies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryStrategies(ModifyMemoryStrategies)
         */
        default Builder memoryStrategies(Consumer<ModifyMemoryStrategies.Builder> memoryStrategies) {
            return memoryStrategies(ModifyMemoryStrategies.builder().applyMutation(memoryStrategies).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String memoryId;

        private String description;

        private Integer eventExpiryDuration;

        private String memoryExecutionRoleArn;

        private ModifyMemoryStrategies memoryStrategies;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMemoryRequest model) {
            super(model);
            clientToken(model.clientToken);
            memoryId(model.memoryId);
            description(model.description);
            eventExpiryDuration(model.eventExpiryDuration);
            memoryExecutionRoleArn(model.memoryExecutionRoleArn);
            memoryStrategies(model.memoryStrategies);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMemoryId() {
            return memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getEventExpiryDuration() {
            return eventExpiryDuration;
        }

        public final void setEventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
        }

        @Override
        public final Builder eventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
            return this;
        }

        public final String getMemoryExecutionRoleArn() {
            return memoryExecutionRoleArn;
        }

        public final void setMemoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
        }

        @Override
        public final Builder memoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
            return this;
        }

        public final ModifyMemoryStrategies.Builder getMemoryStrategies() {
            return memoryStrategies != null ? memoryStrategies.toBuilder() : null;
        }

        public final void setMemoryStrategies(ModifyMemoryStrategies.BuilderImpl memoryStrategies) {
            this.memoryStrategies = memoryStrategies != null ? memoryStrategies.build() : null;
        }

        @Override
        public final Builder memoryStrategies(ModifyMemoryStrategies memoryStrategies) {
            this.memoryStrategies = memoryStrategies;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMemoryRequest build() {
            return new UpdateMemoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
