/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCodeInterpreterResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetCodeInterpreterResponse.Builder, GetCodeInterpreterResponse> {
    private static final SdkField<String> CODE_INTERPRETER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterId").getter(getter(GetCodeInterpreterResponse::codeInterpreterId))
            .setter(setter(Builder::codeInterpreterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterId").build()).build();

    private static final SdkField<String> CODE_INTERPRETER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterArn").getter(getter(GetCodeInterpreterResponse::codeInterpreterArn))
            .setter(setter(Builder::codeInterpreterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCodeInterpreterResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCodeInterpreterResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(GetCodeInterpreterResponse::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<CodeInterpreterNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<CodeInterpreterNetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(GetCodeInterpreterResponse::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(CodeInterpreterNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCodeInterpreterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetCodeInterpreterResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetCodeInterpreterResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_INTERPRETER_ID_FIELD,
            CODE_INTERPRETER_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD,
            STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String codeInterpreterId;

    private final String codeInterpreterArn;

    private final String name;

    private final String description;

    private final String executionRoleArn;

    private final CodeInterpreterNetworkConfiguration networkConfiguration;

    private final String status;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private GetCodeInterpreterResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterId = builder.codeInterpreterId;
        this.codeInterpreterArn = builder.codeInterpreterArn;
        this.name = builder.name;
        this.description = builder.description;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The unique identifier of the code interpreter.
     * </p>
     * 
     * @return The unique identifier of the code interpreter.
     */
    public final String codeInterpreterId() {
        return codeInterpreterId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the code interpreter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the code interpreter.
     */
    public final String codeInterpreterArn() {
        return codeInterpreterArn;
    }

    /**
     * <p>
     * The name of the code interpreter.
     * </p>
     * 
     * @return The name of the code interpreter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the code interpreter.
     * </p>
     * 
     * @return The description of the code interpreter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IAM role ARN that provides permissions for the code interpreter.
     * </p>
     * 
     * @return The IAM role ARN that provides permissions for the code interpreter.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * Returns the value of the NetworkConfiguration property for this object.
     * 
     * @return The value of the NetworkConfiguration property for this object.
     */
    public final CodeInterpreterNetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The current status of the code interpreter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeInterpreterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code interpreter.
     * @see CodeInterpreterStatus
     */
    public final CodeInterpreterStatus status() {
        return CodeInterpreterStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the code interpreter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeInterpreterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code interpreter.
     * @see CodeInterpreterStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the code interpreter was created.
     * </p>
     * 
     * @return The timestamp when the code interpreter was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the code interpreter was last updated.
     * </p>
     * 
     * @return The timestamp when the code interpreter was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterId());
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCodeInterpreterResponse)) {
            return false;
        }
        GetCodeInterpreterResponse other = (GetCodeInterpreterResponse) obj;
        return Objects.equals(codeInterpreterId(), other.codeInterpreterId())
                && Objects.equals(codeInterpreterArn(), other.codeInterpreterArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCodeInterpreterResponse").add("CodeInterpreterId", codeInterpreterId())
                .add("CodeInterpreterArn", codeInterpreterArn()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExecutionRoleArn", executionRoleArn()).add("NetworkConfiguration", networkConfiguration())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeInterpreterId":
            return Optional.ofNullable(clazz.cast(codeInterpreterId()));
        case "codeInterpreterArn":
            return Optional.ofNullable(clazz.cast(codeInterpreterArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeInterpreterId", CODE_INTERPRETER_ID_FIELD);
        map.put("codeInterpreterArn", CODE_INTERPRETER_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCodeInterpreterResponse, T> g) {
        return obj -> g.apply((GetCodeInterpreterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCodeInterpreterResponse> {
        /**
         * <p>
         * The unique identifier of the code interpreter.
         * </p>
         * 
         * @param codeInterpreterId
         *        The unique identifier of the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterId(String codeInterpreterId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the code interpreter.
         * </p>
         * 
         * @param codeInterpreterArn
         *        The Amazon Resource Name (ARN) of the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterArn(String codeInterpreterArn);

        /**
         * <p>
         * The name of the code interpreter.
         * </p>
         * 
         * @param name
         *        The name of the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the code interpreter.
         * </p>
         * 
         * @param description
         *        The description of the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IAM role ARN that provides permissions for the code interpreter.
         * </p>
         * 
         * @param executionRoleArn
         *        The IAM role ARN that provides permissions for the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * @param networkConfiguration
         *        The new value for the NetworkConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(CodeInterpreterNetworkConfiguration networkConfiguration);

        /**
         * Sets the value of the NetworkConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CodeInterpreterNetworkConfiguration.Builder} avoiding the need to create one manually via
         * {@link CodeInterpreterNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeInterpreterNetworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #networkConfiguration(CodeInterpreterNetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link CodeInterpreterNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(CodeInterpreterNetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<CodeInterpreterNetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(CodeInterpreterNetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The current status of the code interpreter.
         * </p>
         * 
         * @param status
         *        The current status of the code interpreter.
         * @see CodeInterpreterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeInterpreterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the code interpreter.
         * </p>
         * 
         * @param status
         *        The current status of the code interpreter.
         * @see CodeInterpreterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeInterpreterStatus
         */
        Builder status(CodeInterpreterStatus status);

        /**
         * <p>
         * The timestamp when the code interpreter was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the code interpreter was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the code interpreter was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the code interpreter was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String codeInterpreterId;

        private String codeInterpreterArn;

        private String name;

        private String description;

        private String executionRoleArn;

        private CodeInterpreterNetworkConfiguration networkConfiguration;

        private String status;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCodeInterpreterResponse model) {
            super(model);
            codeInterpreterId(model.codeInterpreterId);
            codeInterpreterArn(model.codeInterpreterArn);
            name(model.name);
            description(model.description);
            executionRoleArn(model.executionRoleArn);
            networkConfiguration(model.networkConfiguration);
            status(model.status);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getCodeInterpreterId() {
            return codeInterpreterId;
        }

        public final void setCodeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
        }

        @Override
        public final Builder codeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
            return this;
        }

        public final String getCodeInterpreterArn() {
            return codeInterpreterArn;
        }

        public final void setCodeInterpreterArn(String codeInterpreterArn) {
            this.codeInterpreterArn = codeInterpreterArn;
        }

        @Override
        public final Builder codeInterpreterArn(String codeInterpreterArn) {
            this.codeInterpreterArn = codeInterpreterArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final CodeInterpreterNetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(CodeInterpreterNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(CodeInterpreterNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeInterpreterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetCodeInterpreterResponse build() {
            return new GetCodeInterpreterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
