/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an agent runtime endpoint. An endpoint provides a way to connect to and interact with an
 * agent runtime.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<AgentEndpoint.Builder, AgentEndpoint> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AgentEndpoint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LIVE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("liveVersion").getter(getter(AgentEndpoint::liveVersion)).setter(setter(Builder::liveVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("liveVersion").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetVersion").getter(getter(AgentEndpoint::targetVersion)).setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeEndpointArn").getter(getter(AgentEndpoint::agentRuntimeEndpointArn))
            .setter(setter(Builder::agentRuntimeEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeEndpointArn").build())
            .build();

    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeArn").getter(getter(AgentEndpoint::agentRuntimeArn))
            .setter(setter(Builder::agentRuntimeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AgentEndpoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AgentEndpoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentEndpoint::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentEndpoint::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(AgentEndpoint::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            LIVE_VERSION_FIELD, TARGET_VERSION_FIELD, AGENT_RUNTIME_ENDPOINT_ARN_FIELD, AGENT_RUNTIME_ARN_FIELD, STATUS_FIELD,
            ID_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String liveVersion;

    private final String targetVersion;

    private final String agentRuntimeEndpointArn;

    private final String agentRuntimeArn;

    private final String status;

    private final String id;

    private final String description;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private AgentEndpoint(BuilderImpl builder) {
        this.name = builder.name;
        this.liveVersion = builder.liveVersion;
        this.targetVersion = builder.targetVersion;
        this.agentRuntimeEndpointArn = builder.agentRuntimeEndpointArn;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.status = builder.status;
        this.id = builder.id;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the agent runtime endpoint.
     * </p>
     * 
     * @return The name of the agent runtime endpoint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The live version of the agent runtime endpoint. This is the version that is currently serving requests.
     * </p>
     * 
     * @return The live version of the agent runtime endpoint. This is the version that is currently serving requests.
     */
    public final String liveVersion() {
        return liveVersion;
    }

    /**
     * <p>
     * The target version of the agent runtime endpoint. This is the version that the endpoint is being updated to.
     * </p>
     * 
     * @return The target version of the agent runtime endpoint. This is the version that the endpoint is being updated
     *         to.
     */
    public final String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime endpoint.
     */
    public final String agentRuntimeEndpointArn() {
        return agentRuntimeEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime associated with the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime associated with the endpoint.
     */
    public final String agentRuntimeArn() {
        return agentRuntimeArn;
    }

    /**
     * <p>
     * The current status of the agent runtime endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime endpoint.
     * @see AgentEndpointStatus
     */
    public final AgentEndpointStatus status() {
        return AgentEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the agent runtime endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime endpoint.
     * @see AgentEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The unique identifier of the agent runtime endpoint.
     * </p>
     * 
     * @return The unique identifier of the agent runtime endpoint.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The description of the agent runtime endpoint.
     * </p>
     * 
     * @return The description of the agent runtime endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the agent runtime endpoint was created.
     * </p>
     * 
     * @return The timestamp when the agent runtime endpoint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the agent runtime endpoint was last updated.
     * </p>
     * 
     * @return The timestamp when the agent runtime endpoint was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(liveVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentEndpoint)) {
            return false;
        }
        AgentEndpoint other = (AgentEndpoint) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(liveVersion(), other.liveVersion())
                && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(agentRuntimeEndpointArn(), other.agentRuntimeEndpointArn())
                && Objects.equals(agentRuntimeArn(), other.agentRuntimeArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentEndpoint").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LiveVersion", liveVersion()).add("TargetVersion", targetVersion())
                .add("AgentRuntimeEndpointArn", agentRuntimeEndpointArn()).add("AgentRuntimeArn", agentRuntimeArn())
                .add("Status", statusAsString()).add("Id", id()).add("Description", description()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "liveVersion":
            return Optional.ofNullable(clazz.cast(liveVersion()));
        case "targetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "agentRuntimeEndpointArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeEndpointArn()));
        case "agentRuntimeArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("liveVersion", LIVE_VERSION_FIELD);
        map.put("targetVersion", TARGET_VERSION_FIELD);
        map.put("agentRuntimeEndpointArn", AGENT_RUNTIME_ENDPOINT_ARN_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("id", ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentEndpoint, T> g) {
        return obj -> g.apply((AgentEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentEndpoint> {
        /**
         * <p>
         * The name of the agent runtime endpoint.
         * </p>
         * 
         * @param name
         *        The name of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The live version of the agent runtime endpoint. This is the version that is currently serving requests.
         * </p>
         * 
         * @param liveVersion
         *        The live version of the agent runtime endpoint. This is the version that is currently serving
         *        requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveVersion(String liveVersion);

        /**
         * <p>
         * The target version of the agent runtime endpoint. This is the version that the endpoint is being updated to.
         * </p>
         * 
         * @param targetVersion
         *        The target version of the agent runtime endpoint. This is the version that the endpoint is being
         *        updated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime endpoint.
         * </p>
         * 
         * @param agentRuntimeEndpointArn
         *        The Amazon Resource Name (ARN) of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime associated with the endpoint.
         * </p>
         * 
         * @param agentRuntimeArn
         *        The Amazon Resource Name (ARN) of the agent runtime associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArn(String agentRuntimeArn);

        /**
         * <p>
         * The current status of the agent runtime endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime endpoint.
         * @see AgentEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the agent runtime endpoint.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime endpoint.
         * @see AgentEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentEndpointStatus
         */
        Builder status(AgentEndpointStatus status);

        /**
         * <p>
         * The unique identifier of the agent runtime endpoint.
         * </p>
         * 
         * @param id
         *        The unique identifier of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description of the agent runtime endpoint.
         * </p>
         * 
         * @param description
         *        The description of the agent runtime endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the agent runtime endpoint was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the agent runtime endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the agent runtime endpoint was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the agent runtime endpoint was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String liveVersion;

        private String targetVersion;

        private String agentRuntimeEndpointArn;

        private String agentRuntimeArn;

        private String status;

        private String id;

        private String description;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentEndpoint model) {
            name(model.name);
            liveVersion(model.liveVersion);
            targetVersion(model.targetVersion);
            agentRuntimeEndpointArn(model.agentRuntimeEndpointArn);
            agentRuntimeArn(model.agentRuntimeArn);
            status(model.status);
            id(model.id);
            description(model.description);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLiveVersion() {
            return liveVersion;
        }

        public final void setLiveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
        }

        @Override
        public final Builder liveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
            return this;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final String getAgentRuntimeEndpointArn() {
            return agentRuntimeEndpointArn;
        }

        public final void setAgentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
        }

        @Override
        public final Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public AgentEndpoint build() {
            return new AgentEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
