/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains semantic consolidation override configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemanticConsolidationOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<SemanticConsolidationOverride.Builder, SemanticConsolidationOverride> {
    private static final SdkField<String> APPEND_TO_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appendToPrompt").getter(getter(SemanticConsolidationOverride::appendToPrompt))
            .setter(setter(Builder::appendToPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appendToPrompt").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(SemanticConsolidationOverride::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPEND_TO_PROMPT_FIELD,
            MODEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appendToPrompt;

    private final String modelId;

    private SemanticConsolidationOverride(BuilderImpl builder) {
        this.appendToPrompt = builder.appendToPrompt;
        this.modelId = builder.modelId;
    }

    /**
     * <p>
     * The text to append to the prompt for semantic consolidation.
     * </p>
     * 
     * @return The text to append to the prompt for semantic consolidation.
     */
    public final String appendToPrompt() {
        return appendToPrompt;
    }

    /**
     * <p>
     * The model ID to use for semantic consolidation.
     * </p>
     * 
     * @return The model ID to use for semantic consolidation.
     */
    public final String modelId() {
        return modelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appendToPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticConsolidationOverride)) {
            return false;
        }
        SemanticConsolidationOverride other = (SemanticConsolidationOverride) obj;
        return Objects.equals(appendToPrompt(), other.appendToPrompt()) && Objects.equals(modelId(), other.modelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemanticConsolidationOverride")
                .add("AppendToPrompt", appendToPrompt() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelId", modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appendToPrompt":
            return Optional.ofNullable(clazz.cast(appendToPrompt()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appendToPrompt", APPEND_TO_PROMPT_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticConsolidationOverride, T> g) {
        return obj -> g.apply((SemanticConsolidationOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemanticConsolidationOverride> {
        /**
         * <p>
         * The text to append to the prompt for semantic consolidation.
         * </p>
         * 
         * @param appendToPrompt
         *        The text to append to the prompt for semantic consolidation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appendToPrompt(String appendToPrompt);

        /**
         * <p>
         * The model ID to use for semantic consolidation.
         * </p>
         * 
         * @param modelId
         *        The model ID to use for semantic consolidation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);
    }

    static final class BuilderImpl implements Builder {
        private String appendToPrompt;

        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticConsolidationOverride model) {
            appendToPrompt(model.appendToPrompt);
            modelId(model.modelId);
        }

        public final String getAppendToPrompt() {
            return appendToPrompt;
        }

        public final void setAppendToPrompt(String appendToPrompt) {
            this.appendToPrompt = appendToPrompt;
        }

        @Override
        public final Builder appendToPrompt(String appendToPrompt) {
            this.appendToPrompt = appendToPrompt;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public SemanticConsolidationOverride build() {
            return new SemanticConsolidationOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
