/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGatewayResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<GetGatewayResponse.Builder, GetGatewayResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayArn").getter(getter(GetGatewayResponse::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(GetGatewayResponse::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> GATEWAY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayUrl").getter(getter(GetGatewayResponse::gatewayUrl)).setter(setter(Builder::gatewayUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayUrl").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetGatewayResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetGatewayResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetGatewayResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusReasons")
            .getter(getter(GetGatewayResponse::statusReasons))
            .setter(setter(Builder::statusReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetGatewayResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetGatewayResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetGatewayResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolType").getter(getter(GetGatewayResponse::protocolTypeAsString))
            .setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()).build();

    private static final SdkField<GatewayProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField
            .<GatewayProtocolConfiguration> builder(MarshallingType.SDK_POJO).memberName("protocolConfiguration")
            .getter(getter(GetGatewayResponse::protocolConfiguration)).setter(setter(Builder::protocolConfiguration))
            .constructor(GatewayProtocolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build())
            .build();

    private static final SdkField<String> AUTHORIZER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerType").getter(getter(GetGatewayResponse::authorizerTypeAsString))
            .setter(setter(Builder::authorizerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerType").build()).build();

    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField
            .<AuthorizerConfiguration> builder(MarshallingType.SDK_POJO).memberName("authorizerConfiguration")
            .getter(getter(GetGatewayResponse::authorizerConfiguration)).setter(setter(Builder::authorizerConfiguration))
            .constructor(AuthorizerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(GetGatewayResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<WorkloadIdentityDetails> WORKLOAD_IDENTITY_DETAILS_FIELD = SdkField
            .<WorkloadIdentityDetails> builder(MarshallingType.SDK_POJO).memberName("workloadIdentityDetails")
            .getter(getter(GetGatewayResponse::workloadIdentityDetails)).setter(setter(Builder::workloadIdentityDetails))
            .constructor(WorkloadIdentityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityDetails").build())
            .build();

    private static final SdkField<String> EXCEPTION_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exceptionLevel").getter(getter(GetGatewayResponse::exceptionLevelAsString))
            .setter(setter(Builder::exceptionLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            GATEWAY_ID_FIELD, GATEWAY_URL_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, STATUS_REASONS_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, PROTOCOL_TYPE_FIELD, PROTOCOL_CONFIGURATION_FIELD,
            AUTHORIZER_TYPE_FIELD, AUTHORIZER_CONFIGURATION_FIELD, KMS_KEY_ARN_FIELD, WORKLOAD_IDENTITY_DETAILS_FIELD,
            EXCEPTION_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayArn;

    private final String gatewayId;

    private final String gatewayUrl;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private final List<String> statusReasons;

    private final String name;

    private final String description;

    private final String roleArn;

    private final String protocolType;

    private final GatewayProtocolConfiguration protocolConfiguration;

    private final String authorizerType;

    private final AuthorizerConfiguration authorizerConfiguration;

    private final String kmsKeyArn;

    private final WorkloadIdentityDetails workloadIdentityDetails;

    private final String exceptionLevel;

    private GetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayArn = builder.gatewayArn;
        this.gatewayId = builder.gatewayId;
        this.gatewayUrl = builder.gatewayUrl;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
        this.name = builder.name;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.protocolType = builder.protocolType;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.authorizerType = builder.authorizerType;
        this.authorizerConfiguration = builder.authorizerConfiguration;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.workloadIdentityDetails = builder.workloadIdentityDetails;
        this.exceptionLevel = builder.exceptionLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Gateway.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * <p>
     * The unique identifier of the Gateway.
     * </p>
     * 
     * @return The unique identifier of the Gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * An endpoint for invoking Gateway.
     * </p>
     * 
     * @return An endpoint for invoking Gateway.
     */
    public final String gatewayUrl() {
        return gatewayUrl;
    }

    /**
     * <p>
     * The timestamp when the Gateway was created.
     * </p>
     * 
     * @return The timestamp when the Gateway was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the Gateway was last updated.
     * </p>
     * 
     * @return The timestamp when the Gateway was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GatewayStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Gateway.
     * @see GatewayStatus
     */
    public final GatewayStatus status() {
        return GatewayStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GatewayStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Gateway.
     * @see GatewayStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusReasons() {
        return statusReasons != null && !(statusReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons for the current status of the Gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusReasons} method.
     * </p>
     * 
     * @return The reasons for the current status of the Gateway.
     */
    public final List<String> statusReasons() {
        return statusReasons;
    }

    /**
     * <p>
     * The name of the Gateway.
     * </p>
     * 
     * @return The name of the Gateway.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the Gateway.
     * </p>
     * 
     * @return The description of the Gateway.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IAM role ARN that provides permissions for the Gateway.
     * </p>
     * 
     * @return The IAM role ARN that provides permissions for the Gateway.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Protocol applied to a Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link GatewayProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return Protocol applied to a Gateway.
     * @see GatewayProtocolType
     */
    public final GatewayProtocolType protocolType() {
        return GatewayProtocolType.fromValue(protocolType);
    }

    /**
     * <p>
     * Protocol applied to a Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link GatewayProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return Protocol applied to a Gateway.
     * @see GatewayProtocolType
     */
    public final String protocolTypeAsString() {
        return protocolType;
    }

    /**
     * Returns the value of the ProtocolConfiguration property for this object.
     * 
     * @return The value of the ProtocolConfiguration property for this object.
     */
    public final GatewayProtocolConfiguration protocolConfiguration() {
        return protocolConfiguration;
    }

    /**
     * <p>
     * Authorizer type for the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return Authorizer type for the gateway.
     * @see AuthorizerType
     */
    public final AuthorizerType authorizerType() {
        return AuthorizerType.fromValue(authorizerType);
    }

    /**
     * <p>
     * Authorizer type for the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return Authorizer type for the gateway.
     * @see AuthorizerType
     */
    public final String authorizerTypeAsString() {
        return authorizerType;
    }

    /**
     * <p>
     * The authorizer configuration for the Gateway.
     * </p>
     * 
     * @return The authorizer configuration for the Gateway.
     */
    public final AuthorizerConfiguration authorizerConfiguration() {
        return authorizerConfiguration;
    }

    /**
     * <p>
     * The ARN of the KMS key used to encrypt the Gateway.
     * </p>
     * 
     * @return The ARN of the KMS key used to encrypt the Gateway.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The workload identity details for the Gateway.
     * </p>
     * 
     * @return The workload identity details for the Gateway.
     */
    public final WorkloadIdentityDetails workloadIdentityDetails() {
        return workloadIdentityDetails;
    }

    /**
     * <p>
     * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If this
     * parameter is not set, exception messages are by default sanitized for presentation to end users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exceptionLevel}
     * will return {@link ExceptionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exceptionLevelAsString}.
     * </p>
     * 
     * @return The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
     *         this parameter is not set, exception messages are by default sanitized for presentation to end users.
     * @see ExceptionLevel
     */
    public final ExceptionLevel exceptionLevel() {
        return ExceptionLevel.fromValue(exceptionLevel);
    }

    /**
     * <p>
     * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If this
     * parameter is not set, exception messages are by default sanitized for presentation to end users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exceptionLevel}
     * will return {@link ExceptionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exceptionLevelAsString}.
     * </p>
     * 
     * @return The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
     *         this parameter is not set, exception messages are by default sanitized for presentation to end users.
     * @see ExceptionLevel
     */
    public final String exceptionLevelAsString() {
        return exceptionLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayUrl());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusReasons() ? statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(workloadIdentityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(exceptionLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGatewayResponse)) {
            return false;
        }
        GetGatewayResponse other = (GetGatewayResponse) obj;
        return Objects.equals(gatewayArn(), other.gatewayArn()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(gatewayUrl(), other.gatewayUrl()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasStatusReasons() == other.hasStatusReasons() && Objects.equals(statusReasons(), other.statusReasons())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(protocolTypeAsString(), other.protocolTypeAsString())
                && Objects.equals(protocolConfiguration(), other.protocolConfiguration())
                && Objects.equals(authorizerTypeAsString(), other.authorizerTypeAsString())
                && Objects.equals(authorizerConfiguration(), other.authorizerConfiguration())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(workloadIdentityDetails(), other.workloadIdentityDetails())
                && Objects.equals(exceptionLevelAsString(), other.exceptionLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGatewayResponse").add("GatewayArn", gatewayArn()).add("GatewayId", gatewayId())
                .add("GatewayUrl", gatewayUrl()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Status", statusAsString()).add("StatusReasons", hasStatusReasons() ? statusReasons() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("ProtocolType", protocolTypeAsString()).add("ProtocolConfiguration", protocolConfiguration())
                .add("AuthorizerType", authorizerTypeAsString()).add("AuthorizerConfiguration", authorizerConfiguration())
                .add("KmsKeyArn", kmsKeyArn()).add("WorkloadIdentityDetails", workloadIdentityDetails())
                .add("ExceptionLevel", exceptionLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "gatewayUrl":
            return Optional.ofNullable(clazz.cast(gatewayUrl()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReasons":
            return Optional.ofNullable(clazz.cast(statusReasons()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "protocolType":
            return Optional.ofNullable(clazz.cast(protocolTypeAsString()));
        case "protocolConfiguration":
            return Optional.ofNullable(clazz.cast(protocolConfiguration()));
        case "authorizerType":
            return Optional.ofNullable(clazz.cast(authorizerTypeAsString()));
        case "authorizerConfiguration":
            return Optional.ofNullable(clazz.cast(authorizerConfiguration()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "workloadIdentityDetails":
            return Optional.ofNullable(clazz.cast(workloadIdentityDetails()));
        case "exceptionLevel":
            return Optional.ofNullable(clazz.cast(exceptionLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("gatewayUrl", GATEWAY_URL_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("protocolType", PROTOCOL_TYPE_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("authorizerType", AUTHORIZER_TYPE_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("workloadIdentityDetails", WORKLOAD_IDENTITY_DETAILS_FIELD);
        map.put("exceptionLevel", EXCEPTION_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGatewayResponse, T> g) {
        return obj -> g.apply((GetGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGatewayResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Gateway.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * <p>
         * The unique identifier of the Gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * An endpoint for invoking Gateway.
         * </p>
         * 
         * @param gatewayUrl
         *        An endpoint for invoking Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayUrl(String gatewayUrl);

        /**
         * <p>
         * The timestamp when the Gateway was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the Gateway was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the Gateway was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the Gateway was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the Gateway.
         * </p>
         * 
         * @param status
         *        The current status of the Gateway.
         * @see GatewayStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Gateway.
         * </p>
         * 
         * @param status
         *        The current status of the Gateway.
         * @see GatewayStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayStatus
         */
        Builder status(GatewayStatus status);

        /**
         * <p>
         * The reasons for the current status of the Gateway.
         * </p>
         * 
         * @param statusReasons
         *        The reasons for the current status of the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(Collection<String> statusReasons);

        /**
         * <p>
         * The reasons for the current status of the Gateway.
         * </p>
         * 
         * @param statusReasons
         *        The reasons for the current status of the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(String... statusReasons);

        /**
         * <p>
         * The name of the Gateway.
         * </p>
         * 
         * @param name
         *        The name of the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the Gateway.
         * </p>
         * 
         * @param description
         *        The description of the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IAM role ARN that provides permissions for the Gateway.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that provides permissions for the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Protocol applied to a Gateway.
         * </p>
         * 
         * @param protocolType
         *        Protocol applied to a Gateway.
         * @see GatewayProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayProtocolType
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * Protocol applied to a Gateway.
         * </p>
         * 
         * @param protocolType
         *        Protocol applied to a Gateway.
         * @see GatewayProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayProtocolType
         */
        Builder protocolType(GatewayProtocolType protocolType);

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * @param protocolConfiguration
         *        The new value for the ProtocolConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfiguration(GatewayProtocolConfiguration protocolConfiguration);

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GatewayProtocolConfiguration.Builder}
         * avoiding the need to create one manually via {@link GatewayProtocolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayProtocolConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #protocolConfiguration(GatewayProtocolConfiguration)}.
         * 
         * @param protocolConfiguration
         *        a consumer that will call methods on {@link GatewayProtocolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolConfiguration(GatewayProtocolConfiguration)
         */
        default Builder protocolConfiguration(Consumer<GatewayProtocolConfiguration.Builder> protocolConfiguration) {
            return protocolConfiguration(GatewayProtocolConfiguration.builder().applyMutation(protocolConfiguration).build());
        }

        /**
         * <p>
         * Authorizer type for the gateway.
         * </p>
         * 
         * @param authorizerType
         *        Authorizer type for the gateway.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(String authorizerType);

        /**
         * <p>
         * Authorizer type for the gateway.
         * </p>
         * 
         * @param authorizerType
         *        Authorizer type for the gateway.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(AuthorizerType authorizerType);

        /**
         * <p>
         * The authorizer configuration for the Gateway.
         * </p>
         * 
         * @param authorizerConfiguration
         *        The authorizer configuration for the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration);

        /**
         * <p>
         * The authorizer configuration for the Gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizerConfiguration.Builder} avoiding
         * the need to create one manually via {@link AuthorizerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizerConfiguration(AuthorizerConfiguration)}.
         * 
         * @param authorizerConfiguration
         *        a consumer that will call methods on {@link AuthorizerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfiguration(AuthorizerConfiguration)
         */
        default Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return authorizerConfiguration(AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration).build());
        }

        /**
         * <p>
         * The ARN of the KMS key used to encrypt the Gateway.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key used to encrypt the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The workload identity details for the Gateway.
         * </p>
         * 
         * @param workloadIdentityDetails
         *        The workload identity details for the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails);

        /**
         * <p>
         * The workload identity details for the Gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadIdentityDetails.Builder} avoiding
         * the need to create one manually via {@link WorkloadIdentityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadIdentityDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #workloadIdentityDetails(WorkloadIdentityDetails)}.
         * 
         * @param workloadIdentityDetails
         *        a consumer that will call methods on {@link WorkloadIdentityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadIdentityDetails(WorkloadIdentityDetails)
         */
        default Builder workloadIdentityDetails(Consumer<WorkloadIdentityDetails.Builder> workloadIdentityDetails) {
            return workloadIdentityDetails(WorkloadIdentityDetails.builder().applyMutation(workloadIdentityDetails).build());
        }

        /**
         * <p>
         * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
         * this parameter is not set, exception messages are by default sanitized for presentation to end users.
         * </p>
         * 
         * @param exceptionLevel
         *        The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway.
         *        If this parameter is not set, exception messages are by default sanitized for presentation to end
         *        users.
         * @see ExceptionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExceptionLevel
         */
        Builder exceptionLevel(String exceptionLevel);

        /**
         * <p>
         * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
         * this parameter is not set, exception messages are by default sanitized for presentation to end users.
         * </p>
         * 
         * @param exceptionLevel
         *        The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway.
         *        If this parameter is not set, exception messages are by default sanitized for presentation to end
         *        users.
         * @see ExceptionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExceptionLevel
         */
        Builder exceptionLevel(ExceptionLevel exceptionLevel);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String gatewayArn;

        private String gatewayId;

        private String gatewayUrl;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String description;

        private String roleArn;

        private String protocolType;

        private GatewayProtocolConfiguration protocolConfiguration;

        private String authorizerType;

        private AuthorizerConfiguration authorizerConfiguration;

        private String kmsKeyArn;

        private WorkloadIdentityDetails workloadIdentityDetails;

        private String exceptionLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGatewayResponse model) {
            super(model);
            gatewayArn(model.gatewayArn);
            gatewayId(model.gatewayId);
            gatewayUrl(model.gatewayUrl);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
            statusReasons(model.statusReasons);
            name(model.name);
            description(model.description);
            roleArn(model.roleArn);
            protocolType(model.protocolType);
            protocolConfiguration(model.protocolConfiguration);
            authorizerType(model.authorizerType);
            authorizerConfiguration(model.authorizerConfiguration);
            kmsKeyArn(model.kmsKeyArn);
            workloadIdentityDetails(model.workloadIdentityDetails);
            exceptionLevel(model.exceptionLevel);
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getGatewayUrl() {
            return gatewayUrl;
        }

        public final void setGatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
        }

        @Override
        public final Builder gatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GatewayStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String... statusReasons) {
            statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getProtocolType() {
            return protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(GatewayProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final GatewayProtocolConfiguration.Builder getProtocolConfiguration() {
            return protocolConfiguration != null ? protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(GatewayProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(GatewayProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getAuthorizerType() {
            return authorizerType;
        }

        public final void setAuthorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
        }

        @Override
        public final Builder authorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        @Override
        public final Builder authorizerType(AuthorizerType authorizerType) {
            this.authorizerType(authorizerType == null ? null : authorizerType.toString());
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return authorizerConfiguration != null ? authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final WorkloadIdentityDetails.Builder getWorkloadIdentityDetails() {
            return workloadIdentityDetails != null ? workloadIdentityDetails.toBuilder() : null;
        }

        public final void setWorkloadIdentityDetails(WorkloadIdentityDetails.BuilderImpl workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails != null ? workloadIdentityDetails.build() : null;
        }

        @Override
        public final Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails;
            return this;
        }

        public final String getExceptionLevel() {
            return exceptionLevel;
        }

        public final void setExceptionLevel(String exceptionLevel) {
            this.exceptionLevel = exceptionLevel;
        }

        @Override
        public final Builder exceptionLevel(String exceptionLevel) {
            this.exceptionLevel = exceptionLevel;
            return this;
        }

        @Override
        public final Builder exceptionLevel(ExceptionLevel exceptionLevel) {
            this.exceptionLevel(exceptionLevel == null ? null : exceptionLevel.toString());
            return this;
        }

        @Override
        public GetGatewayResponse build() {
            return new GetGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
