/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Agent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Agent> {
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(Agent.getter(Agent::agentRuntimeArn)).setter(Agent.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(Agent.getter(Agent::agentRuntimeId)).setter(Agent.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeVersion").getter(Agent.getter(Agent::agentRuntimeVersion)).setter(Agent.setter(Builder::agentRuntimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeVersion").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeName").getter(Agent.getter(Agent::agentRuntimeName)).setter(Agent.setter(Builder::agentRuntimeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Agent.getter(Agent::description)).setter(Agent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(Agent.getter(Agent::lastUpdatedAt)).setter(Agent.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Agent.getter(Agent::statusAsString)).setter(Agent.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ARN_FIELD, AGENT_RUNTIME_ID_FIELD, AGENT_RUNTIME_VERSION_FIELD, AGENT_RUNTIME_NAME_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Agent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String agentRuntimeArn;
    private final String agentRuntimeId;
    private final String agentRuntimeVersion;
    private final String agentRuntimeName;
    private final String description;
    private final Instant lastUpdatedAt;
    private final String status;

    private Agent(BuilderImpl builder) {
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
        this.agentRuntimeName = builder.agentRuntimeName;
        this.description = builder.description;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final String agentRuntimeVersion() {
        return this.agentRuntimeVersion;
    }

    public final String agentRuntimeName() {
        return this.agentRuntimeName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final AgentStatus status() {
        return AgentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Agent)) {
            return false;
        }
        Agent other = (Agent)obj;
        return Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.agentRuntimeVersion(), other.agentRuntimeVersion()) && Objects.equals(this.agentRuntimeName(), other.agentRuntimeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Agent").add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("AgentRuntimeVersion", (Object)this.agentRuntimeVersion()).add("AgentRuntimeName", (Object)this.agentRuntimeName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "agentRuntimeVersion": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeVersion()));
            }
            case "agentRuntimeName": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("agentRuntimeVersion", AGENT_RUNTIME_VERSION_FIELD);
        map.put("agentRuntimeName", AGENT_RUNTIME_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Agent, T> g) {
        return obj -> g.apply((Agent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentRuntimeArn;
        private String agentRuntimeId;
        private String agentRuntimeVersion;
        private String agentRuntimeName;
        private String description;
        private Instant lastUpdatedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Agent model) {
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.agentRuntimeId(model.agentRuntimeId);
            this.agentRuntimeVersion(model.agentRuntimeVersion);
            this.agentRuntimeName(model.agentRuntimeName);
            this.description(model.description);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.status(model.status);
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return this.agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        public final String getAgentRuntimeName() {
            return this.agentRuntimeName;
        }

        public final void setAgentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
        }

        @Override
        public final Builder agentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public Agent build() {
            return new Agent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Agent> {
        public Builder agentRuntimeArn(String var1);

        public Builder agentRuntimeId(String var1);

        public Builder agentRuntimeVersion(String var1);

        public Builder agentRuntimeName(String var1);

        public Builder description(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(AgentStatus var1);
    }
}

