/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerProtocol {
    MCP("MCP"),
    HTTP("HTTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerProtocol> VALUE_MAP;
    private final String value;

    private ServerProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerProtocol> knownValues() {
        EnumSet<ServerProtocol> knownValues = EnumSet.allOf(ServerProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerProtocol.class, ServerProtocol::toString);
    }
}

