/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiKeyCredentialProvider;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OAuthCredentialProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CredentialProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CredentialProvider> {
    private static final SdkField<OAuthCredentialProvider> OAUTH_CREDENTIAL_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oauthCredentialProvider").getter(CredentialProvider.getter(CredentialProvider::oauthCredentialProvider)).setter(CredentialProvider.setter(Builder::oauthCredentialProvider)).constructor(OAuthCredentialProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthCredentialProvider").build()}).build();
    private static final SdkField<ApiKeyCredentialProvider> API_KEY_CREDENTIAL_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiKeyCredentialProvider").getter(CredentialProvider.getter(CredentialProvider::apiKeyCredentialProvider)).setter(CredentialProvider.setter(Builder::apiKeyCredentialProvider)).constructor(ApiKeyCredentialProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyCredentialProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OAUTH_CREDENTIAL_PROVIDER_FIELD, API_KEY_CREDENTIAL_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CredentialProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OAuthCredentialProvider oauthCredentialProvider;
    private final ApiKeyCredentialProvider apiKeyCredentialProvider;
    private final Type type;

    private CredentialProvider(BuilderImpl builder) {
        this.oauthCredentialProvider = builder.oauthCredentialProvider;
        this.apiKeyCredentialProvider = builder.apiKeyCredentialProvider;
        this.type = builder.type;
    }

    public final OAuthCredentialProvider oauthCredentialProvider() {
        return this.oauthCredentialProvider;
    }

    public final ApiKeyCredentialProvider apiKeyCredentialProvider() {
        return this.apiKeyCredentialProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oauthCredentialProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyCredentialProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialProvider)) {
            return false;
        }
        CredentialProvider other = (CredentialProvider)obj;
        return Objects.equals(this.oauthCredentialProvider(), other.oauthCredentialProvider()) && Objects.equals(this.apiKeyCredentialProvider(), other.apiKeyCredentialProvider());
    }

    public final String toString() {
        return ToString.builder((String)"CredentialProvider").add("OauthCredentialProvider", (Object)this.oauthCredentialProvider()).add("ApiKeyCredentialProvider", (Object)this.apiKeyCredentialProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oauthCredentialProvider": {
                return Optional.ofNullable(clazz.cast(this.oauthCredentialProvider()));
            }
            case "apiKeyCredentialProvider": {
                return Optional.ofNullable(clazz.cast(this.apiKeyCredentialProvider()));
            }
        }
        return Optional.empty();
    }

    public static CredentialProvider fromOauthCredentialProvider(OAuthCredentialProvider oauthCredentialProvider) {
        return (CredentialProvider)CredentialProvider.builder().oauthCredentialProvider(oauthCredentialProvider).build();
    }

    public static CredentialProvider fromOauthCredentialProvider(Consumer<OAuthCredentialProvider.Builder> oauthCredentialProvider) {
        OAuthCredentialProvider.Builder builder = OAuthCredentialProvider.builder();
        oauthCredentialProvider.accept(builder);
        return CredentialProvider.fromOauthCredentialProvider((OAuthCredentialProvider)builder.build());
    }

    public static CredentialProvider fromApiKeyCredentialProvider(ApiKeyCredentialProvider apiKeyCredentialProvider) {
        return (CredentialProvider)CredentialProvider.builder().apiKeyCredentialProvider(apiKeyCredentialProvider).build();
    }

    public static CredentialProvider fromApiKeyCredentialProvider(Consumer<ApiKeyCredentialProvider.Builder> apiKeyCredentialProvider) {
        ApiKeyCredentialProvider.Builder builder = ApiKeyCredentialProvider.builder();
        apiKeyCredentialProvider.accept(builder);
        return CredentialProvider.fromApiKeyCredentialProvider((ApiKeyCredentialProvider)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthCredentialProvider", OAUTH_CREDENTIAL_PROVIDER_FIELD);
        map.put("apiKeyCredentialProvider", API_KEY_CREDENTIAL_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CredentialProvider, T> g) {
        return obj -> g.apply((CredentialProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        OAUTH_CREDENTIAL_PROVIDER,
        API_KEY_CREDENTIAL_PROVIDER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private OAuthCredentialProvider oauthCredentialProvider;
        private ApiKeyCredentialProvider apiKeyCredentialProvider;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialProvider model) {
            this.oauthCredentialProvider(model.oauthCredentialProvider);
            this.apiKeyCredentialProvider(model.apiKeyCredentialProvider);
        }

        public final OAuthCredentialProvider.Builder getOauthCredentialProvider() {
            return this.oauthCredentialProvider != null ? this.oauthCredentialProvider.toBuilder() : null;
        }

        public final void setOauthCredentialProvider(OAuthCredentialProvider.BuilderImpl oauthCredentialProvider) {
            OAuthCredentialProvider oldValue = this.oauthCredentialProvider;
            this.oauthCredentialProvider = oauthCredentialProvider != null ? oauthCredentialProvider.build() : null;
            this.handleUnionValueChange(Type.OAUTH_CREDENTIAL_PROVIDER, oldValue, this.oauthCredentialProvider);
        }

        @Override
        public final Builder oauthCredentialProvider(OAuthCredentialProvider oauthCredentialProvider) {
            OAuthCredentialProvider oldValue = this.oauthCredentialProvider;
            this.oauthCredentialProvider = oauthCredentialProvider;
            this.handleUnionValueChange(Type.OAUTH_CREDENTIAL_PROVIDER, oldValue, this.oauthCredentialProvider);
            return this;
        }

        public final ApiKeyCredentialProvider.Builder getApiKeyCredentialProvider() {
            return this.apiKeyCredentialProvider != null ? this.apiKeyCredentialProvider.toBuilder() : null;
        }

        public final void setApiKeyCredentialProvider(ApiKeyCredentialProvider.BuilderImpl apiKeyCredentialProvider) {
            ApiKeyCredentialProvider oldValue = this.apiKeyCredentialProvider;
            this.apiKeyCredentialProvider = apiKeyCredentialProvider != null ? apiKeyCredentialProvider.build() : null;
            this.handleUnionValueChange(Type.API_KEY_CREDENTIAL_PROVIDER, oldValue, this.apiKeyCredentialProvider);
        }

        @Override
        public final Builder apiKeyCredentialProvider(ApiKeyCredentialProvider apiKeyCredentialProvider) {
            ApiKeyCredentialProvider oldValue = this.apiKeyCredentialProvider;
            this.apiKeyCredentialProvider = apiKeyCredentialProvider;
            this.handleUnionValueChange(Type.API_KEY_CREDENTIAL_PROVIDER, oldValue, this.apiKeyCredentialProvider);
            return this;
        }

        public CredentialProvider build() {
            return new CredentialProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CredentialProvider> {
        public Builder oauthCredentialProvider(OAuthCredentialProvider var1);

        default public Builder oauthCredentialProvider(Consumer<OAuthCredentialProvider.Builder> oauthCredentialProvider) {
            return this.oauthCredentialProvider((OAuthCredentialProvider)((OAuthCredentialProvider.Builder)OAuthCredentialProvider.builder().applyMutation(oauthCredentialProvider)).build());
        }

        public Builder apiKeyCredentialProvider(ApiKeyCredentialProvider var1);

        default public Builder apiKeyCredentialProvider(Consumer<ApiKeyCredentialProvider.Builder> apiKeyCredentialProvider) {
            return this.apiKeyCredentialProvider((ApiKeyCredentialProvider)((ApiKeyCredentialProvider.Builder)ApiKeyCredentialProvider.builder().applyMutation(apiKeyCredentialProvider)).build());
        }
    }
}

