/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyType {
    CUSTOMER_MANAGED_KEY("CustomerManagedKey"),
    SERVICE_MANAGED_KEY("ServiceManagedKey"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyType> VALUE_MAP;
    private final String value;

    private KeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyType> knownValues() {
        EnumSet<KeyType> knownValues = EnumSet.allOf(KeyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyType.class, KeyType::toString);
    }
}

