/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAgentRuntimeEndpointRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<DeleteAgentRuntimeEndpointRequest.Builder, DeleteAgentRuntimeEndpointRequest> {
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeId").getter(getter(DeleteAgentRuntimeEndpointRequest::agentRuntimeId))
            .setter(setter(Builder::agentRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeId").build()).build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointName").getter(getter(DeleteAgentRuntimeEndpointRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteAgentRuntimeEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ID_FIELD,
            ENDPOINT_NAME_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentRuntimeId;

    private final String endpointName;

    private final String clientToken;

    private DeleteAgentRuntimeEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeId = builder.agentRuntimeId;
        this.endpointName = builder.endpointName;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique identifier of the agent runtime associated with the endpoint.
     * </p>
     * 
     * @return The unique identifier of the agent runtime associated with the endpoint.
     */
    public final String agentRuntimeId() {
        return agentRuntimeId;
    }

    /**
     * <p>
     * The name of the agent runtime endpoint to delete.
     * </p>
     * 
     * @return The name of the agent runtime endpoint to delete.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentRuntimeEndpointRequest)) {
            return false;
        }
        DeleteAgentRuntimeEndpointRequest other = (DeleteAgentRuntimeEndpointRequest) obj;
        return Objects.equals(agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAgentRuntimeEndpointRequest").add("AgentRuntimeId", agentRuntimeId())
                .add("EndpointName", endpointName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimeId":
            return Optional.ofNullable(clazz.cast(agentRuntimeId()));
        case "endpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("endpointName", ENDPOINT_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentRuntimeEndpointRequest, T> g) {
        return obj -> g.apply((DeleteAgentRuntimeEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAgentRuntimeEndpointRequest> {
        /**
         * <p>
         * The unique identifier of the agent runtime associated with the endpoint.
         * </p>
         * 
         * @param agentRuntimeId
         *        The unique identifier of the agent runtime associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeId(String agentRuntimeId);

        /**
         * <p>
         * The name of the agent runtime endpoint to delete.
         * </p>
         * 
         * @param endpointName
         *        The name of the agent runtime endpoint to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String agentRuntimeId;

        private String endpointName;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentRuntimeEndpointRequest model) {
            super(model);
            agentRuntimeId(model.agentRuntimeId);
            endpointName(model.endpointName);
            clientToken(model.clientToken);
        }

        public final String getAgentRuntimeId() {
            return agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAgentRuntimeEndpointRequest build() {
            return new DeleteAgentRuntimeEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
