/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for a custom extraction configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomExtractionConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomExtractionConfigurationInput.Builder, CustomExtractionConfigurationInput> {
    private static final SdkField<SemanticOverrideExtractionConfigurationInput> SEMANTIC_EXTRACTION_OVERRIDE_FIELD = SdkField
            .<SemanticOverrideExtractionConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("semanticExtractionOverride")
            .getter(getter(CustomExtractionConfigurationInput::semanticExtractionOverride))
            .setter(setter(Builder::semanticExtractionOverride))
            .constructor(SemanticOverrideExtractionConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticExtractionOverride").build())
            .build();

    private static final SdkField<UserPreferenceOverrideExtractionConfigurationInput> USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD = SdkField
            .<UserPreferenceOverrideExtractionConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("userPreferenceExtractionOverride")
            .getter(getter(CustomExtractionConfigurationInput::userPreferenceExtractionOverride))
            .setter(setter(Builder::userPreferenceExtractionOverride))
            .constructor(UserPreferenceOverrideExtractionConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceExtractionOverride")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SEMANTIC_EXTRACTION_OVERRIDE_FIELD, USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SemanticOverrideExtractionConfigurationInput semanticExtractionOverride;

    private final UserPreferenceOverrideExtractionConfigurationInput userPreferenceExtractionOverride;

    private final Type type;

    private CustomExtractionConfigurationInput(BuilderImpl builder) {
        this.semanticExtractionOverride = builder.semanticExtractionOverride;
        this.userPreferenceExtractionOverride = builder.userPreferenceExtractionOverride;
        this.type = builder.type;
    }

    /**
     * <p>
     * The semantic extraction override configuration input.
     * </p>
     * 
     * @return The semantic extraction override configuration input.
     */
    public final SemanticOverrideExtractionConfigurationInput semanticExtractionOverride() {
        return semanticExtractionOverride;
    }

    /**
     * <p>
     * The user preference extraction override configuration input.
     * </p>
     * 
     * @return The user preference extraction override configuration input.
     */
    public final UserPreferenceOverrideExtractionConfigurationInput userPreferenceExtractionOverride() {
        return userPreferenceExtractionOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(semanticExtractionOverride());
        hashCode = 31 * hashCode + Objects.hashCode(userPreferenceExtractionOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomExtractionConfigurationInput)) {
            return false;
        }
        CustomExtractionConfigurationInput other = (CustomExtractionConfigurationInput) obj;
        return Objects.equals(semanticExtractionOverride(), other.semanticExtractionOverride())
                && Objects.equals(userPreferenceExtractionOverride(), other.userPreferenceExtractionOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomExtractionConfigurationInput")
                .add("SemanticExtractionOverride", semanticExtractionOverride())
                .add("UserPreferenceExtractionOverride", userPreferenceExtractionOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "semanticExtractionOverride":
            return Optional.ofNullable(clazz.cast(semanticExtractionOverride()));
        case "userPreferenceExtractionOverride":
            return Optional.ofNullable(clazz.cast(userPreferenceExtractionOverride()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #semanticExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The semantic extraction override configuration input.
     * </p>
     * 
     * @param semanticExtractionOverride
     *        The semantic extraction override configuration input.
     */
    public static CustomExtractionConfigurationInput fromSemanticExtractionOverride(
            SemanticOverrideExtractionConfigurationInput semanticExtractionOverride) {
        return builder().semanticExtractionOverride(semanticExtractionOverride).build();
    }

    /**
     * Create an instance of this class with {@link #semanticExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The semantic extraction override configuration input.
     * </p>
     * 
     * @param semanticExtractionOverride
     *        The semantic extraction override configuration input.
     */
    public static CustomExtractionConfigurationInput fromSemanticExtractionOverride(
            Consumer<SemanticOverrideExtractionConfigurationInput.Builder> semanticExtractionOverride) {
        SemanticOverrideExtractionConfigurationInput.Builder builder = SemanticOverrideExtractionConfigurationInput.builder();
        semanticExtractionOverride.accept(builder);
        return fromSemanticExtractionOverride(builder.build());
    }

    /**
     * Create an instance of this class with {@link #userPreferenceExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The user preference extraction override configuration input.
     * </p>
     * 
     * @param userPreferenceExtractionOverride
     *        The user preference extraction override configuration input.
     */
    public static CustomExtractionConfigurationInput fromUserPreferenceExtractionOverride(
            UserPreferenceOverrideExtractionConfigurationInput userPreferenceExtractionOverride) {
        return builder().userPreferenceExtractionOverride(userPreferenceExtractionOverride).build();
    }

    /**
     * Create an instance of this class with {@link #userPreferenceExtractionOverride()} initialized to the given value.
     *
     * <p>
     * The user preference extraction override configuration input.
     * </p>
     * 
     * @param userPreferenceExtractionOverride
     *        The user preference extraction override configuration input.
     */
    public static CustomExtractionConfigurationInput fromUserPreferenceExtractionOverride(
            Consumer<UserPreferenceOverrideExtractionConfigurationInput.Builder> userPreferenceExtractionOverride) {
        UserPreferenceOverrideExtractionConfigurationInput.Builder builder = UserPreferenceOverrideExtractionConfigurationInput
                .builder();
        userPreferenceExtractionOverride.accept(builder);
        return fromUserPreferenceExtractionOverride(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("semanticExtractionOverride", SEMANTIC_EXTRACTION_OVERRIDE_FIELD);
        map.put("userPreferenceExtractionOverride", USER_PREFERENCE_EXTRACTION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomExtractionConfigurationInput, T> g) {
        return obj -> g.apply((CustomExtractionConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomExtractionConfigurationInput> {
        /**
         * <p>
         * The semantic extraction override configuration input.
         * </p>
         * 
         * @param semanticExtractionOverride
         *        The semantic extraction override configuration input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticExtractionOverride(SemanticOverrideExtractionConfigurationInput semanticExtractionOverride);

        /**
         * <p>
         * The semantic extraction override configuration input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SemanticOverrideExtractionConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SemanticOverrideExtractionConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticOverrideExtractionConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #semanticExtractionOverride(SemanticOverrideExtractionConfigurationInput)}.
         * 
         * @param semanticExtractionOverride
         *        a consumer that will call methods on {@link SemanticOverrideExtractionConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticExtractionOverride(SemanticOverrideExtractionConfigurationInput)
         */
        default Builder semanticExtractionOverride(
                Consumer<SemanticOverrideExtractionConfigurationInput.Builder> semanticExtractionOverride) {
            return semanticExtractionOverride(SemanticOverrideExtractionConfigurationInput.builder()
                    .applyMutation(semanticExtractionOverride).build());
        }

        /**
         * <p>
         * The user preference extraction override configuration input.
         * </p>
         * 
         * @param userPreferenceExtractionOverride
         *        The user preference extraction override configuration input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPreferenceExtractionOverride(
                UserPreferenceOverrideExtractionConfigurationInput userPreferenceExtractionOverride);

        /**
         * <p>
         * The user preference extraction override configuration input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UserPreferenceOverrideExtractionConfigurationInput.Builder} avoiding the need to create one manually
         * via {@link UserPreferenceOverrideExtractionConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link UserPreferenceOverrideExtractionConfigurationInput.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #userPreferenceExtractionOverride(UserPreferenceOverrideExtractionConfigurationInput)}.
         * 
         * @param userPreferenceExtractionOverride
         *        a consumer that will call methods on
         *        {@link UserPreferenceOverrideExtractionConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPreferenceExtractionOverride(UserPreferenceOverrideExtractionConfigurationInput)
         */
        default Builder userPreferenceExtractionOverride(
                Consumer<UserPreferenceOverrideExtractionConfigurationInput.Builder> userPreferenceExtractionOverride) {
            return userPreferenceExtractionOverride(UserPreferenceOverrideExtractionConfigurationInput.builder()
                    .applyMutation(userPreferenceExtractionOverride).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemanticOverrideExtractionConfigurationInput semanticExtractionOverride;

        private UserPreferenceOverrideExtractionConfigurationInput userPreferenceExtractionOverride;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomExtractionConfigurationInput model) {
            semanticExtractionOverride(model.semanticExtractionOverride);
            userPreferenceExtractionOverride(model.userPreferenceExtractionOverride);
        }

        public final SemanticOverrideExtractionConfigurationInput.Builder getSemanticExtractionOverride() {
            return semanticExtractionOverride != null ? semanticExtractionOverride.toBuilder() : null;
        }

        public final void setSemanticExtractionOverride(
                SemanticOverrideExtractionConfigurationInput.BuilderImpl semanticExtractionOverride) {
            Object oldValue = this.semanticExtractionOverride;
            this.semanticExtractionOverride = semanticExtractionOverride != null ? semanticExtractionOverride.build() : null;
            handleUnionValueChange(Type.SEMANTIC_EXTRACTION_OVERRIDE, oldValue, this.semanticExtractionOverride);
        }

        @Override
        public final Builder semanticExtractionOverride(SemanticOverrideExtractionConfigurationInput semanticExtractionOverride) {
            Object oldValue = this.semanticExtractionOverride;
            this.semanticExtractionOverride = semanticExtractionOverride;
            handleUnionValueChange(Type.SEMANTIC_EXTRACTION_OVERRIDE, oldValue, this.semanticExtractionOverride);
            return this;
        }

        public final UserPreferenceOverrideExtractionConfigurationInput.Builder getUserPreferenceExtractionOverride() {
            return userPreferenceExtractionOverride != null ? userPreferenceExtractionOverride.toBuilder() : null;
        }

        public final void setUserPreferenceExtractionOverride(
                UserPreferenceOverrideExtractionConfigurationInput.BuilderImpl userPreferenceExtractionOverride) {
            Object oldValue = this.userPreferenceExtractionOverride;
            this.userPreferenceExtractionOverride = userPreferenceExtractionOverride != null ? userPreferenceExtractionOverride
                    .build() : null;
            handleUnionValueChange(Type.USER_PREFERENCE_EXTRACTION_OVERRIDE, oldValue, this.userPreferenceExtractionOverride);
        }

        @Override
        public final Builder userPreferenceExtractionOverride(
                UserPreferenceOverrideExtractionConfigurationInput userPreferenceExtractionOverride) {
            Object oldValue = this.userPreferenceExtractionOverride;
            this.userPreferenceExtractionOverride = userPreferenceExtractionOverride;
            handleUnionValueChange(Type.USER_PREFERENCE_EXTRACTION_OVERRIDE, oldValue, this.userPreferenceExtractionOverride);
            return this;
        }

        @Override
        public CustomExtractionConfigurationInput build() {
            return new CustomExtractionConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomExtractionConfigurationInput#type()
     */
    public enum Type {
        SEMANTIC_EXTRACTION_OVERRIDE,

        USER_PREFERENCE_EXTRACTION_OVERRIDE,

        UNKNOWN_TO_SDK_VERSION
    }
}
