/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A credential provider for gateway authentication. This structure contains the configuration for authenticating with
 * the target endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CredentialProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CredentialProvider.Builder, CredentialProvider> {
    private static final SdkField<OAuthCredentialProvider> OAUTH_CREDENTIAL_PROVIDER_FIELD = SdkField
            .<OAuthCredentialProvider> builder(MarshallingType.SDK_POJO).memberName("oauthCredentialProvider")
            .getter(getter(CredentialProvider::oauthCredentialProvider)).setter(setter(Builder::oauthCredentialProvider))
            .constructor(OAuthCredentialProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthCredentialProvider").build())
            .build();

    private static final SdkField<ApiKeyCredentialProvider> API_KEY_CREDENTIAL_PROVIDER_FIELD = SdkField
            .<ApiKeyCredentialProvider> builder(MarshallingType.SDK_POJO).memberName("apiKeyCredentialProvider")
            .getter(getter(CredentialProvider::apiKeyCredentialProvider)).setter(setter(Builder::apiKeyCredentialProvider))
            .constructor(ApiKeyCredentialProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyCredentialProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OAUTH_CREDENTIAL_PROVIDER_FIELD, API_KEY_CREDENTIAL_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OAuthCredentialProvider oauthCredentialProvider;

    private final ApiKeyCredentialProvider apiKeyCredentialProvider;

    private final Type type;

    private CredentialProvider(BuilderImpl builder) {
        this.oauthCredentialProvider = builder.oauthCredentialProvider;
        this.apiKeyCredentialProvider = builder.apiKeyCredentialProvider;
        this.type = builder.type;
    }

    /**
     * <p>
     * The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
     * </p>
     * 
     * @return The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
     */
    public final OAuthCredentialProvider oauthCredentialProvider() {
        return oauthCredentialProvider;
    }

    /**
     * <p>
     * The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
     * </p>
     * 
     * @return The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
     */
    public final ApiKeyCredentialProvider apiKeyCredentialProvider() {
        return apiKeyCredentialProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oauthCredentialProvider());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyCredentialProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialProvider)) {
            return false;
        }
        CredentialProvider other = (CredentialProvider) obj;
        return Objects.equals(oauthCredentialProvider(), other.oauthCredentialProvider())
                && Objects.equals(apiKeyCredentialProvider(), other.apiKeyCredentialProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CredentialProvider").add("OauthCredentialProvider", oauthCredentialProvider())
                .add("ApiKeyCredentialProvider", apiKeyCredentialProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oauthCredentialProvider":
            return Optional.ofNullable(clazz.cast(oauthCredentialProvider()));
        case "apiKeyCredentialProvider":
            return Optional.ofNullable(clazz.cast(apiKeyCredentialProvider()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #oauthCredentialProvider()} initialized to the given value.
     *
     * <p>
     * The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
     * </p>
     * 
     * @param oauthCredentialProvider
     *        The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
     */
    public static CredentialProvider fromOauthCredentialProvider(OAuthCredentialProvider oauthCredentialProvider) {
        return builder().oauthCredentialProvider(oauthCredentialProvider).build();
    }

    /**
     * Create an instance of this class with {@link #oauthCredentialProvider()} initialized to the given value.
     *
     * <p>
     * The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
     * </p>
     * 
     * @param oauthCredentialProvider
     *        The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
     */
    public static CredentialProvider fromOauthCredentialProvider(Consumer<OAuthCredentialProvider.Builder> oauthCredentialProvider) {
        OAuthCredentialProvider.Builder builder = OAuthCredentialProvider.builder();
        oauthCredentialProvider.accept(builder);
        return fromOauthCredentialProvider(builder.build());
    }

    /**
     * Create an instance of this class with {@link #apiKeyCredentialProvider()} initialized to the given value.
     *
     * <p>
     * The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
     * </p>
     * 
     * @param apiKeyCredentialProvider
     *        The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
     */
    public static CredentialProvider fromApiKeyCredentialProvider(ApiKeyCredentialProvider apiKeyCredentialProvider) {
        return builder().apiKeyCredentialProvider(apiKeyCredentialProvider).build();
    }

    /**
     * Create an instance of this class with {@link #apiKeyCredentialProvider()} initialized to the given value.
     *
     * <p>
     * The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
     * </p>
     * 
     * @param apiKeyCredentialProvider
     *        The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
     */
    public static CredentialProvider fromApiKeyCredentialProvider(
            Consumer<ApiKeyCredentialProvider.Builder> apiKeyCredentialProvider) {
        ApiKeyCredentialProvider.Builder builder = ApiKeyCredentialProvider.builder();
        apiKeyCredentialProvider.accept(builder);
        return fromApiKeyCredentialProvider(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("oauthCredentialProvider", OAUTH_CREDENTIAL_PROVIDER_FIELD);
        map.put("apiKeyCredentialProvider", API_KEY_CREDENTIAL_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CredentialProvider, T> g) {
        return obj -> g.apply((CredentialProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CredentialProvider> {
        /**
         * <p>
         * The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
         * </p>
         * 
         * @param oauthCredentialProvider
         *        The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthCredentialProvider(OAuthCredentialProvider oauthCredentialProvider);

        /**
         * <p>
         * The OAuth credential provider. This provider uses OAuth authentication to access the target endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuthCredentialProvider.Builder} avoiding
         * the need to create one manually via {@link OAuthCredentialProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuthCredentialProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #oauthCredentialProvider(OAuthCredentialProvider)}.
         * 
         * @param oauthCredentialProvider
         *        a consumer that will call methods on {@link OAuthCredentialProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oauthCredentialProvider(OAuthCredentialProvider)
         */
        default Builder oauthCredentialProvider(Consumer<OAuthCredentialProvider.Builder> oauthCredentialProvider) {
            return oauthCredentialProvider(OAuthCredentialProvider.builder().applyMutation(oauthCredentialProvider).build());
        }

        /**
         * <p>
         * The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
         * </p>
         * 
         * @param apiKeyCredentialProvider
         *        The API key credential provider. This provider uses an API key to authenticate with the target
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyCredentialProvider(ApiKeyCredentialProvider apiKeyCredentialProvider);

        /**
         * <p>
         * The API key credential provider. This provider uses an API key to authenticate with the target endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiKeyCredentialProvider.Builder}
         * avoiding the need to create one manually via {@link ApiKeyCredentialProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiKeyCredentialProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #apiKeyCredentialProvider(ApiKeyCredentialProvider)}.
         * 
         * @param apiKeyCredentialProvider
         *        a consumer that will call methods on {@link ApiKeyCredentialProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKeyCredentialProvider(ApiKeyCredentialProvider)
         */
        default Builder apiKeyCredentialProvider(Consumer<ApiKeyCredentialProvider.Builder> apiKeyCredentialProvider) {
            return apiKeyCredentialProvider(ApiKeyCredentialProvider.builder().applyMutation(apiKeyCredentialProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OAuthCredentialProvider oauthCredentialProvider;

        private ApiKeyCredentialProvider apiKeyCredentialProvider;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialProvider model) {
            oauthCredentialProvider(model.oauthCredentialProvider);
            apiKeyCredentialProvider(model.apiKeyCredentialProvider);
        }

        public final OAuthCredentialProvider.Builder getOauthCredentialProvider() {
            return oauthCredentialProvider != null ? oauthCredentialProvider.toBuilder() : null;
        }

        public final void setOauthCredentialProvider(OAuthCredentialProvider.BuilderImpl oauthCredentialProvider) {
            Object oldValue = this.oauthCredentialProvider;
            this.oauthCredentialProvider = oauthCredentialProvider != null ? oauthCredentialProvider.build() : null;
            handleUnionValueChange(Type.OAUTH_CREDENTIAL_PROVIDER, oldValue, this.oauthCredentialProvider);
        }

        @Override
        public final Builder oauthCredentialProvider(OAuthCredentialProvider oauthCredentialProvider) {
            Object oldValue = this.oauthCredentialProvider;
            this.oauthCredentialProvider = oauthCredentialProvider;
            handleUnionValueChange(Type.OAUTH_CREDENTIAL_PROVIDER, oldValue, this.oauthCredentialProvider);
            return this;
        }

        public final ApiKeyCredentialProvider.Builder getApiKeyCredentialProvider() {
            return apiKeyCredentialProvider != null ? apiKeyCredentialProvider.toBuilder() : null;
        }

        public final void setApiKeyCredentialProvider(ApiKeyCredentialProvider.BuilderImpl apiKeyCredentialProvider) {
            Object oldValue = this.apiKeyCredentialProvider;
            this.apiKeyCredentialProvider = apiKeyCredentialProvider != null ? apiKeyCredentialProvider.build() : null;
            handleUnionValueChange(Type.API_KEY_CREDENTIAL_PROVIDER, oldValue, this.apiKeyCredentialProvider);
        }

        @Override
        public final Builder apiKeyCredentialProvider(ApiKeyCredentialProvider apiKeyCredentialProvider) {
            Object oldValue = this.apiKeyCredentialProvider;
            this.apiKeyCredentialProvider = apiKeyCredentialProvider;
            handleUnionValueChange(Type.API_KEY_CREDENTIAL_PROVIDER, oldValue, this.apiKeyCredentialProvider);
            return this;
        }

        @Override
        public CredentialProvider build() {
            return new CredentialProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CredentialProvider#type()
     */
    public enum Type {
        OAUTH_CREDENTIAL_PROVIDER,

        API_KEY_CREDENTIAL_PROVIDER,

        UNKNOWN_TO_SDK_VERSION
    }
}
