/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentArtifact;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AuthorizerConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EnvironmentVariablesMapCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NetworkConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ProtocolConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentRuntimeRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, UpdateAgentRuntimeRequest> {
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::agentRuntimeId)).setter(UpdateAgentRuntimeRequest.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::description)).setter(UpdateAgentRuntimeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AgentArtifact> AGENT_RUNTIME_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentRuntimeArtifact").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::agentRuntimeArtifact)).setter(UpdateAgentRuntimeRequest.setter(Builder::agentRuntimeArtifact)).constructor(AgentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArtifact").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::roleArn)).setter(UpdateAgentRuntimeRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::networkConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<ProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("protocolConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::protocolConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::protocolConfiguration)).constructor(ProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::clientToken)).setter(UpdateAgentRuntimeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::environmentVariables)).setter(UpdateAgentRuntimeRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfiguration").getter(UpdateAgentRuntimeRequest.getter(UpdateAgentRuntimeRequest::authorizerConfiguration)).setter(UpdateAgentRuntimeRequest.setter(Builder::authorizerConfiguration)).constructor(AuthorizerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ID_FIELD, DESCRIPTION_FIELD, AGENT_RUNTIME_ARTIFACT_FIELD, ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, PROTOCOL_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_VARIABLES_FIELD, AUTHORIZER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAgentRuntimeRequest.memberNameToFieldInitializer();
    private final String agentRuntimeId;
    private final String description;
    private final AgentArtifact agentRuntimeArtifact;
    private final String roleArn;
    private final NetworkConfiguration networkConfiguration;
    private final ProtocolConfiguration protocolConfiguration;
    private final String clientToken;
    private final Map<String, String> environmentVariables;
    private final AuthorizerConfiguration authorizerConfiguration;

    private UpdateAgentRuntimeRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeId = builder.agentRuntimeId;
        this.description = builder.description;
        this.agentRuntimeArtifact = builder.agentRuntimeArtifact;
        this.roleArn = builder.roleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.clientToken = builder.clientToken;
        this.environmentVariables = builder.environmentVariables;
        this.authorizerConfiguration = builder.authorizerConfiguration;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final String description() {
        return this.description;
    }

    public final AgentArtifact agentRuntimeArtifact() {
        return this.agentRuntimeArtifact;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final AuthorizerConfiguration authorizerConfiguration() {
        return this.authorizerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentRuntimeRequest)) {
            return false;
        }
        UpdateAgentRuntimeRequest other = (UpdateAgentRuntimeRequest)((Object)obj);
        return Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.agentRuntimeArtifact(), other.agentRuntimeArtifact()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.protocolConfiguration(), other.protocolConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.authorizerConfiguration(), other.authorizerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentRuntimeRequest").add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("AgentRuntimeArtifact", (Object)this.agentRuntimeArtifact()).add("RoleArn", (Object)this.roleArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("ProtocolConfiguration", (Object)this.protocolConfiguration()).add("ClientToken", (Object)this.clientToken()).add("EnvironmentVariables", (Object)(this.environmentVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthorizerConfiguration", (Object)this.authorizerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "agentRuntimeArtifact": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArtifact()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "protocolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.protocolConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "authorizerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("agentRuntimeArtifact", AGENT_RUNTIME_ARTIFACT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentRuntimeRequest, T> g) {
        return obj -> g.apply((UpdateAgentRuntimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String agentRuntimeId;
        private String description;
        private AgentArtifact agentRuntimeArtifact;
        private String roleArn;
        private NetworkConfiguration networkConfiguration;
        private ProtocolConfiguration protocolConfiguration;
        private String clientToken;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private AuthorizerConfiguration authorizerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentRuntimeRequest model) {
            super(model);
            this.agentRuntimeId(model.agentRuntimeId);
            this.description(model.description);
            this.agentRuntimeArtifact(model.agentRuntimeArtifact);
            this.roleArn(model.roleArn);
            this.networkConfiguration(model.networkConfiguration);
            this.protocolConfiguration(model.protocolConfiguration);
            this.clientToken(model.clientToken);
            this.environmentVariables(model.environmentVariables);
            this.authorizerConfiguration(model.authorizerConfiguration);
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AgentArtifact.Builder getAgentRuntimeArtifact() {
            return this.agentRuntimeArtifact != null ? this.agentRuntimeArtifact.toBuilder() : null;
        }

        public final void setAgentRuntimeArtifact(AgentArtifact.BuilderImpl agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact != null ? agentRuntimeArtifact.build() : null;
        }

        @Override
        public final Builder agentRuntimeArtifact(AgentArtifact agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final ProtocolConfiguration.Builder getProtocolConfiguration() {
            return this.protocolConfiguration != null ? this.protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(ProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return this.authorizerConfiguration != null ? this.authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentRuntimeRequest build() {
            return new UpdateAgentRuntimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentRuntimeRequest> {
        public Builder agentRuntimeId(String var1);

        public Builder description(String var1);

        public Builder agentRuntimeArtifact(AgentArtifact var1);

        default public Builder agentRuntimeArtifact(Consumer<AgentArtifact.Builder> agentRuntimeArtifact) {
            return this.agentRuntimeArtifact((AgentArtifact)((AgentArtifact.Builder)AgentArtifact.builder().applyMutation(agentRuntimeArtifact)).build());
        }

        public Builder roleArn(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder protocolConfiguration(ProtocolConfiguration var1);

        default public Builder protocolConfiguration(Consumer<ProtocolConfiguration.Builder> protocolConfiguration) {
            return this.protocolConfiguration((ProtocolConfiguration)((ProtocolConfiguration.Builder)ProtocolConfiguration.builder().applyMutation(protocolConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder authorizerConfiguration(AuthorizerConfiguration var1);

        default public Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return this.authorizerConfiguration((AuthorizerConfiguration)((AuthorizerConfiguration.Builder)AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

