/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for user preference override configuration in a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPreferenceOverrideConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPreferenceOverrideConfigurationInput.Builder, UserPreferenceOverrideConfigurationInput> {
    private static final SdkField<UserPreferenceOverrideExtractionConfigurationInput> EXTRACTION_FIELD = SdkField
            .<UserPreferenceOverrideExtractionConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("extraction")
            .getter(getter(UserPreferenceOverrideConfigurationInput::extraction)).setter(setter(Builder::extraction))
            .constructor(UserPreferenceOverrideExtractionConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()).build();

    private static final SdkField<UserPreferenceOverrideConsolidationConfigurationInput> CONSOLIDATION_FIELD = SdkField
            .<UserPreferenceOverrideConsolidationConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("consolidation").getter(getter(UserPreferenceOverrideConfigurationInput::consolidation))
            .setter(setter(Builder::consolidation)).constructor(UserPreferenceOverrideConsolidationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD,
            CONSOLIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UserPreferenceOverrideExtractionConfigurationInput extraction;

    private final UserPreferenceOverrideConsolidationConfigurationInput consolidation;

    private UserPreferenceOverrideConfigurationInput(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.consolidation = builder.consolidation;
    }

    /**
     * <p>
     * The extraction configuration for a user preference override.
     * </p>
     * 
     * @return The extraction configuration for a user preference override.
     */
    public final UserPreferenceOverrideExtractionConfigurationInput extraction() {
        return extraction;
    }

    /**
     * <p>
     * The consolidation configuration for a user preference override.
     * </p>
     * 
     * @return The consolidation configuration for a user preference override.
     */
    public final UserPreferenceOverrideConsolidationConfigurationInput consolidation() {
        return consolidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraction());
        hashCode = 31 * hashCode + Objects.hashCode(consolidation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPreferenceOverrideConfigurationInput)) {
            return false;
        }
        UserPreferenceOverrideConfigurationInput other = (UserPreferenceOverrideConfigurationInput) obj;
        return Objects.equals(extraction(), other.extraction()) && Objects.equals(consolidation(), other.consolidation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPreferenceOverrideConfigurationInput").add("Extraction", extraction())
                .add("Consolidation", consolidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraction":
            return Optional.ofNullable(clazz.cast(extraction()));
        case "consolidation":
            return Optional.ofNullable(clazz.cast(consolidation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("consolidation", CONSOLIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPreferenceOverrideConfigurationInput, T> g) {
        return obj -> g.apply((UserPreferenceOverrideConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPreferenceOverrideConfigurationInput> {
        /**
         * <p>
         * The extraction configuration for a user preference override.
         * </p>
         * 
         * @param extraction
         *        The extraction configuration for a user preference override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraction(UserPreferenceOverrideExtractionConfigurationInput extraction);

        /**
         * <p>
         * The extraction configuration for a user preference override.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UserPreferenceOverrideExtractionConfigurationInput.Builder} avoiding the need to create one manually
         * via {@link UserPreferenceOverrideExtractionConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link UserPreferenceOverrideExtractionConfigurationInput.Builder#build()} is called immediately and its
         * result is passed to {@link #extraction(UserPreferenceOverrideExtractionConfigurationInput)}.
         * 
         * @param extraction
         *        a consumer that will call methods on
         *        {@link UserPreferenceOverrideExtractionConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraction(UserPreferenceOverrideExtractionConfigurationInput)
         */
        default Builder extraction(Consumer<UserPreferenceOverrideExtractionConfigurationInput.Builder> extraction) {
            return extraction(UserPreferenceOverrideExtractionConfigurationInput.builder().applyMutation(extraction).build());
        }

        /**
         * <p>
         * The consolidation configuration for a user preference override.
         * </p>
         * 
         * @param consolidation
         *        The consolidation configuration for a user preference override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consolidation(UserPreferenceOverrideConsolidationConfigurationInput consolidation);

        /**
         * <p>
         * The consolidation configuration for a user preference override.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UserPreferenceOverrideConsolidationConfigurationInput.Builder} avoiding the need to create one
         * manually via {@link UserPreferenceOverrideConsolidationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link UserPreferenceOverrideConsolidationConfigurationInput.Builder#build()} is called immediately and its
         * result is passed to {@link #consolidation(UserPreferenceOverrideConsolidationConfigurationInput)}.
         * 
         * @param consolidation
         *        a consumer that will call methods on
         *        {@link UserPreferenceOverrideConsolidationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consolidation(UserPreferenceOverrideConsolidationConfigurationInput)
         */
        default Builder consolidation(Consumer<UserPreferenceOverrideConsolidationConfigurationInput.Builder> consolidation) {
            return consolidation(UserPreferenceOverrideConsolidationConfigurationInput.builder().applyMutation(consolidation)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UserPreferenceOverrideExtractionConfigurationInput extraction;

        private UserPreferenceOverrideConsolidationConfigurationInput consolidation;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPreferenceOverrideConfigurationInput model) {
            extraction(model.extraction);
            consolidation(model.consolidation);
        }

        public final UserPreferenceOverrideExtractionConfigurationInput.Builder getExtraction() {
            return extraction != null ? extraction.toBuilder() : null;
        }

        public final void setExtraction(UserPreferenceOverrideExtractionConfigurationInput.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(UserPreferenceOverrideExtractionConfigurationInput extraction) {
            this.extraction = extraction;
            return this;
        }

        public final UserPreferenceOverrideConsolidationConfigurationInput.Builder getConsolidation() {
            return consolidation != null ? consolidation.toBuilder() : null;
        }

        public final void setConsolidation(UserPreferenceOverrideConsolidationConfigurationInput.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(UserPreferenceOverrideConsolidationConfigurationInput consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        @Override
        public UserPreferenceOverrideConfigurationInput build() {
            return new UserPreferenceOverrideConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
