/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOauth2CredentialProviderRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<UpdateOauth2CredentialProviderRequest.Builder, UpdateOauth2CredentialProviderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateOauth2CredentialProviderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CREDENTIAL_PROVIDER_VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialProviderVendor")
            .getter(getter(UpdateOauth2CredentialProviderRequest::credentialProviderVendorAsString))
            .setter(setter(Builder::credentialProviderVendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderVendor").build())
            .build();

    private static final SdkField<Oauth2ProviderConfigInput> OAUTH2_PROVIDER_CONFIG_INPUT_FIELD = SdkField
            .<Oauth2ProviderConfigInput> builder(MarshallingType.SDK_POJO).memberName("oauth2ProviderConfigInput")
            .getter(getter(UpdateOauth2CredentialProviderRequest::oauth2ProviderConfigInput))
            .setter(setter(Builder::oauth2ProviderConfigInput)).constructor(Oauth2ProviderConfigInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2ProviderConfigInput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CREDENTIAL_PROVIDER_VENDOR_FIELD, OAUTH2_PROVIDER_CONFIG_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String credentialProviderVendor;

    private final Oauth2ProviderConfigInput oauth2ProviderConfigInput;

    private UpdateOauth2CredentialProviderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.credentialProviderVendor = builder.credentialProviderVendor;
        this.oauth2ProviderConfigInput = builder.oauth2ProviderConfigInput;
    }

    /**
     * <p>
     * The name of the OAuth2 credential provider to update.
     * </p>
     * 
     * @return The name of the OAuth2 credential provider to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The vendor of the OAuth2 credential provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #credentialProviderVendor} will return {@link CredentialProviderVendorType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #credentialProviderVendorAsString}.
     * </p>
     * 
     * @return The vendor of the OAuth2 credential provider.
     * @see CredentialProviderVendorType
     */
    public final CredentialProviderVendorType credentialProviderVendor() {
        return CredentialProviderVendorType.fromValue(credentialProviderVendor);
    }

    /**
     * <p>
     * The vendor of the OAuth2 credential provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #credentialProviderVendor} will return {@link CredentialProviderVendorType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #credentialProviderVendorAsString}.
     * </p>
     * 
     * @return The vendor of the OAuth2 credential provider.
     * @see CredentialProviderVendorType
     */
    public final String credentialProviderVendorAsString() {
        return credentialProviderVendor;
    }

    /**
     * <p>
     * The configuration input for the OAuth2 provider.
     * </p>
     * 
     * @return The configuration input for the OAuth2 provider.
     */
    public final Oauth2ProviderConfigInput oauth2ProviderConfigInput() {
        return oauth2ProviderConfigInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(credentialProviderVendorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oauth2ProviderConfigInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOauth2CredentialProviderRequest)) {
            return false;
        }
        UpdateOauth2CredentialProviderRequest other = (UpdateOauth2CredentialProviderRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(credentialProviderVendorAsString(), other.credentialProviderVendorAsString())
                && Objects.equals(oauth2ProviderConfigInput(), other.oauth2ProviderConfigInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOauth2CredentialProviderRequest").add("Name", name())
                .add("CredentialProviderVendor", credentialProviderVendorAsString())
                .add("Oauth2ProviderConfigInput", oauth2ProviderConfigInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "credentialProviderVendor":
            return Optional.ofNullable(clazz.cast(credentialProviderVendorAsString()));
        case "oauth2ProviderConfigInput":
            return Optional.ofNullable(clazz.cast(oauth2ProviderConfigInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("credentialProviderVendor", CREDENTIAL_PROVIDER_VENDOR_FIELD);
        map.put("oauth2ProviderConfigInput", OAUTH2_PROVIDER_CONFIG_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOauth2CredentialProviderRequest, T> g) {
        return obj -> g.apply((UpdateOauth2CredentialProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOauth2CredentialProviderRequest> {
        /**
         * <p>
         * The name of the OAuth2 credential provider to update.
         * </p>
         * 
         * @param name
         *        The name of the OAuth2 credential provider to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The vendor of the OAuth2 credential provider.
         * </p>
         * 
         * @param credentialProviderVendor
         *        The vendor of the OAuth2 credential provider.
         * @see CredentialProviderVendorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CredentialProviderVendorType
         */
        Builder credentialProviderVendor(String credentialProviderVendor);

        /**
         * <p>
         * The vendor of the OAuth2 credential provider.
         * </p>
         * 
         * @param credentialProviderVendor
         *        The vendor of the OAuth2 credential provider.
         * @see CredentialProviderVendorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CredentialProviderVendorType
         */
        Builder credentialProviderVendor(CredentialProviderVendorType credentialProviderVendor);

        /**
         * <p>
         * The configuration input for the OAuth2 provider.
         * </p>
         * 
         * @param oauth2ProviderConfigInput
         *        The configuration input for the OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauth2ProviderConfigInput(Oauth2ProviderConfigInput oauth2ProviderConfigInput);

        /**
         * <p>
         * The configuration input for the OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link Oauth2ProviderConfigInput.Builder}
         * avoiding the need to create one manually via {@link Oauth2ProviderConfigInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Oauth2ProviderConfigInput.Builder#build()} is called immediately
         * and its result is passed to {@link #oauth2ProviderConfigInput(Oauth2ProviderConfigInput)}.
         * 
         * @param oauth2ProviderConfigInput
         *        a consumer that will call methods on {@link Oauth2ProviderConfigInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oauth2ProviderConfigInput(Oauth2ProviderConfigInput)
         */
        default Builder oauth2ProviderConfigInput(Consumer<Oauth2ProviderConfigInput.Builder> oauth2ProviderConfigInput) {
            return oauth2ProviderConfigInput(Oauth2ProviderConfigInput.builder().applyMutation(oauth2ProviderConfigInput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String name;

        private String credentialProviderVendor;

        private Oauth2ProviderConfigInput oauth2ProviderConfigInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOauth2CredentialProviderRequest model) {
            super(model);
            name(model.name);
            credentialProviderVendor(model.credentialProviderVendor);
            oauth2ProviderConfigInput(model.oauth2ProviderConfigInput);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCredentialProviderVendor() {
            return credentialProviderVendor;
        }

        public final void setCredentialProviderVendor(String credentialProviderVendor) {
            this.credentialProviderVendor = credentialProviderVendor;
        }

        @Override
        public final Builder credentialProviderVendor(String credentialProviderVendor) {
            this.credentialProviderVendor = credentialProviderVendor;
            return this;
        }

        @Override
        public final Builder credentialProviderVendor(CredentialProviderVendorType credentialProviderVendor) {
            this.credentialProviderVendor(credentialProviderVendor == null ? null : credentialProviderVendor.toString());
            return this;
        }

        public final Oauth2ProviderConfigInput.Builder getOauth2ProviderConfigInput() {
            return oauth2ProviderConfigInput != null ? oauth2ProviderConfigInput.toBuilder() : null;
        }

        public final void setOauth2ProviderConfigInput(Oauth2ProviderConfigInput.BuilderImpl oauth2ProviderConfigInput) {
            this.oauth2ProviderConfigInput = oauth2ProviderConfigInput != null ? oauth2ProviderConfigInput.build() : null;
        }

        @Override
        public final Builder oauth2ProviderConfigInput(Oauth2ProviderConfigInput oauth2ProviderConfigInput) {
            this.oauth2ProviderConfigInput = oauth2ProviderConfigInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOauth2CredentialProviderRequest build() {
            return new UpdateOauth2CredentialProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
