/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGatewayRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<UpdateGatewayRequest.Builder, UpdateGatewayRequest> {
    private static final SdkField<String> GATEWAY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayIdentifier").getter(getter(UpdateGatewayRequest::gatewayIdentifier))
            .setter(setter(Builder::gatewayIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateGatewayRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateGatewayRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateGatewayRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolType").getter(getter(UpdateGatewayRequest::protocolTypeAsString))
            .setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()).build();

    private static final SdkField<GatewayProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField
            .<GatewayProtocolConfiguration> builder(MarshallingType.SDK_POJO).memberName("protocolConfiguration")
            .getter(getter(UpdateGatewayRequest::protocolConfiguration)).setter(setter(Builder::protocolConfiguration))
            .constructor(GatewayProtocolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build())
            .build();

    private static final SdkField<String> AUTHORIZER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizerType").getter(getter(UpdateGatewayRequest::authorizerTypeAsString))
            .setter(setter(Builder::authorizerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerType").build()).build();

    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField
            .<AuthorizerConfiguration> builder(MarshallingType.SDK_POJO).memberName("authorizerConfiguration")
            .getter(getter(UpdateGatewayRequest::authorizerConfiguration)).setter(setter(Builder::authorizerConfiguration))
            .constructor(AuthorizerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(UpdateGatewayRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> EXCEPTION_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exceptionLevel").getter(getter(UpdateGatewayRequest::exceptionLevelAsString))
            .setter(setter(Builder::exceptionLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_IDENTIFIER_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, PROTOCOL_TYPE_FIELD, PROTOCOL_CONFIGURATION_FIELD,
            AUTHORIZER_TYPE_FIELD, AUTHORIZER_CONFIGURATION_FIELD, KMS_KEY_ARN_FIELD, EXCEPTION_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayIdentifier;

    private final String name;

    private final String description;

    private final String roleArn;

    private final String protocolType;

    private final GatewayProtocolConfiguration protocolConfiguration;

    private final String authorizerType;

    private final AuthorizerConfiguration authorizerConfiguration;

    private final String kmsKeyArn;

    private final String exceptionLevel;

    private UpdateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayIdentifier = builder.gatewayIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.protocolType = builder.protocolType;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.authorizerType = builder.authorizerType;
        this.authorizerConfiguration = builder.authorizerConfiguration;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.exceptionLevel = builder.exceptionLevel;
    }

    /**
     * <p>
     * The identifier of the gateway to update. This can be either the gateway ID or the gateway ARN.
     * </p>
     * 
     * @return The identifier of the gateway to update. This can be either the gateway ID or the gateway ARN.
     */
    public final String gatewayIdentifier() {
        return gatewayIdentifier;
    }

    /**
     * <p>
     * The updated name for the Gateway.
     * </p>
     * 
     * @return The updated name for the Gateway.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated description for the Gateway.
     * </p>
     * 
     * @return The updated description for the Gateway.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated IAM role ARN that provides permissions for the Gateway.
     * </p>
     * 
     * @return The updated IAM role ARN that provides permissions for the Gateway.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The updated protocol type for the Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link GatewayProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The updated protocol type for the Gateway.
     * @see GatewayProtocolType
     */
    public final GatewayProtocolType protocolType() {
        return GatewayProtocolType.fromValue(protocolType);
    }

    /**
     * <p>
     * The updated protocol type for the Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolType} will
     * return {@link GatewayProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolTypeAsString}.
     * </p>
     * 
     * @return The updated protocol type for the Gateway.
     * @see GatewayProtocolType
     */
    public final String protocolTypeAsString() {
        return protocolType;
    }

    /**
     * Returns the value of the ProtocolConfiguration property for this object.
     * 
     * @return The value of the ProtocolConfiguration property for this object.
     */
    public final GatewayProtocolConfiguration protocolConfiguration() {
        return protocolConfiguration;
    }

    /**
     * <p>
     * The updated authorizer type for the Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return The updated authorizer type for the Gateway.
     * @see AuthorizerType
     */
    public final AuthorizerType authorizerType() {
        return AuthorizerType.fromValue(authorizerType);
    }

    /**
     * <p>
     * The updated authorizer type for the Gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizerType}
     * will return {@link AuthorizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizerTypeAsString}.
     * </p>
     * 
     * @return The updated authorizer type for the Gateway.
     * @see AuthorizerType
     */
    public final String authorizerTypeAsString() {
        return authorizerType;
    }

    /**
     * <p>
     * The updated authorizer configuration for the Gateway.
     * </p>
     * 
     * @return The updated authorizer configuration for the Gateway.
     */
    public final AuthorizerConfiguration authorizerConfiguration() {
        return authorizerConfiguration;
    }

    /**
     * <p>
     * The updated ARN of the KMS key used to encrypt the Gateway.
     * </p>
     * 
     * @return The updated ARN of the KMS key used to encrypt the Gateway.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If this
     * parameter is not set, exception messages are by default sanitized for presentation to end users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exceptionLevel}
     * will return {@link ExceptionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exceptionLevelAsString}.
     * </p>
     * 
     * @return The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
     *         this parameter is not set, exception messages are by default sanitized for presentation to end users.
     * @see ExceptionLevel
     */
    public final ExceptionLevel exceptionLevel() {
        return ExceptionLevel.fromValue(exceptionLevel);
    }

    /**
     * <p>
     * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If this
     * parameter is not set, exception messages are by default sanitized for presentation to end users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exceptionLevel}
     * will return {@link ExceptionLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exceptionLevelAsString}.
     * </p>
     * 
     * @return The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
     *         this parameter is not set, exception messages are by default sanitized for presentation to end users.
     * @see ExceptionLevel
     */
    public final String exceptionLevelAsString() {
        return exceptionLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(exceptionLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayRequest)) {
            return false;
        }
        UpdateGatewayRequest other = (UpdateGatewayRequest) obj;
        return Objects.equals(gatewayIdentifier(), other.gatewayIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(protocolTypeAsString(), other.protocolTypeAsString())
                && Objects.equals(protocolConfiguration(), other.protocolConfiguration())
                && Objects.equals(authorizerTypeAsString(), other.authorizerTypeAsString())
                && Objects.equals(authorizerConfiguration(), other.authorizerConfiguration())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(exceptionLevelAsString(), other.exceptionLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGatewayRequest").add("GatewayIdentifier", gatewayIdentifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("RoleArn", roleArn())
                .add("ProtocolType", protocolTypeAsString()).add("ProtocolConfiguration", protocolConfiguration())
                .add("AuthorizerType", authorizerTypeAsString()).add("AuthorizerConfiguration", authorizerConfiguration())
                .add("KmsKeyArn", kmsKeyArn()).add("ExceptionLevel", exceptionLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayIdentifier":
            return Optional.ofNullable(clazz.cast(gatewayIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "protocolType":
            return Optional.ofNullable(clazz.cast(protocolTypeAsString()));
        case "protocolConfiguration":
            return Optional.ofNullable(clazz.cast(protocolConfiguration()));
        case "authorizerType":
            return Optional.ofNullable(clazz.cast(authorizerTypeAsString()));
        case "authorizerConfiguration":
            return Optional.ofNullable(clazz.cast(authorizerConfiguration()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "exceptionLevel":
            return Optional.ofNullable(clazz.cast(exceptionLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayIdentifier", GATEWAY_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("protocolType", PROTOCOL_TYPE_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("authorizerType", AUTHORIZER_TYPE_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("exceptionLevel", EXCEPTION_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayRequest, T> g) {
        return obj -> g.apply((UpdateGatewayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGatewayRequest> {
        /**
         * <p>
         * The identifier of the gateway to update. This can be either the gateway ID or the gateway ARN.
         * </p>
         * 
         * @param gatewayIdentifier
         *        The identifier of the gateway to update. This can be either the gateway ID or the gateway ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayIdentifier(String gatewayIdentifier);

        /**
         * <p>
         * The updated name for the Gateway.
         * </p>
         * 
         * @param name
         *        The updated name for the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated description for the Gateway.
         * </p>
         * 
         * @param description
         *        The updated description for the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated IAM role ARN that provides permissions for the Gateway.
         * </p>
         * 
         * @param roleArn
         *        The updated IAM role ARN that provides permissions for the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The updated protocol type for the Gateway.
         * </p>
         * 
         * @param protocolType
         *        The updated protocol type for the Gateway.
         * @see GatewayProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayProtocolType
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * The updated protocol type for the Gateway.
         * </p>
         * 
         * @param protocolType
         *        The updated protocol type for the Gateway.
         * @see GatewayProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayProtocolType
         */
        Builder protocolType(GatewayProtocolType protocolType);

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * @param protocolConfiguration
         *        The new value for the ProtocolConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfiguration(GatewayProtocolConfiguration protocolConfiguration);

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GatewayProtocolConfiguration.Builder}
         * avoiding the need to create one manually via {@link GatewayProtocolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayProtocolConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #protocolConfiguration(GatewayProtocolConfiguration)}.
         * 
         * @param protocolConfiguration
         *        a consumer that will call methods on {@link GatewayProtocolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolConfiguration(GatewayProtocolConfiguration)
         */
        default Builder protocolConfiguration(Consumer<GatewayProtocolConfiguration.Builder> protocolConfiguration) {
            return protocolConfiguration(GatewayProtocolConfiguration.builder().applyMutation(protocolConfiguration).build());
        }

        /**
         * <p>
         * The updated authorizer type for the Gateway.
         * </p>
         * 
         * @param authorizerType
         *        The updated authorizer type for the Gateway.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(String authorizerType);

        /**
         * <p>
         * The updated authorizer type for the Gateway.
         * </p>
         * 
         * @param authorizerType
         *        The updated authorizer type for the Gateway.
         * @see AuthorizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerType
         */
        Builder authorizerType(AuthorizerType authorizerType);

        /**
         * <p>
         * The updated authorizer configuration for the Gateway.
         * </p>
         * 
         * @param authorizerConfiguration
         *        The updated authorizer configuration for the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration);

        /**
         * <p>
         * The updated authorizer configuration for the Gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizerConfiguration.Builder} avoiding
         * the need to create one manually via {@link AuthorizerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizerConfiguration(AuthorizerConfiguration)}.
         * 
         * @param authorizerConfiguration
         *        a consumer that will call methods on {@link AuthorizerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfiguration(AuthorizerConfiguration)
         */
        default Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return authorizerConfiguration(AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration).build());
        }

        /**
         * <p>
         * The updated ARN of the KMS key used to encrypt the Gateway.
         * </p>
         * 
         * @param kmsKeyArn
         *        The updated ARN of the KMS key used to encrypt the Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
         * this parameter is not set, exception messages are by default sanitized for presentation to end users.
         * </p>
         * 
         * @param exceptionLevel
         *        The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway.
         *        If this parameter is not set, exception messages are by default sanitized for presentation to end
         *        users.
         * @see ExceptionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExceptionLevel
         */
        Builder exceptionLevel(String exceptionLevel);

        /**
         * <p>
         * The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway. If
         * this parameter is not set, exception messages are by default sanitized for presentation to end users.
         * </p>
         * 
         * @param exceptionLevel
         *        The verbosity of exception messages. Use DEBUG mode to see granular exception messages from a Gateway.
         *        If this parameter is not set, exception messages are by default sanitized for presentation to end
         *        users.
         * @see ExceptionLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExceptionLevel
         */
        Builder exceptionLevel(ExceptionLevel exceptionLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String gatewayIdentifier;

        private String name;

        private String description;

        private String roleArn;

        private String protocolType;

        private GatewayProtocolConfiguration protocolConfiguration;

        private String authorizerType;

        private AuthorizerConfiguration authorizerConfiguration;

        private String kmsKeyArn;

        private String exceptionLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayRequest model) {
            super(model);
            gatewayIdentifier(model.gatewayIdentifier);
            name(model.name);
            description(model.description);
            roleArn(model.roleArn);
            protocolType(model.protocolType);
            protocolConfiguration(model.protocolConfiguration);
            authorizerType(model.authorizerType);
            authorizerConfiguration(model.authorizerConfiguration);
            kmsKeyArn(model.kmsKeyArn);
            exceptionLevel(model.exceptionLevel);
        }

        public final String getGatewayIdentifier() {
            return gatewayIdentifier;
        }

        public final void setGatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
        }

        @Override
        public final Builder gatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getProtocolType() {
            return protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(GatewayProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final GatewayProtocolConfiguration.Builder getProtocolConfiguration() {
            return protocolConfiguration != null ? protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(GatewayProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(GatewayProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getAuthorizerType() {
            return authorizerType;
        }

        public final void setAuthorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
        }

        @Override
        public final Builder authorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        @Override
        public final Builder authorizerType(AuthorizerType authorizerType) {
            this.authorizerType(authorizerType == null ? null : authorizerType.toString());
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return authorizerConfiguration != null ? authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getExceptionLevel() {
            return exceptionLevel;
        }

        public final void setExceptionLevel(String exceptionLevel) {
            this.exceptionLevel = exceptionLevel;
        }

        @Override
        public final Builder exceptionLevel(String exceptionLevel) {
            this.exceptionLevel = exceptionLevel;
            return this;
        }

        @Override
        public final Builder exceptionLevel(ExceptionLevel exceptionLevel) {
            this.exceptionLevel(exceptionLevel == null ? null : exceptionLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayRequest build() {
            return new UpdateGatewayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
