/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for summary override configuration in a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SummaryOverrideConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<SummaryOverrideConfigurationInput.Builder, SummaryOverrideConfigurationInput> {
    private static final SdkField<SummaryOverrideConsolidationConfigurationInput> CONSOLIDATION_FIELD = SdkField
            .<SummaryOverrideConsolidationConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("consolidation")
            .getter(getter(SummaryOverrideConfigurationInput::consolidation)).setter(setter(Builder::consolidation))
            .constructor(SummaryOverrideConsolidationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSOLIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SummaryOverrideConsolidationConfigurationInput consolidation;

    private SummaryOverrideConfigurationInput(BuilderImpl builder) {
        this.consolidation = builder.consolidation;
    }

    /**
     * <p>
     * The consolidation configuration for a summary override.
     * </p>
     * 
     * @return The consolidation configuration for a summary override.
     */
    public final SummaryOverrideConsolidationConfigurationInput consolidation() {
        return consolidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consolidation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummaryOverrideConfigurationInput)) {
            return false;
        }
        SummaryOverrideConfigurationInput other = (SummaryOverrideConfigurationInput) obj;
        return Objects.equals(consolidation(), other.consolidation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SummaryOverrideConfigurationInput").add("Consolidation", consolidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consolidation":
            return Optional.ofNullable(clazz.cast(consolidation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consolidation", CONSOLIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SummaryOverrideConfigurationInput, T> g) {
        return obj -> g.apply((SummaryOverrideConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SummaryOverrideConfigurationInput> {
        /**
         * <p>
         * The consolidation configuration for a summary override.
         * </p>
         * 
         * @param consolidation
         *        The consolidation configuration for a summary override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consolidation(SummaryOverrideConsolidationConfigurationInput consolidation);

        /**
         * <p>
         * The consolidation configuration for a summary override.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SummaryOverrideConsolidationConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link SummaryOverrideConsolidationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummaryOverrideConsolidationConfigurationInput.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #consolidation(SummaryOverrideConsolidationConfigurationInput)}.
         * 
         * @param consolidation
         *        a consumer that will call methods on {@link SummaryOverrideConsolidationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consolidation(SummaryOverrideConsolidationConfigurationInput)
         */
        default Builder consolidation(Consumer<SummaryOverrideConsolidationConfigurationInput.Builder> consolidation) {
            return consolidation(SummaryOverrideConsolidationConfigurationInput.builder().applyMutation(consolidation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SummaryOverrideConsolidationConfigurationInput consolidation;

        private BuilderImpl() {
        }

        private BuilderImpl(SummaryOverrideConfigurationInput model) {
            consolidation(model.consolidation);
        }

        public final SummaryOverrideConsolidationConfigurationInput.Builder getConsolidation() {
            return consolidation != null ? consolidation.toBuilder() : null;
        }

        public final void setConsolidation(SummaryOverrideConsolidationConfigurationInput.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(SummaryOverrideConsolidationConfigurationInput consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        @Override
        public SummaryOverrideConfigurationInput build() {
            return new SummaryOverrideConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
