/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information for a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StrategyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StrategyConfiguration.Builder, StrategyConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(StrategyConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<ExtractionConfiguration> EXTRACTION_FIELD = SdkField
            .<ExtractionConfiguration> builder(MarshallingType.SDK_POJO).memberName("extraction")
            .getter(getter(StrategyConfiguration::extraction)).setter(setter(Builder::extraction))
            .constructor(ExtractionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()).build();

    private static final SdkField<ConsolidationConfiguration> CONSOLIDATION_FIELD = SdkField
            .<ConsolidationConfiguration> builder(MarshallingType.SDK_POJO).memberName("consolidation")
            .getter(getter(StrategyConfiguration::consolidation)).setter(setter(Builder::consolidation))
            .constructor(ConsolidationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EXTRACTION_FIELD,
            CONSOLIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final ExtractionConfiguration extraction;

    private final ConsolidationConfiguration consolidation;

    private StrategyConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.extraction = builder.extraction;
        this.consolidation = builder.consolidation;
    }

    /**
     * <p>
     * The type of override for the strategy configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OverrideType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of override for the strategy configuration.
     * @see OverrideType
     */
    public final OverrideType type() {
        return OverrideType.fromValue(type);
    }

    /**
     * <p>
     * The type of override for the strategy configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OverrideType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of override for the strategy configuration.
     * @see OverrideType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The extraction configuration for the memory strategy.
     * </p>
     * 
     * @return The extraction configuration for the memory strategy.
     */
    public final ExtractionConfiguration extraction() {
        return extraction;
    }

    /**
     * <p>
     * The consolidation configuration for the memory strategy.
     * </p>
     * 
     * @return The consolidation configuration for the memory strategy.
     */
    public final ConsolidationConfiguration consolidation() {
        return consolidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extraction());
        hashCode = 31 * hashCode + Objects.hashCode(consolidation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrategyConfiguration)) {
            return false;
        }
        StrategyConfiguration other = (StrategyConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(extraction(), other.extraction())
                && Objects.equals(consolidation(), other.consolidation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StrategyConfiguration").add("Type", typeAsString()).add("Extraction", extraction())
                .add("Consolidation", consolidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "extraction":
            return Optional.ofNullable(clazz.cast(extraction()));
        case "consolidation":
            return Optional.ofNullable(clazz.cast(consolidation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("extraction", EXTRACTION_FIELD);
        map.put("consolidation", CONSOLIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StrategyConfiguration, T> g) {
        return obj -> g.apply((StrategyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StrategyConfiguration> {
        /**
         * <p>
         * The type of override for the strategy configuration.
         * </p>
         * 
         * @param type
         *        The type of override for the strategy configuration.
         * @see OverrideType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of override for the strategy configuration.
         * </p>
         * 
         * @param type
         *        The type of override for the strategy configuration.
         * @see OverrideType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideType
         */
        Builder type(OverrideType type);

        /**
         * <p>
         * The extraction configuration for the memory strategy.
         * </p>
         * 
         * @param extraction
         *        The extraction configuration for the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraction(ExtractionConfiguration extraction);

        /**
         * <p>
         * The extraction configuration for the memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExtractionConfiguration.Builder} avoiding
         * the need to create one manually via {@link ExtractionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtractionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #extraction(ExtractionConfiguration)}.
         * 
         * @param extraction
         *        a consumer that will call methods on {@link ExtractionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraction(ExtractionConfiguration)
         */
        default Builder extraction(Consumer<ExtractionConfiguration.Builder> extraction) {
            return extraction(ExtractionConfiguration.builder().applyMutation(extraction).build());
        }

        /**
         * <p>
         * The consolidation configuration for the memory strategy.
         * </p>
         * 
         * @param consolidation
         *        The consolidation configuration for the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consolidation(ConsolidationConfiguration consolidation);

        /**
         * <p>
         * The consolidation configuration for the memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsolidationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ConsolidationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsolidationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #consolidation(ConsolidationConfiguration)}.
         * 
         * @param consolidation
         *        a consumer that will call methods on {@link ConsolidationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consolidation(ConsolidationConfiguration)
         */
        default Builder consolidation(Consumer<ConsolidationConfiguration.Builder> consolidation) {
            return consolidation(ConsolidationConfiguration.builder().applyMutation(consolidation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private ExtractionConfiguration extraction;

        private ConsolidationConfiguration consolidation;

        private BuilderImpl() {
        }

        private BuilderImpl(StrategyConfiguration model) {
            type(model.type);
            extraction(model.extraction);
            consolidation(model.consolidation);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OverrideType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ExtractionConfiguration.Builder getExtraction() {
            return extraction != null ? extraction.toBuilder() : null;
        }

        public final void setExtraction(ExtractionConfiguration.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(ExtractionConfiguration extraction) {
            this.extraction = extraction;
            return this;
        }

        public final ConsolidationConfiguration.Builder getConsolidation() {
            return consolidation != null ? consolidation.toBuilder() : null;
        }

        public final void setConsolidation(ConsolidationConfiguration.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(ConsolidationConfiguration consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        @Override
        public StrategyConfiguration build() {
            return new StrategyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
