/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output configuration for a Slack OAuth2 provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlackOauth2ProviderConfigOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<SlackOauth2ProviderConfigOutput.Builder, SlackOauth2ProviderConfigOutput> {
    private static final SdkField<Oauth2Discovery> OAUTH_DISCOVERY_FIELD = SdkField
            .<Oauth2Discovery> builder(MarshallingType.SDK_POJO).memberName("oauthDiscovery")
            .getter(getter(SlackOauth2ProviderConfigOutput::oauthDiscovery)).setter(setter(Builder::oauthDiscovery))
            .constructor(Oauth2Discovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthDiscovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OAUTH_DISCOVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Oauth2Discovery oauthDiscovery;

    private SlackOauth2ProviderConfigOutput(BuilderImpl builder) {
        this.oauthDiscovery = builder.oauthDiscovery;
    }

    /**
     * <p>
     * The OAuth2 discovery information for the Slack provider.
     * </p>
     * 
     * @return The OAuth2 discovery information for the Slack provider.
     */
    public final Oauth2Discovery oauthDiscovery() {
        return oauthDiscovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oauthDiscovery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackOauth2ProviderConfigOutput)) {
            return false;
        }
        SlackOauth2ProviderConfigOutput other = (SlackOauth2ProviderConfigOutput) obj;
        return Objects.equals(oauthDiscovery(), other.oauthDiscovery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlackOauth2ProviderConfigOutput").add("OauthDiscovery", oauthDiscovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oauthDiscovery":
            return Optional.ofNullable(clazz.cast(oauthDiscovery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("oauthDiscovery", OAUTH_DISCOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlackOauth2ProviderConfigOutput, T> g) {
        return obj -> g.apply((SlackOauth2ProviderConfigOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlackOauth2ProviderConfigOutput> {
        /**
         * <p>
         * The OAuth2 discovery information for the Slack provider.
         * </p>
         * 
         * @param oauthDiscovery
         *        The OAuth2 discovery information for the Slack provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthDiscovery(Oauth2Discovery oauthDiscovery);

        /**
         * <p>
         * The OAuth2 discovery information for the Slack provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link Oauth2Discovery.Builder} avoiding the
         * need to create one manually via {@link Oauth2Discovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Oauth2Discovery.Builder#build()} is called immediately and its
         * result is passed to {@link #oauthDiscovery(Oauth2Discovery)}.
         * 
         * @param oauthDiscovery
         *        a consumer that will call methods on {@link Oauth2Discovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oauthDiscovery(Oauth2Discovery)
         */
        default Builder oauthDiscovery(Consumer<Oauth2Discovery.Builder> oauthDiscovery) {
            return oauthDiscovery(Oauth2Discovery.builder().applyMutation(oauthDiscovery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Oauth2Discovery oauthDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(SlackOauth2ProviderConfigOutput model) {
            oauthDiscovery(model.oauthDiscovery);
        }

        public final Oauth2Discovery.Builder getOauthDiscovery() {
            return oauthDiscovery != null ? oauthDiscovery.toBuilder() : null;
        }

        public final void setOauthDiscovery(Oauth2Discovery.BuilderImpl oauthDiscovery) {
            this.oauthDiscovery = oauthDiscovery != null ? oauthDiscovery.build() : null;
        }

        @Override
        public final Builder oauthDiscovery(Oauth2Discovery oauthDiscovery) {
            this.oauthDiscovery = oauthDiscovery;
            return this;
        }

        @Override
        public SlackOauth2ProviderConfigOutput build() {
            return new SlackOauth2ProviderConfigOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
