/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A schema definition for a gateway target. This structure defines the structure of the API that the target exposes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaDefinition.Builder, SchemaDefinition> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SchemaDefinition::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Map<String, SchemaDefinition>> PROPERTIES_FIELD = SdkField
            .<Map<String, SchemaDefinition>> builder(MarshallingType.MAP)
            .memberName("properties")
            .getter(getter(SchemaDefinition::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SchemaDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> REQUIRED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("required")
            .getter(getter(SchemaDefinition::required))
            .setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SchemaDefinition> ITEMS_FIELD = SdkField.<SchemaDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("items").getter(getter(SchemaDefinition::items)).setter(setter(Builder::items))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SchemaDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PROPERTIES_FIELD,
            REQUIRED_FIELD, ITEMS_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Map<String, SchemaDefinition> properties;

    private final List<String> required;

    private final SchemaDefinition items;

    private final String description;

    private SchemaDefinition(BuilderImpl builder) {
        this.type = builder.type;
        this.properties = builder.properties;
        this.required = builder.required;
        this.items = builder.items;
        this.description = builder.description;
    }

    /**
     * <p>
     * The type of the schema definition. This field specifies the data type of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the schema definition. This field specifies the data type of the schema.
     * @see SchemaType
     */
    public final SchemaType type() {
        return SchemaType.fromValue(type);
    }

    /**
     * <p>
     * The type of the schema definition. This field specifies the data type of the schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the schema definition. This field specifies the data type of the schema.
     * @see SchemaType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The properties of the schema definition. These properties define the fields in the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The properties of the schema definition. These properties define the fields in the schema.
     */
    public final Map<String, SchemaDefinition> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Required property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRequired() {
        return required != null && !(required instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The required fields in the schema definition. These fields must be provided when using the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequired} method.
     * </p>
     * 
     * @return The required fields in the schema definition. These fields must be provided when using the schema.
     */
    public final List<String> required() {
        return required;
    }

    /**
     * <p>
     * The items in the schema definition. This field is used for array types to define the structure of the array
     * elements.
     * </p>
     * 
     * @return The items in the schema definition. This field is used for array types to define the structure of the
     *         array elements.
     */
    public final SchemaDefinition items() {
        return items;
    }

    /**
     * <p>
     * The description of the schema definition. This description provides information about the purpose and usage of
     * the schema.
     * </p>
     * 
     * @return The description of the schema definition. This description provides information about the purpose and
     *         usage of the schema.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRequired() ? required() : null);
        hashCode = 31 * hashCode + Objects.hashCode(items());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties()) && hasRequired() == other.hasRequired()
                && Objects.equals(required(), other.required()) && Objects.equals(items(), other.items())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaDefinition").add("Type", typeAsString())
                .add("Properties", hasProperties() ? properties() : null).add("Required", hasRequired() ? required() : null)
                .add("Items", items()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("required", REQUIRED_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaDefinition> {
        /**
         * <p>
         * The type of the schema definition. This field specifies the data type of the schema.
         * </p>
         * 
         * @param type
         *        The type of the schema definition. This field specifies the data type of the schema.
         * @see SchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the schema definition. This field specifies the data type of the schema.
         * </p>
         * 
         * @param type
         *        The type of the schema definition. This field specifies the data type of the schema.
         * @see SchemaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaType
         */
        Builder type(SchemaType type);

        /**
         * <p>
         * The properties of the schema definition. These properties define the fields in the schema.
         * </p>
         * 
         * @param properties
         *        The properties of the schema definition. These properties define the fields in the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, SchemaDefinition> properties);

        /**
         * <p>
         * The required fields in the schema definition. These fields must be provided when using the schema.
         * </p>
         * 
         * @param required
         *        The required fields in the schema definition. These fields must be provided when using the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Collection<String> required);

        /**
         * <p>
         * The required fields in the schema definition. These fields must be provided when using the schema.
         * </p>
         * 
         * @param required
         *        The required fields in the schema definition. These fields must be provided when using the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(String... required);

        /**
         * <p>
         * The items in the schema definition. This field is used for array types to define the structure of the array
         * elements.
         * </p>
         * 
         * @param items
         *        The items in the schema definition. This field is used for array types to define the structure of the
         *        array elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(SchemaDefinition items);

        /**
         * <p>
         * The items in the schema definition. This field is used for array types to define the structure of the array
         * elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #items(SchemaDefinition)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(SchemaDefinition)
         */
        default Builder items(Consumer<Builder> items) {
            return items(SchemaDefinition.builder().applyMutation(items).build());
        }

        /**
         * <p>
         * The description of the schema definition. This description provides information about the purpose and usage
         * of the schema.
         * </p>
         * 
         * @param description
         *        The description of the schema definition. This description provides information about the purpose and
         *        usage of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Map<String, SchemaDefinition> properties = DefaultSdkAutoConstructMap.getInstance();

        private List<String> required = DefaultSdkAutoConstructList.getInstance();

        private SchemaDefinition items;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            type(model.type);
            properties(model.properties);
            required(model.required);
            items(model.items);
            description(model.description);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Map<String, Builder> getProperties() {
            Map<String, Builder> result = SchemaPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, BuilderImpl> properties) {
            this.properties = SchemaPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, SchemaDefinition> properties) {
            this.properties = SchemaPropertiesCopier.copy(properties);
            return this;
        }

        public final Collection<String> getRequired() {
            if (required instanceof SdkAutoConstructList) {
                return null;
            }
            return required;
        }

        public final void setRequired(Collection<String> required) {
            this.required = RequiredPropertiesCopier.copy(required);
        }

        @Override
        public final Builder required(Collection<String> required) {
            this.required = RequiredPropertiesCopier.copy(required);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder required(String... required) {
            required(Arrays.asList(required));
            return this;
        }

        public final Builder getItems() {
            return items != null ? items.toBuilder() : null;
        }

        public final void setItems(BuilderImpl items) {
            this.items = items != null ? items.build() : null;
        }

        @Override
        public final Builder items(SchemaDefinition items) {
            this.items = items;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
