/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output configuration for an OAuth2 provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Oauth2ProviderConfigOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<Oauth2ProviderConfigOutput.Builder, Oauth2ProviderConfigOutput> {
    private static final SdkField<CustomOauth2ProviderConfigOutput> CUSTOM_OAUTH2_PROVIDER_CONFIG_FIELD = SdkField
            .<CustomOauth2ProviderConfigOutput> builder(MarshallingType.SDK_POJO)
            .memberName("customOauth2ProviderConfig")
            .getter(getter(Oauth2ProviderConfigOutput::customOauth2ProviderConfig))
            .setter(setter(Builder::customOauth2ProviderConfig))
            .constructor(CustomOauth2ProviderConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOauth2ProviderConfig").build())
            .build();

    private static final SdkField<GoogleOauth2ProviderConfigOutput> GOOGLE_OAUTH2_PROVIDER_CONFIG_FIELD = SdkField
            .<GoogleOauth2ProviderConfigOutput> builder(MarshallingType.SDK_POJO)
            .memberName("googleOauth2ProviderConfig")
            .getter(getter(Oauth2ProviderConfigOutput::googleOauth2ProviderConfig))
            .setter(setter(Builder::googleOauth2ProviderConfig))
            .constructor(GoogleOauth2ProviderConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("googleOauth2ProviderConfig").build())
            .build();

    private static final SdkField<GithubOauth2ProviderConfigOutput> GITHUB_OAUTH2_PROVIDER_CONFIG_FIELD = SdkField
            .<GithubOauth2ProviderConfigOutput> builder(MarshallingType.SDK_POJO)
            .memberName("githubOauth2ProviderConfig")
            .getter(getter(Oauth2ProviderConfigOutput::githubOauth2ProviderConfig))
            .setter(setter(Builder::githubOauth2ProviderConfig))
            .constructor(GithubOauth2ProviderConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("githubOauth2ProviderConfig").build())
            .build();

    private static final SdkField<SlackOauth2ProviderConfigOutput> SLACK_OAUTH2_PROVIDER_CONFIG_FIELD = SdkField
            .<SlackOauth2ProviderConfigOutput> builder(MarshallingType.SDK_POJO).memberName("slackOauth2ProviderConfig")
            .getter(getter(Oauth2ProviderConfigOutput::slackOauth2ProviderConfig))
            .setter(setter(Builder::slackOauth2ProviderConfig)).constructor(SlackOauth2ProviderConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slackOauth2ProviderConfig").build())
            .build();

    private static final SdkField<SalesforceOauth2ProviderConfigOutput> SALESFORCE_OAUTH2_PROVIDER_CONFIG_FIELD = SdkField
            .<SalesforceOauth2ProviderConfigOutput> builder(MarshallingType.SDK_POJO)
            .memberName("salesforceOauth2ProviderConfig")
            .getter(getter(Oauth2ProviderConfigOutput::salesforceOauth2ProviderConfig))
            .setter(setter(Builder::salesforceOauth2ProviderConfig))
            .constructor(SalesforceOauth2ProviderConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforceOauth2ProviderConfig")
                    .build()).build();

    private static final SdkField<MicrosoftOauth2ProviderConfigOutput> MICROSOFT_OAUTH2_PROVIDER_CONFIG_FIELD = SdkField
            .<MicrosoftOauth2ProviderConfigOutput> builder(MarshallingType.SDK_POJO)
            .memberName("microsoftOauth2ProviderConfig")
            .getter(getter(Oauth2ProviderConfigOutput::microsoftOauth2ProviderConfig))
            .setter(setter(Builder::microsoftOauth2ProviderConfig))
            .constructor(MicrosoftOauth2ProviderConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("microsoftOauth2ProviderConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_OAUTH2_PROVIDER_CONFIG_FIELD, GOOGLE_OAUTH2_PROVIDER_CONFIG_FIELD, GITHUB_OAUTH2_PROVIDER_CONFIG_FIELD,
            SLACK_OAUTH2_PROVIDER_CONFIG_FIELD, SALESFORCE_OAUTH2_PROVIDER_CONFIG_FIELD, MICROSOFT_OAUTH2_PROVIDER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomOauth2ProviderConfigOutput customOauth2ProviderConfig;

    private final GoogleOauth2ProviderConfigOutput googleOauth2ProviderConfig;

    private final GithubOauth2ProviderConfigOutput githubOauth2ProviderConfig;

    private final SlackOauth2ProviderConfigOutput slackOauth2ProviderConfig;

    private final SalesforceOauth2ProviderConfigOutput salesforceOauth2ProviderConfig;

    private final MicrosoftOauth2ProviderConfigOutput microsoftOauth2ProviderConfig;

    private final Type type;

    private Oauth2ProviderConfigOutput(BuilderImpl builder) {
        this.customOauth2ProviderConfig = builder.customOauth2ProviderConfig;
        this.googleOauth2ProviderConfig = builder.googleOauth2ProviderConfig;
        this.githubOauth2ProviderConfig = builder.githubOauth2ProviderConfig;
        this.slackOauth2ProviderConfig = builder.slackOauth2ProviderConfig;
        this.salesforceOauth2ProviderConfig = builder.salesforceOauth2ProviderConfig;
        this.microsoftOauth2ProviderConfig = builder.microsoftOauth2ProviderConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * The output configuration for a custom OAuth2 provider.
     * </p>
     * 
     * @return The output configuration for a custom OAuth2 provider.
     */
    public final CustomOauth2ProviderConfigOutput customOauth2ProviderConfig() {
        return customOauth2ProviderConfig;
    }

    /**
     * <p>
     * The output configuration for a Google OAuth2 provider.
     * </p>
     * 
     * @return The output configuration for a Google OAuth2 provider.
     */
    public final GoogleOauth2ProviderConfigOutput googleOauth2ProviderConfig() {
        return googleOauth2ProviderConfig;
    }

    /**
     * <p>
     * The output configuration for a GitHub OAuth2 provider.
     * </p>
     * 
     * @return The output configuration for a GitHub OAuth2 provider.
     */
    public final GithubOauth2ProviderConfigOutput githubOauth2ProviderConfig() {
        return githubOauth2ProviderConfig;
    }

    /**
     * <p>
     * The output configuration for a Slack OAuth2 provider.
     * </p>
     * 
     * @return The output configuration for a Slack OAuth2 provider.
     */
    public final SlackOauth2ProviderConfigOutput slackOauth2ProviderConfig() {
        return slackOauth2ProviderConfig;
    }

    /**
     * <p>
     * The output configuration for a Salesforce OAuth2 provider.
     * </p>
     * 
     * @return The output configuration for a Salesforce OAuth2 provider.
     */
    public final SalesforceOauth2ProviderConfigOutput salesforceOauth2ProviderConfig() {
        return salesforceOauth2ProviderConfig;
    }

    /**
     * <p>
     * The output configuration for a Microsoft OAuth2 provider.
     * </p>
     * 
     * @return The output configuration for a Microsoft OAuth2 provider.
     */
    public final MicrosoftOauth2ProviderConfigOutput microsoftOauth2ProviderConfig() {
        return microsoftOauth2ProviderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customOauth2ProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(googleOauth2ProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(githubOauth2ProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(slackOauth2ProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(salesforceOauth2ProviderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(microsoftOauth2ProviderConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Oauth2ProviderConfigOutput)) {
            return false;
        }
        Oauth2ProviderConfigOutput other = (Oauth2ProviderConfigOutput) obj;
        return Objects.equals(customOauth2ProviderConfig(), other.customOauth2ProviderConfig())
                && Objects.equals(googleOauth2ProviderConfig(), other.googleOauth2ProviderConfig())
                && Objects.equals(githubOauth2ProviderConfig(), other.githubOauth2ProviderConfig())
                && Objects.equals(slackOauth2ProviderConfig(), other.slackOauth2ProviderConfig())
                && Objects.equals(salesforceOauth2ProviderConfig(), other.salesforceOauth2ProviderConfig())
                && Objects.equals(microsoftOauth2ProviderConfig(), other.microsoftOauth2ProviderConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Oauth2ProviderConfigOutput").add("CustomOauth2ProviderConfig", customOauth2ProviderConfig())
                .add("GoogleOauth2ProviderConfig", googleOauth2ProviderConfig())
                .add("GithubOauth2ProviderConfig", githubOauth2ProviderConfig())
                .add("SlackOauth2ProviderConfig", slackOauth2ProviderConfig())
                .add("SalesforceOauth2ProviderConfig", salesforceOauth2ProviderConfig())
                .add("MicrosoftOauth2ProviderConfig", microsoftOauth2ProviderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customOauth2ProviderConfig":
            return Optional.ofNullable(clazz.cast(customOauth2ProviderConfig()));
        case "googleOauth2ProviderConfig":
            return Optional.ofNullable(clazz.cast(googleOauth2ProviderConfig()));
        case "githubOauth2ProviderConfig":
            return Optional.ofNullable(clazz.cast(githubOauth2ProviderConfig()));
        case "slackOauth2ProviderConfig":
            return Optional.ofNullable(clazz.cast(slackOauth2ProviderConfig()));
        case "salesforceOauth2ProviderConfig":
            return Optional.ofNullable(clazz.cast(salesforceOauth2ProviderConfig()));
        case "microsoftOauth2ProviderConfig":
            return Optional.ofNullable(clazz.cast(microsoftOauth2ProviderConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a custom OAuth2 provider.
     * </p>
     * 
     * @param customOauth2ProviderConfig
     *        The output configuration for a custom OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromCustomOauth2ProviderConfig(
            CustomOauth2ProviderConfigOutput customOauth2ProviderConfig) {
        return builder().customOauth2ProviderConfig(customOauth2ProviderConfig).build();
    }

    /**
     * Create an instance of this class with {@link #customOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a custom OAuth2 provider.
     * </p>
     * 
     * @param customOauth2ProviderConfig
     *        The output configuration for a custom OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromCustomOauth2ProviderConfig(
            Consumer<CustomOauth2ProviderConfigOutput.Builder> customOauth2ProviderConfig) {
        CustomOauth2ProviderConfigOutput.Builder builder = CustomOauth2ProviderConfigOutput.builder();
        customOauth2ProviderConfig.accept(builder);
        return fromCustomOauth2ProviderConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #googleOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Google OAuth2 provider.
     * </p>
     * 
     * @param googleOauth2ProviderConfig
     *        The output configuration for a Google OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromGoogleOauth2ProviderConfig(
            GoogleOauth2ProviderConfigOutput googleOauth2ProviderConfig) {
        return builder().googleOauth2ProviderConfig(googleOauth2ProviderConfig).build();
    }

    /**
     * Create an instance of this class with {@link #googleOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Google OAuth2 provider.
     * </p>
     * 
     * @param googleOauth2ProviderConfig
     *        The output configuration for a Google OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromGoogleOauth2ProviderConfig(
            Consumer<GoogleOauth2ProviderConfigOutput.Builder> googleOauth2ProviderConfig) {
        GoogleOauth2ProviderConfigOutput.Builder builder = GoogleOauth2ProviderConfigOutput.builder();
        googleOauth2ProviderConfig.accept(builder);
        return fromGoogleOauth2ProviderConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #githubOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a GitHub OAuth2 provider.
     * </p>
     * 
     * @param githubOauth2ProviderConfig
     *        The output configuration for a GitHub OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromGithubOauth2ProviderConfig(
            GithubOauth2ProviderConfigOutput githubOauth2ProviderConfig) {
        return builder().githubOauth2ProviderConfig(githubOauth2ProviderConfig).build();
    }

    /**
     * Create an instance of this class with {@link #githubOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a GitHub OAuth2 provider.
     * </p>
     * 
     * @param githubOauth2ProviderConfig
     *        The output configuration for a GitHub OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromGithubOauth2ProviderConfig(
            Consumer<GithubOauth2ProviderConfigOutput.Builder> githubOauth2ProviderConfig) {
        GithubOauth2ProviderConfigOutput.Builder builder = GithubOauth2ProviderConfigOutput.builder();
        githubOauth2ProviderConfig.accept(builder);
        return fromGithubOauth2ProviderConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #slackOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Slack OAuth2 provider.
     * </p>
     * 
     * @param slackOauth2ProviderConfig
     *        The output configuration for a Slack OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromSlackOauth2ProviderConfig(
            SlackOauth2ProviderConfigOutput slackOauth2ProviderConfig) {
        return builder().slackOauth2ProviderConfig(slackOauth2ProviderConfig).build();
    }

    /**
     * Create an instance of this class with {@link #slackOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Slack OAuth2 provider.
     * </p>
     * 
     * @param slackOauth2ProviderConfig
     *        The output configuration for a Slack OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromSlackOauth2ProviderConfig(
            Consumer<SlackOauth2ProviderConfigOutput.Builder> slackOauth2ProviderConfig) {
        SlackOauth2ProviderConfigOutput.Builder builder = SlackOauth2ProviderConfigOutput.builder();
        slackOauth2ProviderConfig.accept(builder);
        return fromSlackOauth2ProviderConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #salesforceOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Salesforce OAuth2 provider.
     * </p>
     * 
     * @param salesforceOauth2ProviderConfig
     *        The output configuration for a Salesforce OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromSalesforceOauth2ProviderConfig(
            SalesforceOauth2ProviderConfigOutput salesforceOauth2ProviderConfig) {
        return builder().salesforceOauth2ProviderConfig(salesforceOauth2ProviderConfig).build();
    }

    /**
     * Create an instance of this class with {@link #salesforceOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Salesforce OAuth2 provider.
     * </p>
     * 
     * @param salesforceOauth2ProviderConfig
     *        The output configuration for a Salesforce OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromSalesforceOauth2ProviderConfig(
            Consumer<SalesforceOauth2ProviderConfigOutput.Builder> salesforceOauth2ProviderConfig) {
        SalesforceOauth2ProviderConfigOutput.Builder builder = SalesforceOauth2ProviderConfigOutput.builder();
        salesforceOauth2ProviderConfig.accept(builder);
        return fromSalesforceOauth2ProviderConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #microsoftOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Microsoft OAuth2 provider.
     * </p>
     * 
     * @param microsoftOauth2ProviderConfig
     *        The output configuration for a Microsoft OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromMicrosoftOauth2ProviderConfig(
            MicrosoftOauth2ProviderConfigOutput microsoftOauth2ProviderConfig) {
        return builder().microsoftOauth2ProviderConfig(microsoftOauth2ProviderConfig).build();
    }

    /**
     * Create an instance of this class with {@link #microsoftOauth2ProviderConfig()} initialized to the given value.
     *
     * <p>
     * The output configuration for a Microsoft OAuth2 provider.
     * </p>
     * 
     * @param microsoftOauth2ProviderConfig
     *        The output configuration for a Microsoft OAuth2 provider.
     */
    public static Oauth2ProviderConfigOutput fromMicrosoftOauth2ProviderConfig(
            Consumer<MicrosoftOauth2ProviderConfigOutput.Builder> microsoftOauth2ProviderConfig) {
        MicrosoftOauth2ProviderConfigOutput.Builder builder = MicrosoftOauth2ProviderConfigOutput.builder();
        microsoftOauth2ProviderConfig.accept(builder);
        return fromMicrosoftOauth2ProviderConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customOauth2ProviderConfig", CUSTOM_OAUTH2_PROVIDER_CONFIG_FIELD);
        map.put("googleOauth2ProviderConfig", GOOGLE_OAUTH2_PROVIDER_CONFIG_FIELD);
        map.put("githubOauth2ProviderConfig", GITHUB_OAUTH2_PROVIDER_CONFIG_FIELD);
        map.put("slackOauth2ProviderConfig", SLACK_OAUTH2_PROVIDER_CONFIG_FIELD);
        map.put("salesforceOauth2ProviderConfig", SALESFORCE_OAUTH2_PROVIDER_CONFIG_FIELD);
        map.put("microsoftOauth2ProviderConfig", MICROSOFT_OAUTH2_PROVIDER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Oauth2ProviderConfigOutput, T> g) {
        return obj -> g.apply((Oauth2ProviderConfigOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Oauth2ProviderConfigOutput> {
        /**
         * <p>
         * The output configuration for a custom OAuth2 provider.
         * </p>
         * 
         * @param customOauth2ProviderConfig
         *        The output configuration for a custom OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customOauth2ProviderConfig(CustomOauth2ProviderConfigOutput customOauth2ProviderConfig);

        /**
         * <p>
         * The output configuration for a custom OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomOauth2ProviderConfigOutput.Builder}
         * avoiding the need to create one manually via {@link CustomOauth2ProviderConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomOauth2ProviderConfigOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #customOauth2ProviderConfig(CustomOauth2ProviderConfigOutput)}.
         * 
         * @param customOauth2ProviderConfig
         *        a consumer that will call methods on {@link CustomOauth2ProviderConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customOauth2ProviderConfig(CustomOauth2ProviderConfigOutput)
         */
        default Builder customOauth2ProviderConfig(Consumer<CustomOauth2ProviderConfigOutput.Builder> customOauth2ProviderConfig) {
            return customOauth2ProviderConfig(CustomOauth2ProviderConfigOutput.builder()
                    .applyMutation(customOauth2ProviderConfig).build());
        }

        /**
         * <p>
         * The output configuration for a Google OAuth2 provider.
         * </p>
         * 
         * @param googleOauth2ProviderConfig
         *        The output configuration for a Google OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder googleOauth2ProviderConfig(GoogleOauth2ProviderConfigOutput googleOauth2ProviderConfig);

        /**
         * <p>
         * The output configuration for a Google OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link GoogleOauth2ProviderConfigOutput.Builder}
         * avoiding the need to create one manually via {@link GoogleOauth2ProviderConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GoogleOauth2ProviderConfigOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #googleOauth2ProviderConfig(GoogleOauth2ProviderConfigOutput)}.
         * 
         * @param googleOauth2ProviderConfig
         *        a consumer that will call methods on {@link GoogleOauth2ProviderConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #googleOauth2ProviderConfig(GoogleOauth2ProviderConfigOutput)
         */
        default Builder googleOauth2ProviderConfig(Consumer<GoogleOauth2ProviderConfigOutput.Builder> googleOauth2ProviderConfig) {
            return googleOauth2ProviderConfig(GoogleOauth2ProviderConfigOutput.builder()
                    .applyMutation(googleOauth2ProviderConfig).build());
        }

        /**
         * <p>
         * The output configuration for a GitHub OAuth2 provider.
         * </p>
         * 
         * @param githubOauth2ProviderConfig
         *        The output configuration for a GitHub OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder githubOauth2ProviderConfig(GithubOauth2ProviderConfigOutput githubOauth2ProviderConfig);

        /**
         * <p>
         * The output configuration for a GitHub OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link GithubOauth2ProviderConfigOutput.Builder}
         * avoiding the need to create one manually via {@link GithubOauth2ProviderConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GithubOauth2ProviderConfigOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #githubOauth2ProviderConfig(GithubOauth2ProviderConfigOutput)}.
         * 
         * @param githubOauth2ProviderConfig
         *        a consumer that will call methods on {@link GithubOauth2ProviderConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #githubOauth2ProviderConfig(GithubOauth2ProviderConfigOutput)
         */
        default Builder githubOauth2ProviderConfig(Consumer<GithubOauth2ProviderConfigOutput.Builder> githubOauth2ProviderConfig) {
            return githubOauth2ProviderConfig(GithubOauth2ProviderConfigOutput.builder()
                    .applyMutation(githubOauth2ProviderConfig).build());
        }

        /**
         * <p>
         * The output configuration for a Slack OAuth2 provider.
         * </p>
         * 
         * @param slackOauth2ProviderConfig
         *        The output configuration for a Slack OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackOauth2ProviderConfig(SlackOauth2ProviderConfigOutput slackOauth2ProviderConfig);

        /**
         * <p>
         * The output configuration for a Slack OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlackOauth2ProviderConfigOutput.Builder}
         * avoiding the need to create one manually via {@link SlackOauth2ProviderConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlackOauth2ProviderConfigOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #slackOauth2ProviderConfig(SlackOauth2ProviderConfigOutput)}.
         * 
         * @param slackOauth2ProviderConfig
         *        a consumer that will call methods on {@link SlackOauth2ProviderConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slackOauth2ProviderConfig(SlackOauth2ProviderConfigOutput)
         */
        default Builder slackOauth2ProviderConfig(Consumer<SlackOauth2ProviderConfigOutput.Builder> slackOauth2ProviderConfig) {
            return slackOauth2ProviderConfig(SlackOauth2ProviderConfigOutput.builder().applyMutation(slackOauth2ProviderConfig)
                    .build());
        }

        /**
         * <p>
         * The output configuration for a Salesforce OAuth2 provider.
         * </p>
         * 
         * @param salesforceOauth2ProviderConfig
         *        The output configuration for a Salesforce OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforceOauth2ProviderConfig(SalesforceOauth2ProviderConfigOutput salesforceOauth2ProviderConfig);

        /**
         * <p>
         * The output configuration for a Salesforce OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SalesforceOauth2ProviderConfigOutput.Builder} avoiding the need to create one manually via
         * {@link SalesforceOauth2ProviderConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SalesforceOauth2ProviderConfigOutput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #salesforceOauth2ProviderConfig(SalesforceOauth2ProviderConfigOutput)}.
         * 
         * @param salesforceOauth2ProviderConfig
         *        a consumer that will call methods on {@link SalesforceOauth2ProviderConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforceOauth2ProviderConfig(SalesforceOauth2ProviderConfigOutput)
         */
        default Builder salesforceOauth2ProviderConfig(
                Consumer<SalesforceOauth2ProviderConfigOutput.Builder> salesforceOauth2ProviderConfig) {
            return salesforceOauth2ProviderConfig(SalesforceOauth2ProviderConfigOutput.builder()
                    .applyMutation(salesforceOauth2ProviderConfig).build());
        }

        /**
         * <p>
         * The output configuration for a Microsoft OAuth2 provider.
         * </p>
         * 
         * @param microsoftOauth2ProviderConfig
         *        The output configuration for a Microsoft OAuth2 provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microsoftOauth2ProviderConfig(MicrosoftOauth2ProviderConfigOutput microsoftOauth2ProviderConfig);

        /**
         * <p>
         * The output configuration for a Microsoft OAuth2 provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MicrosoftOauth2ProviderConfigOutput.Builder} avoiding the need to create one manually via
         * {@link MicrosoftOauth2ProviderConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MicrosoftOauth2ProviderConfigOutput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #microsoftOauth2ProviderConfig(MicrosoftOauth2ProviderConfigOutput)}.
         * 
         * @param microsoftOauth2ProviderConfig
         *        a consumer that will call methods on {@link MicrosoftOauth2ProviderConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #microsoftOauth2ProviderConfig(MicrosoftOauth2ProviderConfigOutput)
         */
        default Builder microsoftOauth2ProviderConfig(
                Consumer<MicrosoftOauth2ProviderConfigOutput.Builder> microsoftOauth2ProviderConfig) {
            return microsoftOauth2ProviderConfig(MicrosoftOauth2ProviderConfigOutput.builder()
                    .applyMutation(microsoftOauth2ProviderConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomOauth2ProviderConfigOutput customOauth2ProviderConfig;

        private GoogleOauth2ProviderConfigOutput googleOauth2ProviderConfig;

        private GithubOauth2ProviderConfigOutput githubOauth2ProviderConfig;

        private SlackOauth2ProviderConfigOutput slackOauth2ProviderConfig;

        private SalesforceOauth2ProviderConfigOutput salesforceOauth2ProviderConfig;

        private MicrosoftOauth2ProviderConfigOutput microsoftOauth2ProviderConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Oauth2ProviderConfigOutput model) {
            customOauth2ProviderConfig(model.customOauth2ProviderConfig);
            googleOauth2ProviderConfig(model.googleOauth2ProviderConfig);
            githubOauth2ProviderConfig(model.githubOauth2ProviderConfig);
            slackOauth2ProviderConfig(model.slackOauth2ProviderConfig);
            salesforceOauth2ProviderConfig(model.salesforceOauth2ProviderConfig);
            microsoftOauth2ProviderConfig(model.microsoftOauth2ProviderConfig);
        }

        public final CustomOauth2ProviderConfigOutput.Builder getCustomOauth2ProviderConfig() {
            return customOauth2ProviderConfig != null ? customOauth2ProviderConfig.toBuilder() : null;
        }

        public final void setCustomOauth2ProviderConfig(CustomOauth2ProviderConfigOutput.BuilderImpl customOauth2ProviderConfig) {
            Object oldValue = this.customOauth2ProviderConfig;
            this.customOauth2ProviderConfig = customOauth2ProviderConfig != null ? customOauth2ProviderConfig.build() : null;
            handleUnionValueChange(Type.CUSTOM_OAUTH2_PROVIDER_CONFIG, oldValue, this.customOauth2ProviderConfig);
        }

        @Override
        public final Builder customOauth2ProviderConfig(CustomOauth2ProviderConfigOutput customOauth2ProviderConfig) {
            Object oldValue = this.customOauth2ProviderConfig;
            this.customOauth2ProviderConfig = customOauth2ProviderConfig;
            handleUnionValueChange(Type.CUSTOM_OAUTH2_PROVIDER_CONFIG, oldValue, this.customOauth2ProviderConfig);
            return this;
        }

        public final GoogleOauth2ProviderConfigOutput.Builder getGoogleOauth2ProviderConfig() {
            return googleOauth2ProviderConfig != null ? googleOauth2ProviderConfig.toBuilder() : null;
        }

        public final void setGoogleOauth2ProviderConfig(GoogleOauth2ProviderConfigOutput.BuilderImpl googleOauth2ProviderConfig) {
            Object oldValue = this.googleOauth2ProviderConfig;
            this.googleOauth2ProviderConfig = googleOauth2ProviderConfig != null ? googleOauth2ProviderConfig.build() : null;
            handleUnionValueChange(Type.GOOGLE_OAUTH2_PROVIDER_CONFIG, oldValue, this.googleOauth2ProviderConfig);
        }

        @Override
        public final Builder googleOauth2ProviderConfig(GoogleOauth2ProviderConfigOutput googleOauth2ProviderConfig) {
            Object oldValue = this.googleOauth2ProviderConfig;
            this.googleOauth2ProviderConfig = googleOauth2ProviderConfig;
            handleUnionValueChange(Type.GOOGLE_OAUTH2_PROVIDER_CONFIG, oldValue, this.googleOauth2ProviderConfig);
            return this;
        }

        public final GithubOauth2ProviderConfigOutput.Builder getGithubOauth2ProviderConfig() {
            return githubOauth2ProviderConfig != null ? githubOauth2ProviderConfig.toBuilder() : null;
        }

        public final void setGithubOauth2ProviderConfig(GithubOauth2ProviderConfigOutput.BuilderImpl githubOauth2ProviderConfig) {
            Object oldValue = this.githubOauth2ProviderConfig;
            this.githubOauth2ProviderConfig = githubOauth2ProviderConfig != null ? githubOauth2ProviderConfig.build() : null;
            handleUnionValueChange(Type.GITHUB_OAUTH2_PROVIDER_CONFIG, oldValue, this.githubOauth2ProviderConfig);
        }

        @Override
        public final Builder githubOauth2ProviderConfig(GithubOauth2ProviderConfigOutput githubOauth2ProviderConfig) {
            Object oldValue = this.githubOauth2ProviderConfig;
            this.githubOauth2ProviderConfig = githubOauth2ProviderConfig;
            handleUnionValueChange(Type.GITHUB_OAUTH2_PROVIDER_CONFIG, oldValue, this.githubOauth2ProviderConfig);
            return this;
        }

        public final SlackOauth2ProviderConfigOutput.Builder getSlackOauth2ProviderConfig() {
            return slackOauth2ProviderConfig != null ? slackOauth2ProviderConfig.toBuilder() : null;
        }

        public final void setSlackOauth2ProviderConfig(SlackOauth2ProviderConfigOutput.BuilderImpl slackOauth2ProviderConfig) {
            Object oldValue = this.slackOauth2ProviderConfig;
            this.slackOauth2ProviderConfig = slackOauth2ProviderConfig != null ? slackOauth2ProviderConfig.build() : null;
            handleUnionValueChange(Type.SLACK_OAUTH2_PROVIDER_CONFIG, oldValue, this.slackOauth2ProviderConfig);
        }

        @Override
        public final Builder slackOauth2ProviderConfig(SlackOauth2ProviderConfigOutput slackOauth2ProviderConfig) {
            Object oldValue = this.slackOauth2ProviderConfig;
            this.slackOauth2ProviderConfig = slackOauth2ProviderConfig;
            handleUnionValueChange(Type.SLACK_OAUTH2_PROVIDER_CONFIG, oldValue, this.slackOauth2ProviderConfig);
            return this;
        }

        public final SalesforceOauth2ProviderConfigOutput.Builder getSalesforceOauth2ProviderConfig() {
            return salesforceOauth2ProviderConfig != null ? salesforceOauth2ProviderConfig.toBuilder() : null;
        }

        public final void setSalesforceOauth2ProviderConfig(
                SalesforceOauth2ProviderConfigOutput.BuilderImpl salesforceOauth2ProviderConfig) {
            Object oldValue = this.salesforceOauth2ProviderConfig;
            this.salesforceOauth2ProviderConfig = salesforceOauth2ProviderConfig != null ? salesforceOauth2ProviderConfig.build()
                    : null;
            handleUnionValueChange(Type.SALESFORCE_OAUTH2_PROVIDER_CONFIG, oldValue, this.salesforceOauth2ProviderConfig);
        }

        @Override
        public final Builder salesforceOauth2ProviderConfig(SalesforceOauth2ProviderConfigOutput salesforceOauth2ProviderConfig) {
            Object oldValue = this.salesforceOauth2ProviderConfig;
            this.salesforceOauth2ProviderConfig = salesforceOauth2ProviderConfig;
            handleUnionValueChange(Type.SALESFORCE_OAUTH2_PROVIDER_CONFIG, oldValue, this.salesforceOauth2ProviderConfig);
            return this;
        }

        public final MicrosoftOauth2ProviderConfigOutput.Builder getMicrosoftOauth2ProviderConfig() {
            return microsoftOauth2ProviderConfig != null ? microsoftOauth2ProviderConfig.toBuilder() : null;
        }

        public final void setMicrosoftOauth2ProviderConfig(
                MicrosoftOauth2ProviderConfigOutput.BuilderImpl microsoftOauth2ProviderConfig) {
            Object oldValue = this.microsoftOauth2ProviderConfig;
            this.microsoftOauth2ProviderConfig = microsoftOauth2ProviderConfig != null ? microsoftOauth2ProviderConfig.build()
                    : null;
            handleUnionValueChange(Type.MICROSOFT_OAUTH2_PROVIDER_CONFIG, oldValue, this.microsoftOauth2ProviderConfig);
        }

        @Override
        public final Builder microsoftOauth2ProviderConfig(MicrosoftOauth2ProviderConfigOutput microsoftOauth2ProviderConfig) {
            Object oldValue = this.microsoftOauth2ProviderConfig;
            this.microsoftOauth2ProviderConfig = microsoftOauth2ProviderConfig;
            handleUnionValueChange(Type.MICROSOFT_OAUTH2_PROVIDER_CONFIG, oldValue, this.microsoftOauth2ProviderConfig);
            return this;
        }

        @Override
        public Oauth2ProviderConfigOutput build() {
            return new Oauth2ProviderConfigOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Oauth2ProviderConfigOutput#type()
     */
    public enum Type {
        CUSTOM_OAUTH2_PROVIDER_CONFIG,

        GOOGLE_OAUTH2_PROVIDER_CONFIG,

        GITHUB_OAUTH2_PROVIDER_CONFIG,

        SLACK_OAUTH2_PROVIDER_CONFIG,

        SALESFORCE_OAUTH2_PROVIDER_CONFIG,

        MICROSOFT_OAUTH2_PROVIDER_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
