/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the authorization server metadata for an OAuth2 provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Oauth2AuthorizationServerMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<Oauth2AuthorizationServerMetadata.Builder, Oauth2AuthorizationServerMetadata> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("issuer")
            .getter(getter(Oauth2AuthorizationServerMetadata::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationEndpoint").getter(getter(Oauth2AuthorizationServerMetadata::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationEndpoint").build())
            .build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenEndpoint").getter(getter(Oauth2AuthorizationServerMetadata::tokenEndpoint))
            .setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpoint").build()).build();

    private static final SdkField<List<String>> RESPONSE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("responseTypes")
            .getter(getter(Oauth2AuthorizationServerMetadata::responseTypes))
            .setter(setter(Builder::responseTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD,
            AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, RESPONSE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String issuer;

    private final String authorizationEndpoint;

    private final String tokenEndpoint;

    private final List<String> responseTypes;

    private Oauth2AuthorizationServerMetadata(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.responseTypes = builder.responseTypes;
    }

    /**
     * <p>
     * The issuer URL for the OAuth2 authorization server.
     * </p>
     * 
     * @return The issuer URL for the OAuth2 authorization server.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The authorization endpoint URL for the OAuth2 authorization server.
     * </p>
     * 
     * @return The authorization endpoint URL for the OAuth2 authorization server.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The token endpoint URL for the OAuth2 authorization server.
     * </p>
     * 
     * @return The token endpoint URL for the OAuth2 authorization server.
     */
    public final String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseTypes() {
        return responseTypes != null && !(responseTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported response types for the OAuth2 authorization server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseTypes} method.
     * </p>
     * 
     * @return The supported response types for the OAuth2 authorization server.
     */
    public final List<String> responseTypes() {
        return responseTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseTypes() ? responseTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Oauth2AuthorizationServerMetadata)) {
            return false;
        }
        Oauth2AuthorizationServerMetadata other = (Oauth2AuthorizationServerMetadata) obj;
        return Objects.equals(issuer(), other.issuer()) && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint()) && hasResponseTypes() == other.hasResponseTypes()
                && Objects.equals(responseTypes(), other.responseTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Oauth2AuthorizationServerMetadata").add("Issuer", issuer())
                .add("AuthorizationEndpoint", authorizationEndpoint()).add("TokenEndpoint", tokenEndpoint())
                .add("ResponseTypes", hasResponseTypes() ? responseTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "authorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "tokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "responseTypes":
            return Optional.ofNullable(clazz.cast(responseTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("issuer", ISSUER_FIELD);
        map.put("authorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("tokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("responseTypes", RESPONSE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Oauth2AuthorizationServerMetadata, T> g) {
        return obj -> g.apply((Oauth2AuthorizationServerMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Oauth2AuthorizationServerMetadata> {
        /**
         * <p>
         * The issuer URL for the OAuth2 authorization server.
         * </p>
         * 
         * @param issuer
         *        The issuer URL for the OAuth2 authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The authorization endpoint URL for the OAuth2 authorization server.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The authorization endpoint URL for the OAuth2 authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The token endpoint URL for the OAuth2 authorization server.
         * </p>
         * 
         * @param tokenEndpoint
         *        The token endpoint URL for the OAuth2 authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The supported response types for the OAuth2 authorization server.
         * </p>
         * 
         * @param responseTypes
         *        The supported response types for the OAuth2 authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTypes(Collection<String> responseTypes);

        /**
         * <p>
         * The supported response types for the OAuth2 authorization server.
         * </p>
         * 
         * @param responseTypes
         *        The supported response types for the OAuth2 authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTypes(String... responseTypes);
    }

    static final class BuilderImpl implements Builder {
        private String issuer;

        private String authorizationEndpoint;

        private String tokenEndpoint;

        private List<String> responseTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Oauth2AuthorizationServerMetadata model) {
            issuer(model.issuer);
            authorizationEndpoint(model.authorizationEndpoint);
            tokenEndpoint(model.tokenEndpoint);
            responseTypes(model.responseTypes);
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final Collection<String> getResponseTypes() {
            if (responseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return responseTypes;
        }

        public final void setResponseTypes(Collection<String> responseTypes) {
            this.responseTypes = ResponseListTypeCopier.copy(responseTypes);
        }

        @Override
        public final Builder responseTypes(Collection<String> responseTypes) {
            this.responseTypes = ResponseListTypeCopier.copy(responseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTypes(String... responseTypes) {
            responseTypes(Arrays.asList(responseTypes));
            return this;
        }

        @Override
        public Oauth2AuthorizationServerMetadata build() {
            return new Oauth2AuthorizationServerMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
