/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information for modifying a strategy configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyStrategyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyStrategyConfiguration.Builder, ModifyStrategyConfiguration> {
    private static final SdkField<ModifyExtractionConfiguration> EXTRACTION_FIELD = SdkField
            .<ModifyExtractionConfiguration> builder(MarshallingType.SDK_POJO).memberName("extraction")
            .getter(getter(ModifyStrategyConfiguration::extraction)).setter(setter(Builder::extraction))
            .constructor(ModifyExtractionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()).build();

    private static final SdkField<ModifyConsolidationConfiguration> CONSOLIDATION_FIELD = SdkField
            .<ModifyConsolidationConfiguration> builder(MarshallingType.SDK_POJO).memberName("consolidation")
            .getter(getter(ModifyStrategyConfiguration::consolidation)).setter(setter(Builder::consolidation))
            .constructor(ModifyConsolidationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consolidation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD,
            CONSOLIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ModifyExtractionConfiguration extraction;

    private final ModifyConsolidationConfiguration consolidation;

    private ModifyStrategyConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.consolidation = builder.consolidation;
    }

    /**
     * <p>
     * The updated extraction configuration.
     * </p>
     * 
     * @return The updated extraction configuration.
     */
    public final ModifyExtractionConfiguration extraction() {
        return extraction;
    }

    /**
     * <p>
     * The updated consolidation configuration.
     * </p>
     * 
     * @return The updated consolidation configuration.
     */
    public final ModifyConsolidationConfiguration consolidation() {
        return consolidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraction());
        hashCode = 31 * hashCode + Objects.hashCode(consolidation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyStrategyConfiguration)) {
            return false;
        }
        ModifyStrategyConfiguration other = (ModifyStrategyConfiguration) obj;
        return Objects.equals(extraction(), other.extraction()) && Objects.equals(consolidation(), other.consolidation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyStrategyConfiguration").add("Extraction", extraction())
                .add("Consolidation", consolidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extraction":
            return Optional.ofNullable(clazz.cast(extraction()));
        case "consolidation":
            return Optional.ofNullable(clazz.cast(consolidation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("consolidation", CONSOLIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyStrategyConfiguration, T> g) {
        return obj -> g.apply((ModifyStrategyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyStrategyConfiguration> {
        /**
         * <p>
         * The updated extraction configuration.
         * </p>
         * 
         * @param extraction
         *        The updated extraction configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraction(ModifyExtractionConfiguration extraction);

        /**
         * <p>
         * The updated extraction configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModifyExtractionConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModifyExtractionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModifyExtractionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #extraction(ModifyExtractionConfiguration)}.
         * 
         * @param extraction
         *        a consumer that will call methods on {@link ModifyExtractionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extraction(ModifyExtractionConfiguration)
         */
        default Builder extraction(Consumer<ModifyExtractionConfiguration.Builder> extraction) {
            return extraction(ModifyExtractionConfiguration.builder().applyMutation(extraction).build());
        }

        /**
         * <p>
         * The updated consolidation configuration.
         * </p>
         * 
         * @param consolidation
         *        The updated consolidation configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consolidation(ModifyConsolidationConfiguration consolidation);

        /**
         * <p>
         * The updated consolidation configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModifyConsolidationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModifyConsolidationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModifyConsolidationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #consolidation(ModifyConsolidationConfiguration)}.
         * 
         * @param consolidation
         *        a consumer that will call methods on {@link ModifyConsolidationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consolidation(ModifyConsolidationConfiguration)
         */
        default Builder consolidation(Consumer<ModifyConsolidationConfiguration.Builder> consolidation) {
            return consolidation(ModifyConsolidationConfiguration.builder().applyMutation(consolidation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModifyExtractionConfiguration extraction;

        private ModifyConsolidationConfiguration consolidation;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyStrategyConfiguration model) {
            extraction(model.extraction);
            consolidation(model.consolidation);
        }

        public final ModifyExtractionConfiguration.Builder getExtraction() {
            return extraction != null ? extraction.toBuilder() : null;
        }

        public final void setExtraction(ModifyExtractionConfiguration.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(ModifyExtractionConfiguration extraction) {
            this.extraction = extraction;
            return this;
        }

        public final ModifyConsolidationConfiguration.Builder getConsolidation() {
            return consolidation != null ? consolidation.toBuilder() : null;
        }

        public final void setConsolidation(ModifyConsolidationConfiguration.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(ModifyConsolidationConfiguration consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        @Override
        public ModifyStrategyConfiguration build() {
            return new ModifyStrategyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
