/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for modifying a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyMemoryStrategyInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyMemoryStrategyInput.Builder, ModifyMemoryStrategyInput> {
    private static final SdkField<String> MEMORY_STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memoryStrategyId").getter(getter(ModifyMemoryStrategyInput::memoryStrategyId))
            .setter(setter(Builder::memoryStrategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ModifyMemoryStrategyInput::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("namespaces")
            .getter(getter(ModifyMemoryStrategyInput::namespaces))
            .setter(setter(Builder::namespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ModifyStrategyConfiguration> CONFIGURATION_FIELD = SdkField
            .<ModifyStrategyConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(ModifyMemoryStrategyInput::configuration)).setter(setter(Builder::configuration))
            .constructor(ModifyStrategyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_STRATEGY_ID_FIELD,
            DESCRIPTION_FIELD, NAMESPACES_FIELD, CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String memoryStrategyId;

    private final String description;

    private final List<String> namespaces;

    private final ModifyStrategyConfiguration configuration;

    private ModifyMemoryStrategyInput(BuilderImpl builder) {
        this.memoryStrategyId = builder.memoryStrategyId;
        this.description = builder.description;
        this.namespaces = builder.namespaces;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The unique identifier of the memory strategy to modify.
     * </p>
     * 
     * @return The unique identifier of the memory strategy to modify.
     */
    public final String memoryStrategyId() {
        return memoryStrategyId;
    }

    /**
     * <p>
     * The updated description of the memory strategy.
     * </p>
     * 
     * @return The updated description of the memory strategy.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Namespaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNamespaces() {
        return namespaces != null && !(namespaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated namespaces for the memory strategy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamespaces} method.
     * </p>
     * 
     * @return The updated namespaces for the memory strategy.
     */
    public final List<String> namespaces() {
        return namespaces;
    }

    /**
     * <p>
     * The updated configuration for the memory strategy.
     * </p>
     * 
     * @return The updated configuration for the memory strategy.
     */
    public final ModifyStrategyConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memoryStrategyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasNamespaces() ? namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMemoryStrategyInput)) {
            return false;
        }
        ModifyMemoryStrategyInput other = (ModifyMemoryStrategyInput) obj;
        return Objects.equals(memoryStrategyId(), other.memoryStrategyId()) && Objects.equals(description(), other.description())
                && hasNamespaces() == other.hasNamespaces() && Objects.equals(namespaces(), other.namespaces())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyMemoryStrategyInput").add("MemoryStrategyId", memoryStrategyId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Namespaces", hasNamespaces() ? namespaces() : null).add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryStrategyId":
            return Optional.ofNullable(clazz.cast(memoryStrategyId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "namespaces":
            return Optional.ofNullable(clazz.cast(namespaces()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memoryStrategyId", MEMORY_STRATEGY_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyMemoryStrategyInput, T> g) {
        return obj -> g.apply((ModifyMemoryStrategyInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyMemoryStrategyInput> {
        /**
         * <p>
         * The unique identifier of the memory strategy to modify.
         * </p>
         * 
         * @param memoryStrategyId
         *        The unique identifier of the memory strategy to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStrategyId(String memoryStrategyId);

        /**
         * <p>
         * The updated description of the memory strategy.
         * </p>
         * 
         * @param description
         *        The updated description of the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated namespaces for the memory strategy.
         * </p>
         * 
         * @param namespaces
         *        The updated namespaces for the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(Collection<String> namespaces);

        /**
         * <p>
         * The updated namespaces for the memory strategy.
         * </p>
         * 
         * @param namespaces
         *        The updated namespaces for the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(String... namespaces);

        /**
         * <p>
         * The updated configuration for the memory strategy.
         * </p>
         * 
         * @param configuration
         *        The updated configuration for the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ModifyStrategyConfiguration configuration);

        /**
         * <p>
         * The updated configuration for the memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModifyStrategyConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModifyStrategyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModifyStrategyConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(ModifyStrategyConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ModifyStrategyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ModifyStrategyConfiguration)
         */
        default Builder configuration(Consumer<ModifyStrategyConfiguration.Builder> configuration) {
            return configuration(ModifyStrategyConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String memoryStrategyId;

        private String description;

        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();

        private ModifyStrategyConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyMemoryStrategyInput model) {
            memoryStrategyId(model.memoryStrategyId);
            description(model.description);
            namespaces(model.namespaces);
            configuration(model.configuration);
        }

        public final String getMemoryStrategyId() {
            return memoryStrategyId;
        }

        public final void setMemoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
        }

        @Override
        public final Builder memoryStrategyId(String memoryStrategyId) {
            this.memoryStrategyId = memoryStrategyId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String... namespaces) {
            namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final ModifyStrategyConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ModifyStrategyConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ModifyStrategyConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public ModifyMemoryStrategyInput build() {
            return new ModifyMemoryStrategyInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
