/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains input information for creating a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemoryStrategyInput implements SdkPojo, Serializable,
        ToCopyableBuilder<MemoryStrategyInput.Builder, MemoryStrategyInput> {
    private static final SdkField<SemanticMemoryStrategyInput> SEMANTIC_MEMORY_STRATEGY_FIELD = SdkField
            .<SemanticMemoryStrategyInput> builder(MarshallingType.SDK_POJO).memberName("semanticMemoryStrategy")
            .getter(getter(MemoryStrategyInput::semanticMemoryStrategy)).setter(setter(Builder::semanticMemoryStrategy))
            .constructor(SemanticMemoryStrategyInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticMemoryStrategy").build())
            .build();

    private static final SdkField<SummaryMemoryStrategyInput> SUMMARY_MEMORY_STRATEGY_FIELD = SdkField
            .<SummaryMemoryStrategyInput> builder(MarshallingType.SDK_POJO).memberName("summaryMemoryStrategy")
            .getter(getter(MemoryStrategyInput::summaryMemoryStrategy)).setter(setter(Builder::summaryMemoryStrategy))
            .constructor(SummaryMemoryStrategyInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryMemoryStrategy").build())
            .build();

    private static final SdkField<UserPreferenceMemoryStrategyInput> USER_PREFERENCE_MEMORY_STRATEGY_FIELD = SdkField
            .<UserPreferenceMemoryStrategyInput> builder(MarshallingType.SDK_POJO)
            .memberName("userPreferenceMemoryStrategy")
            .getter(getter(MemoryStrategyInput::userPreferenceMemoryStrategy))
            .setter(setter(Builder::userPreferenceMemoryStrategy))
            .constructor(UserPreferenceMemoryStrategyInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceMemoryStrategy")
                    .build()).build();

    private static final SdkField<CustomMemoryStrategyInput> CUSTOM_MEMORY_STRATEGY_FIELD = SdkField
            .<CustomMemoryStrategyInput> builder(MarshallingType.SDK_POJO).memberName("customMemoryStrategy")
            .getter(getter(MemoryStrategyInput::customMemoryStrategy)).setter(setter(Builder::customMemoryStrategy))
            .constructor(CustomMemoryStrategyInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMemoryStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SEMANTIC_MEMORY_STRATEGY_FIELD, SUMMARY_MEMORY_STRATEGY_FIELD, USER_PREFERENCE_MEMORY_STRATEGY_FIELD,
            CUSTOM_MEMORY_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SemanticMemoryStrategyInput semanticMemoryStrategy;

    private final SummaryMemoryStrategyInput summaryMemoryStrategy;

    private final UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy;

    private final CustomMemoryStrategyInput customMemoryStrategy;

    private final Type type;

    private MemoryStrategyInput(BuilderImpl builder) {
        this.semanticMemoryStrategy = builder.semanticMemoryStrategy;
        this.summaryMemoryStrategy = builder.summaryMemoryStrategy;
        this.userPreferenceMemoryStrategy = builder.userPreferenceMemoryStrategy;
        this.customMemoryStrategy = builder.customMemoryStrategy;
        this.type = builder.type;
    }

    /**
     * <p>
     * Input for creating a semantic memory strategy.
     * </p>
     * 
     * @return Input for creating a semantic memory strategy.
     */
    public final SemanticMemoryStrategyInput semanticMemoryStrategy() {
        return semanticMemoryStrategy;
    }

    /**
     * <p>
     * Input for creating a summary memory strategy.
     * </p>
     * 
     * @return Input for creating a summary memory strategy.
     */
    public final SummaryMemoryStrategyInput summaryMemoryStrategy() {
        return summaryMemoryStrategy;
    }

    /**
     * <p>
     * Input for creating a user preference memory strategy.
     * </p>
     * 
     * @return Input for creating a user preference memory strategy.
     */
    public final UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy() {
        return userPreferenceMemoryStrategy;
    }

    /**
     * <p>
     * Input for creating a custom memory strategy.
     * </p>
     * 
     * @return Input for creating a custom memory strategy.
     */
    public final CustomMemoryStrategyInput customMemoryStrategy() {
        return customMemoryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(semanticMemoryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(summaryMemoryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(userPreferenceMemoryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(customMemoryStrategy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryStrategyInput)) {
            return false;
        }
        MemoryStrategyInput other = (MemoryStrategyInput) obj;
        return Objects.equals(semanticMemoryStrategy(), other.semanticMemoryStrategy())
                && Objects.equals(summaryMemoryStrategy(), other.summaryMemoryStrategy())
                && Objects.equals(userPreferenceMemoryStrategy(), other.userPreferenceMemoryStrategy())
                && Objects.equals(customMemoryStrategy(), other.customMemoryStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemoryStrategyInput").add("SemanticMemoryStrategy", semanticMemoryStrategy())
                .add("SummaryMemoryStrategy", summaryMemoryStrategy())
                .add("UserPreferenceMemoryStrategy", userPreferenceMemoryStrategy())
                .add("CustomMemoryStrategy", customMemoryStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "semanticMemoryStrategy":
            return Optional.ofNullable(clazz.cast(semanticMemoryStrategy()));
        case "summaryMemoryStrategy":
            return Optional.ofNullable(clazz.cast(summaryMemoryStrategy()));
        case "userPreferenceMemoryStrategy":
            return Optional.ofNullable(clazz.cast(userPreferenceMemoryStrategy()));
        case "customMemoryStrategy":
            return Optional.ofNullable(clazz.cast(customMemoryStrategy()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #semanticMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a semantic memory strategy.
     * </p>
     * 
     * @param semanticMemoryStrategy
     *        Input for creating a semantic memory strategy.
     */
    public static MemoryStrategyInput fromSemanticMemoryStrategy(SemanticMemoryStrategyInput semanticMemoryStrategy) {
        return builder().semanticMemoryStrategy(semanticMemoryStrategy).build();
    }

    /**
     * Create an instance of this class with {@link #semanticMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a semantic memory strategy.
     * </p>
     * 
     * @param semanticMemoryStrategy
     *        Input for creating a semantic memory strategy.
     */
    public static MemoryStrategyInput fromSemanticMemoryStrategy(
            Consumer<SemanticMemoryStrategyInput.Builder> semanticMemoryStrategy) {
        SemanticMemoryStrategyInput.Builder builder = SemanticMemoryStrategyInput.builder();
        semanticMemoryStrategy.accept(builder);
        return fromSemanticMemoryStrategy(builder.build());
    }

    /**
     * Create an instance of this class with {@link #summaryMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a summary memory strategy.
     * </p>
     * 
     * @param summaryMemoryStrategy
     *        Input for creating a summary memory strategy.
     */
    public static MemoryStrategyInput fromSummaryMemoryStrategy(SummaryMemoryStrategyInput summaryMemoryStrategy) {
        return builder().summaryMemoryStrategy(summaryMemoryStrategy).build();
    }

    /**
     * Create an instance of this class with {@link #summaryMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a summary memory strategy.
     * </p>
     * 
     * @param summaryMemoryStrategy
     *        Input for creating a summary memory strategy.
     */
    public static MemoryStrategyInput fromSummaryMemoryStrategy(Consumer<SummaryMemoryStrategyInput.Builder> summaryMemoryStrategy) {
        SummaryMemoryStrategyInput.Builder builder = SummaryMemoryStrategyInput.builder();
        summaryMemoryStrategy.accept(builder);
        return fromSummaryMemoryStrategy(builder.build());
    }

    /**
     * Create an instance of this class with {@link #userPreferenceMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a user preference memory strategy.
     * </p>
     * 
     * @param userPreferenceMemoryStrategy
     *        Input for creating a user preference memory strategy.
     */
    public static MemoryStrategyInput fromUserPreferenceMemoryStrategy(
            UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy) {
        return builder().userPreferenceMemoryStrategy(userPreferenceMemoryStrategy).build();
    }

    /**
     * Create an instance of this class with {@link #userPreferenceMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a user preference memory strategy.
     * </p>
     * 
     * @param userPreferenceMemoryStrategy
     *        Input for creating a user preference memory strategy.
     */
    public static MemoryStrategyInput fromUserPreferenceMemoryStrategy(
            Consumer<UserPreferenceMemoryStrategyInput.Builder> userPreferenceMemoryStrategy) {
        UserPreferenceMemoryStrategyInput.Builder builder = UserPreferenceMemoryStrategyInput.builder();
        userPreferenceMemoryStrategy.accept(builder);
        return fromUserPreferenceMemoryStrategy(builder.build());
    }

    /**
     * Create an instance of this class with {@link #customMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a custom memory strategy.
     * </p>
     * 
     * @param customMemoryStrategy
     *        Input for creating a custom memory strategy.
     */
    public static MemoryStrategyInput fromCustomMemoryStrategy(CustomMemoryStrategyInput customMemoryStrategy) {
        return builder().customMemoryStrategy(customMemoryStrategy).build();
    }

    /**
     * Create an instance of this class with {@link #customMemoryStrategy()} initialized to the given value.
     *
     * <p>
     * Input for creating a custom memory strategy.
     * </p>
     * 
     * @param customMemoryStrategy
     *        Input for creating a custom memory strategy.
     */
    public static MemoryStrategyInput fromCustomMemoryStrategy(Consumer<CustomMemoryStrategyInput.Builder> customMemoryStrategy) {
        CustomMemoryStrategyInput.Builder builder = CustomMemoryStrategyInput.builder();
        customMemoryStrategy.accept(builder);
        return fromCustomMemoryStrategy(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("semanticMemoryStrategy", SEMANTIC_MEMORY_STRATEGY_FIELD);
        map.put("summaryMemoryStrategy", SUMMARY_MEMORY_STRATEGY_FIELD);
        map.put("userPreferenceMemoryStrategy", USER_PREFERENCE_MEMORY_STRATEGY_FIELD);
        map.put("customMemoryStrategy", CUSTOM_MEMORY_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryStrategyInput, T> g) {
        return obj -> g.apply((MemoryStrategyInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemoryStrategyInput> {
        /**
         * <p>
         * Input for creating a semantic memory strategy.
         * </p>
         * 
         * @param semanticMemoryStrategy
         *        Input for creating a semantic memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticMemoryStrategy(SemanticMemoryStrategyInput semanticMemoryStrategy);

        /**
         * <p>
         * Input for creating a semantic memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link SemanticMemoryStrategyInput.Builder}
         * avoiding the need to create one manually via {@link SemanticMemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SemanticMemoryStrategyInput.Builder#build()} is called
         * immediately and its result is passed to {@link #semanticMemoryStrategy(SemanticMemoryStrategyInput)}.
         * 
         * @param semanticMemoryStrategy
         *        a consumer that will call methods on {@link SemanticMemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #semanticMemoryStrategy(SemanticMemoryStrategyInput)
         */
        default Builder semanticMemoryStrategy(Consumer<SemanticMemoryStrategyInput.Builder> semanticMemoryStrategy) {
            return semanticMemoryStrategy(SemanticMemoryStrategyInput.builder().applyMutation(semanticMemoryStrategy).build());
        }

        /**
         * <p>
         * Input for creating a summary memory strategy.
         * </p>
         * 
         * @param summaryMemoryStrategy
         *        Input for creating a summary memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryMemoryStrategy(SummaryMemoryStrategyInput summaryMemoryStrategy);

        /**
         * <p>
         * Input for creating a summary memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link SummaryMemoryStrategyInput.Builder}
         * avoiding the need to create one manually via {@link SummaryMemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummaryMemoryStrategyInput.Builder#build()} is called immediately
         * and its result is passed to {@link #summaryMemoryStrategy(SummaryMemoryStrategyInput)}.
         * 
         * @param summaryMemoryStrategy
         *        a consumer that will call methods on {@link SummaryMemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryMemoryStrategy(SummaryMemoryStrategyInput)
         */
        default Builder summaryMemoryStrategy(Consumer<SummaryMemoryStrategyInput.Builder> summaryMemoryStrategy) {
            return summaryMemoryStrategy(SummaryMemoryStrategyInput.builder().applyMutation(summaryMemoryStrategy).build());
        }

        /**
         * <p>
         * Input for creating a user preference memory strategy.
         * </p>
         * 
         * @param userPreferenceMemoryStrategy
         *        Input for creating a user preference memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy);

        /**
         * <p>
         * Input for creating a user preference memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UserPreferenceMemoryStrategyInput.Builder} avoiding the need to create one manually via
         * {@link UserPreferenceMemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserPreferenceMemoryStrategyInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput)}.
         * 
         * @param userPreferenceMemoryStrategy
         *        a consumer that will call methods on {@link UserPreferenceMemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput)
         */
        default Builder userPreferenceMemoryStrategy(
                Consumer<UserPreferenceMemoryStrategyInput.Builder> userPreferenceMemoryStrategy) {
            return userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput.builder()
                    .applyMutation(userPreferenceMemoryStrategy).build());
        }

        /**
         * <p>
         * Input for creating a custom memory strategy.
         * </p>
         * 
         * @param customMemoryStrategy
         *        Input for creating a custom memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMemoryStrategy(CustomMemoryStrategyInput customMemoryStrategy);

        /**
         * <p>
         * Input for creating a custom memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomMemoryStrategyInput.Builder}
         * avoiding the need to create one manually via {@link CustomMemoryStrategyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomMemoryStrategyInput.Builder#build()} is called immediately
         * and its result is passed to {@link #customMemoryStrategy(CustomMemoryStrategyInput)}.
         * 
         * @param customMemoryStrategy
         *        a consumer that will call methods on {@link CustomMemoryStrategyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customMemoryStrategy(CustomMemoryStrategyInput)
         */
        default Builder customMemoryStrategy(Consumer<CustomMemoryStrategyInput.Builder> customMemoryStrategy) {
            return customMemoryStrategy(CustomMemoryStrategyInput.builder().applyMutation(customMemoryStrategy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SemanticMemoryStrategyInput semanticMemoryStrategy;

        private SummaryMemoryStrategyInput summaryMemoryStrategy;

        private UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy;

        private CustomMemoryStrategyInput customMemoryStrategy;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryStrategyInput model) {
            semanticMemoryStrategy(model.semanticMemoryStrategy);
            summaryMemoryStrategy(model.summaryMemoryStrategy);
            userPreferenceMemoryStrategy(model.userPreferenceMemoryStrategy);
            customMemoryStrategy(model.customMemoryStrategy);
        }

        public final SemanticMemoryStrategyInput.Builder getSemanticMemoryStrategy() {
            return semanticMemoryStrategy != null ? semanticMemoryStrategy.toBuilder() : null;
        }

        public final void setSemanticMemoryStrategy(SemanticMemoryStrategyInput.BuilderImpl semanticMemoryStrategy) {
            Object oldValue = this.semanticMemoryStrategy;
            this.semanticMemoryStrategy = semanticMemoryStrategy != null ? semanticMemoryStrategy.build() : null;
            handleUnionValueChange(Type.SEMANTIC_MEMORY_STRATEGY, oldValue, this.semanticMemoryStrategy);
        }

        @Override
        public final Builder semanticMemoryStrategy(SemanticMemoryStrategyInput semanticMemoryStrategy) {
            Object oldValue = this.semanticMemoryStrategy;
            this.semanticMemoryStrategy = semanticMemoryStrategy;
            handleUnionValueChange(Type.SEMANTIC_MEMORY_STRATEGY, oldValue, this.semanticMemoryStrategy);
            return this;
        }

        public final SummaryMemoryStrategyInput.Builder getSummaryMemoryStrategy() {
            return summaryMemoryStrategy != null ? summaryMemoryStrategy.toBuilder() : null;
        }

        public final void setSummaryMemoryStrategy(SummaryMemoryStrategyInput.BuilderImpl summaryMemoryStrategy) {
            Object oldValue = this.summaryMemoryStrategy;
            this.summaryMemoryStrategy = summaryMemoryStrategy != null ? summaryMemoryStrategy.build() : null;
            handleUnionValueChange(Type.SUMMARY_MEMORY_STRATEGY, oldValue, this.summaryMemoryStrategy);
        }

        @Override
        public final Builder summaryMemoryStrategy(SummaryMemoryStrategyInput summaryMemoryStrategy) {
            Object oldValue = this.summaryMemoryStrategy;
            this.summaryMemoryStrategy = summaryMemoryStrategy;
            handleUnionValueChange(Type.SUMMARY_MEMORY_STRATEGY, oldValue, this.summaryMemoryStrategy);
            return this;
        }

        public final UserPreferenceMemoryStrategyInput.Builder getUserPreferenceMemoryStrategy() {
            return userPreferenceMemoryStrategy != null ? userPreferenceMemoryStrategy.toBuilder() : null;
        }

        public final void setUserPreferenceMemoryStrategy(
                UserPreferenceMemoryStrategyInput.BuilderImpl userPreferenceMemoryStrategy) {
            Object oldValue = this.userPreferenceMemoryStrategy;
            this.userPreferenceMemoryStrategy = userPreferenceMemoryStrategy != null ? userPreferenceMemoryStrategy.build()
                    : null;
            handleUnionValueChange(Type.USER_PREFERENCE_MEMORY_STRATEGY, oldValue, this.userPreferenceMemoryStrategy);
        }

        @Override
        public final Builder userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy) {
            Object oldValue = this.userPreferenceMemoryStrategy;
            this.userPreferenceMemoryStrategy = userPreferenceMemoryStrategy;
            handleUnionValueChange(Type.USER_PREFERENCE_MEMORY_STRATEGY, oldValue, this.userPreferenceMemoryStrategy);
            return this;
        }

        public final CustomMemoryStrategyInput.Builder getCustomMemoryStrategy() {
            return customMemoryStrategy != null ? customMemoryStrategy.toBuilder() : null;
        }

        public final void setCustomMemoryStrategy(CustomMemoryStrategyInput.BuilderImpl customMemoryStrategy) {
            Object oldValue = this.customMemoryStrategy;
            this.customMemoryStrategy = customMemoryStrategy != null ? customMemoryStrategy.build() : null;
            handleUnionValueChange(Type.CUSTOM_MEMORY_STRATEGY, oldValue, this.customMemoryStrategy);
        }

        @Override
        public final Builder customMemoryStrategy(CustomMemoryStrategyInput customMemoryStrategy) {
            Object oldValue = this.customMemoryStrategy;
            this.customMemoryStrategy = customMemoryStrategy;
            handleUnionValueChange(Type.CUSTOM_MEMORY_STRATEGY, oldValue, this.customMemoryStrategy);
            return this;
        }

        @Override
        public MemoryStrategyInput build() {
            return new MemoryStrategyInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MemoryStrategyInput#type()
     */
    public enum Type {
        SEMANTIC_MEMORY_STRATEGY,

        SUMMARY_MEMORY_STRATEGY,

        USER_PREFERENCE_MEMORY_STRATEGY,

        CUSTOM_MEMORY_STRATEGY,

        UNKNOWN_TO_SDK_VERSION
    }
}
