/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a memory strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemoryStrategy implements SdkPojo, Serializable, ToCopyableBuilder<MemoryStrategy.Builder, MemoryStrategy> {
    private static final SdkField<String> STRATEGY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("strategyId").getter(getter(MemoryStrategy::strategyId)).setter(setter(Builder::strategyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategyId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MemoryStrategy::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(MemoryStrategy::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<StrategyConfiguration> CONFIGURATION_FIELD = SdkField
            .<StrategyConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(MemoryStrategy::configuration)).setter(setter(Builder::configuration))
            .constructor(StrategyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(MemoryStrategy::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("namespaces")
            .getter(getter(MemoryStrategy::namespaces))
            .setter(setter(Builder::namespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(MemoryStrategy::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(MemoryStrategy::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MemoryStrategy::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CONFIGURATION_FIELD, TYPE_FIELD, NAMESPACES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String strategyId;

    private final String name;

    private final String description;

    private final StrategyConfiguration configuration;

    private final String type;

    private final List<String> namespaces;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private MemoryStrategy(BuilderImpl builder) {
        this.strategyId = builder.strategyId;
        this.name = builder.name;
        this.description = builder.description;
        this.configuration = builder.configuration;
        this.type = builder.type;
        this.namespaces = builder.namespaces;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the memory strategy.
     * </p>
     * 
     * @return The unique identifier of the memory strategy.
     */
    public final String strategyId() {
        return strategyId;
    }

    /**
     * <p>
     * The name of the memory strategy.
     * </p>
     * 
     * @return The name of the memory strategy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the memory strategy.
     * </p>
     * 
     * @return The description of the memory strategy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration of the memory strategy.
     * </p>
     * 
     * @return The configuration of the memory strategy.
     */
    public final StrategyConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The type of the memory strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MemoryStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the memory strategy.
     * @see MemoryStrategyType
     */
    public final MemoryStrategyType type() {
        return MemoryStrategyType.fromValue(type);
    }

    /**
     * <p>
     * The type of the memory strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MemoryStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the memory strategy.
     * @see MemoryStrategyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Namespaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNamespaces() {
        return namespaces != null && !(namespaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The namespaces associated with the memory strategy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamespaces} method.
     * </p>
     * 
     * @return The namespaces associated with the memory strategy.
     */
    public final List<String> namespaces() {
        return namespaces;
    }

    /**
     * <p>
     * The timestamp when the memory strategy was created.
     * </p>
     * 
     * @return The timestamp when the memory strategy was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the memory strategy was last updated.
     * </p>
     * 
     * @return The timestamp when the memory strategy was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the memory strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemoryStrategyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the memory strategy.
     * @see MemoryStrategyStatus
     */
    public final MemoryStrategyStatus status() {
        return MemoryStrategyStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the memory strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemoryStrategyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the memory strategy.
     * @see MemoryStrategyStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(strategyId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNamespaces() ? namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryStrategy)) {
            return false;
        }
        MemoryStrategy other = (MemoryStrategy) obj;
        return Objects.equals(strategyId(), other.strategyId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasNamespaces() == other.hasNamespaces()
                && Objects.equals(namespaces(), other.namespaces()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemoryStrategy").add("StrategyId", strategyId()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Configuration", configuration()).add("Type", typeAsString())
                .add("Namespaces", hasNamespaces() ? namespaces() : null).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "strategyId":
            return Optional.ofNullable(clazz.cast(strategyId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "namespaces":
            return Optional.ofNullable(clazz.cast(namespaces()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("strategyId", STRATEGY_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryStrategy, T> g) {
        return obj -> g.apply((MemoryStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemoryStrategy> {
        /**
         * <p>
         * The unique identifier of the memory strategy.
         * </p>
         * 
         * @param strategyId
         *        The unique identifier of the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strategyId(String strategyId);

        /**
         * <p>
         * The name of the memory strategy.
         * </p>
         * 
         * @param name
         *        The name of the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the memory strategy.
         * </p>
         * 
         * @param description
         *        The description of the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration of the memory strategy.
         * </p>
         * 
         * @param configuration
         *        The configuration of the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(StrategyConfiguration configuration);

        /**
         * <p>
         * The configuration of the memory strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link StrategyConfiguration.Builder} avoiding
         * the need to create one manually via {@link StrategyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StrategyConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(StrategyConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link StrategyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(StrategyConfiguration)
         */
        default Builder configuration(Consumer<StrategyConfiguration.Builder> configuration) {
            return configuration(StrategyConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The type of the memory strategy.
         * </p>
         * 
         * @param type
         *        The type of the memory strategy.
         * @see MemoryStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryStrategyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the memory strategy.
         * </p>
         * 
         * @param type
         *        The type of the memory strategy.
         * @see MemoryStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryStrategyType
         */
        Builder type(MemoryStrategyType type);

        /**
         * <p>
         * The namespaces associated with the memory strategy.
         * </p>
         * 
         * @param namespaces
         *        The namespaces associated with the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(Collection<String> namespaces);

        /**
         * <p>
         * The namespaces associated with the memory strategy.
         * </p>
         * 
         * @param namespaces
         *        The namespaces associated with the memory strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(String... namespaces);

        /**
         * <p>
         * The timestamp when the memory strategy was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the memory strategy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the memory strategy was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the memory strategy was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the memory strategy.
         * </p>
         * 
         * @param status
         *        The current status of the memory strategy.
         * @see MemoryStrategyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryStrategyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the memory strategy.
         * </p>
         * 
         * @param status
         *        The current status of the memory strategy.
         * @see MemoryStrategyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemoryStrategyStatus
         */
        Builder status(MemoryStrategyStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String strategyId;

        private String name;

        private String description;

        private StrategyConfiguration configuration;

        private String type;

        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryStrategy model) {
            strategyId(model.strategyId);
            name(model.name);
            description(model.description);
            configuration(model.configuration);
            type(model.type);
            namespaces(model.namespaces);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
        }

        public final String getStrategyId() {
            return strategyId;
        }

        public final void setStrategyId(String strategyId) {
            this.strategyId = strategyId;
        }

        @Override
        public final Builder strategyId(String strategyId) {
            this.strategyId = strategyId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final StrategyConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(StrategyConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(StrategyConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MemoryStrategyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String... namespaces) {
            namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemoryStrategyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public MemoryStrategy build() {
            return new MemoryStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
