/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Lambda configuration for a Model Context Protocol target. This structure defines how the gateway uses a Lambda
 * function to communicate with the target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class McpLambdaTargetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<McpLambdaTargetConfiguration.Builder, McpLambdaTargetConfiguration> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaArn").getter(getter(McpLambdaTargetConfiguration::lambdaArn)).setter(setter(Builder::lambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaArn").build()).build();

    private static final SdkField<ToolSchema> TOOL_SCHEMA_FIELD = SdkField.<ToolSchema> builder(MarshallingType.SDK_POJO)
            .memberName("toolSchema").getter(getter(McpLambdaTargetConfiguration::toolSchema))
            .setter(setter(Builder::toolSchema)).constructor(ToolSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD,
            TOOL_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lambdaArn;

    private final ToolSchema toolSchema;

    private McpLambdaTargetConfiguration(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.toolSchema = builder.toolSchema;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function. This function is invoked by the gateway to communicate
     * with the target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function. This function is invoked by the gateway to
     *         communicate with the target.
     */
    public final String lambdaArn() {
        return lambdaArn;
    }

    /**
     * <p>
     * The tool schema for the Lambda function. This schema defines the structure of the tools that the Lambda function
     * provides.
     * </p>
     * 
     * @return The tool schema for the Lambda function. This schema defines the structure of the tools that the Lambda
     *         function provides.
     */
    public final ToolSchema toolSchema() {
        return toolSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(toolSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof McpLambdaTargetConfiguration)) {
            return false;
        }
        McpLambdaTargetConfiguration other = (McpLambdaTargetConfiguration) obj;
        return Objects.equals(lambdaArn(), other.lambdaArn()) && Objects.equals(toolSchema(), other.toolSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("McpLambdaTargetConfiguration").add("LambdaArn", lambdaArn()).add("ToolSchema", toolSchema())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaArn":
            return Optional.ofNullable(clazz.cast(lambdaArn()));
        case "toolSchema":
            return Optional.ofNullable(clazz.cast(toolSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambdaArn", LAMBDA_ARN_FIELD);
        map.put("toolSchema", TOOL_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<McpLambdaTargetConfiguration, T> g) {
        return obj -> g.apply((McpLambdaTargetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, McpLambdaTargetConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function. This function is invoked by the gateway to communicate
         * with the target.
         * </p>
         * 
         * @param lambdaArn
         *        The Amazon Resource Name (ARN) of the Lambda function. This function is invoked by the gateway to
         *        communicate with the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);

        /**
         * <p>
         * The tool schema for the Lambda function. This schema defines the structure of the tools that the Lambda
         * function provides.
         * </p>
         * 
         * @param toolSchema
         *        The tool schema for the Lambda function. This schema defines the structure of the tools that the
         *        Lambda function provides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolSchema(ToolSchema toolSchema);

        /**
         * <p>
         * The tool schema for the Lambda function. This schema defines the structure of the tools that the Lambda
         * function provides.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolSchema.Builder} avoiding the need to
         * create one manually via {@link ToolSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolSchema.Builder#build()} is called immediately and its result
         * is passed to {@link #toolSchema(ToolSchema)}.
         * 
         * @param toolSchema
         *        a consumer that will call methods on {@link ToolSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolSchema(ToolSchema)
         */
        default Builder toolSchema(Consumer<ToolSchema.Builder> toolSchema) {
            return toolSchema(ToolSchema.builder().applyMutation(toolSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String lambdaArn;

        private ToolSchema toolSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(McpLambdaTargetConfiguration model) {
            lambdaArn(model.lambdaArn);
            toolSchema(model.toolSchema);
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final ToolSchema.Builder getToolSchema() {
            return toolSchema != null ? toolSchema.toBuilder() : null;
        }

        public final void setToolSchema(ToolSchema.BuilderImpl toolSchema) {
            this.toolSchema = toolSchema != null ? toolSchema.build() : null;
        }

        @Override
        public final Builder toolSchema(ToolSchema toolSchema) {
            this.toolSchema = toolSchema;
            return this;
        }

        @Override
        public McpLambdaTargetConfiguration build() {
            return new McpLambdaTargetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
